// Generated on 2011 June Sun, 26 at 20:40:49 by the CERTI message generator
#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H
// ****-**** Global System includes ****-****
#include <stdio.h>
#include <string.h>
// ****-**** Includes coming from native types ****-****

#include "MsgBuffer.h"
// The generated file will be put in 
// the MsgTutorial package
package MsgTutorial 

   // Native types has been defined:
   //     - by included headers (see above)
   //     - with typedef (see below [if any])

   typedef uint32_t M_Type;

   typedef char* MStreamType;
   typedef addressbook {
      static const uint32_t versionMajor = 1;
      static const uint32_t versionMinor = 0;

      typedef enum PhoneType {
         MOBILE = 0, 
         HOME, 
         WORK 

      } PhoneType_t; //end of enum PhoneType 

   }

   typedef struct  nmsg {

      typedef enum MessageType {
         NOT_USED = 0, 
         PERSON, 
         ADDRESSBOOK, 
         LAST 

      } MessageType_t; //end of enum MessageType 

      uint32_t type;
      string messageName;
   } nmsg_t; 

   void nmsg_create();
   void nmsg_destroy();

   virtual void nmsg_serialize(nmsg_t* nmsg, MsgBuffer_t* msgBuffer);
   virtual void nmsg_deserialize(nmsg_t* nmsg, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const uint32_t* getType(nmsg_t nmsg) const {return nmsg.type;}
   void setType(nmsg_t nmsg, const uint32_t* newType) {nmsg.type=newType;}
   const string* getMessageName(nmsg_t nmsg) const {return nmsg.messageName;}
   void setMessageName(nmsg_t nmsg, const string* newMessageName) {nmsg.messageName=newMessageName;}
   // the show method
   virtual FILE* show(FILE* out);
   };

   typedef struct  PhoneNumber {
      string number;
      addressbook_PhoneType type;
      bool _hasType;
   } PhoneNumber_t; 

   void PhoneNumber_create();
   void PhoneNumber_destroy();

   void PhoneNumber_serialize(PhoneNumber_t* PhoneNumber, MsgBuffer_t* msgBuffer);
   void PhoneNumber_deserialize(PhoneNumber_t* PhoneNumber, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const string* getNumber(PhoneNumber_t PhoneNumber) const {return PhoneNumber.number;}
   void setNumber(PhoneNumber_t PhoneNumber, const string* newNumber) {PhoneNumber.number=newNumber;}
   const addressbook_PhoneType* getType(PhoneNumber_t PhoneNumber) const {return PhoneNumber.type;}
   void setType(PhoneNumber_t PhoneNumber, const addressbook_PhoneType* newType) {
      _hasType=true;
      PhoneNumber.type=newType;
   }
   bool hasType(PhoneNumber_t PhoneNumber) {return PhoneNumber.Type;}
   // the show method
   FILE* show(FILE* out);
   };

   typedef struct  Person{
      nmsg super;
      string name;
      int32_t id;
      string email;
      bool _hasEmail;
      PhoneNumber* phone;
      uint32 phonesize;
   } Person_t; 

   void Person_create();
   void Person_destroy();

   virtual void Person_serialize(Person_t* Person, MsgBuffer_t* msgBuffer);
   virtual void Person_deserialize(Person_t* Person, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const string* getName(Person_t Person) const {return Person.name;}
   void setName(Person_t Person, const string* newName) {Person.name=newName;}
   const int32_t* getId(Person_t Person) const {return Person.id;}
   void setId(Person_t Person, const int32_t* newId) {Person.id=newId;}
   const string* getEmail(Person_t Person) const {return Person.email;}
   void setEmail(Person_t Person, const string* newEmail) {
      _hasEmail=true;
      Person.email=newEmail;
   }
   bool hasEmail(Person_t Person) {return Person.Email;}
   uint32_t getPhoneSize(Person_t Person) const {return Person.phone.size();}
   void setPhoneSize(Person_t Person, uint32_t num) {Person.phone.resize(num);}
   const PhoneNumber* getPhone() const {return phone;}
   const PhoneNumber* getPhone(Person_t Person, uint32_t rank) const {return Person.phone[rank];}
   PhoneNumber* getPhone(Person_t Person, uint32_t rank) {return Person.phone[rank];}
   void setPhone(Person_t Person, const PhoneNumber* newPhone, uint32_t rank) {Person.phone[rank]=newPhone;}
   void removePhone(uint32_t rank) {Person.phone.erase(phone.begin() + rank);}
   // the show method
   virtual FILE* show(FILE* out);
   };

   typedef struct  AddressBook{
      nmsg super;
      Person* person;
      uint32 personsize;
   } AddressBook_t; 

   void AddressBook_create();
   void AddressBook_destroy();

   virtual void AddressBook_serialize(AddressBook_t* AddressBook, MsgBuffer_t* msgBuffer);
   virtual void AddressBook_deserialize(AddressBook_t* AddressBook, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   uint32_t getPersonSize(AddressBook_t AddressBook) const {return AddressBook.person.size();}
   void setPersonSize(AddressBook_t AddressBook, uint32_t num) {AddressBook.person.resize(num);}
   const Person* getPerson() const {return person;}
   const Person* getPerson(AddressBook_t AddressBook, uint32_t rank) const {return AddressBook.person[rank];}
   Person* getPerson(AddressBook_t AddressBook, uint32_t rank) {return AddressBook.person[rank];}
   void setPerson(AddressBook_t AddressBook, const Person* newPerson, uint32_t rank) {AddressBook.person[rank]=newPerson;}
   void removePerson(uint32_t rank) {AddressBook.person.erase(person.begin() + rank);}
   // the show method
   virtual FILE* show(FILE* out);
   };

   typedef struct  M_Factory {
      public:
         static nmsg* create(M_Type type) throw (string); 
      protected:
      private:
   };

} // end of namespace MsgTutorial 
// ADDRESSBOOK_H
#endif
