// Generated on 2011 June Mon, 27 at 13:19:53 by the CERTI message generator
#ifndef ADDRESSBOOK_HH
#define ADDRESSBOOK_HH
// ****-**** Global System includes ****-****
#include <vector>
#include <string>
// ****-**** Includes coming from native types ****-****

#include "MessageBuffer.hh"
// The generated file will be put in 
// the MsgTutorial package
namespace MsgTutorial {

   // Native types has been defined:
   //     - by included headers (see above)
   //     - with typedef (see below [if any])

   typedef uint32_t M_Type;

   typedef char* MStreamType;
   namespace addressbook {
      static const uint32_t versionMajor = 1;
      static const uint32_t versionMinor = 0;

      typedef enum PhoneType {
         MOBILE = 0, 
         HOME, 
         WORK 

      } PhoneType_t; //end of enum PhoneType 

   }

   class  nmsg {
      public:

         typedef enum MessageType {
            NOT_USED = 0, 
            PERSON, 
            ADDRESSBOOK, 
            LAST 

         } MessageType_t; //end of enum MessageType 

         nmsg();
         virtual ~nmsg();
         virtual void serialize(libhla::MessageBuffer& msgBuffer);
         virtual void deserialize(libhla::MessageBuffer& msgBuffer);
         // specific Getter(s)/Setter(s)
         const uint32_t& getType() const {return type;}
         void setType(const uint32_t& newType) {type=newType;}
         const std::string& getMessageName() const {return messageName;}
         void setMessageName(const std::string& newMessageName) {messageName=newMessageName;}
         // the show method
         virtual std::ostream& show(std::ostream& out);
      protected:
         uint32_t type;
         std::string messageName;
      private:
   };

   class  PhoneNumber {
      public:
         PhoneNumber();
         ~PhoneNumber();
         void serialize(libhla::MessageBuffer& msgBuffer);
         void deserialize(libhla::MessageBuffer& msgBuffer);
         // specific Getter(s)/Setter(s)
         const std::string& getNumber() const {return number;}
         void setNumber(const std::string& newNumber) {number=newNumber;}
         const addressbook::PhoneType& getType() const {return type;}
         void setType(const addressbook::PhoneType& newType) {
            _hasType=true;
            type=newType;
         }
         bool hasType() {return _hasType;}
         // the show method
         std::ostream& show(std::ostream& out);
      protected:
         std::string number;
         addressbook::PhoneType type;
         bool _hasType;
      private:
   };

   class  Person : public nmsg {
      public:
         typedef nmsg Super;
         Person();
         virtual ~Person();
         virtual void serialize(libhla::MessageBuffer& msgBuffer);
         virtual void deserialize(libhla::MessageBuffer& msgBuffer);
         // specific Getter(s)/Setter(s)
         const std::string& getName() const {return name;}
         void setName(const std::string& newName) {name=newName;}
         const int32_t& getId() const {return id;}
         void setId(const int32_t& newId) {id=newId;}
         const std::string& getEmail() const {return email;}
         void setEmail(const std::string& newEmail) {
            _hasEmail=true;
            email=newEmail;
         }
         bool hasEmail() {return _hasEmail;}
         uint32_t getPhoneSize() const {return phone.size();}
         void setPhoneSize(uint32_t num) {phone.resize(num);}
         const std::vector<PhoneNumber>& getPhone() const {return phone;}
         const PhoneNumber& getPhone(uint32_t rank) const {return phone[rank];}
         PhoneNumber& getPhone(uint32_t rank) {return phone[rank];}
         void setPhone(const PhoneNumber& newPhone, uint32_t rank) {phone[rank]=newPhone;}
         void removePhone(uint32_t rank) {phone.erase(phone.begin() + rank);}
         // the show method
         virtual std::ostream& show(std::ostream& out);
      protected:
         std::string name;
         int32_t id;
         std::string email;
         bool _hasEmail;
         std::vector<PhoneNumber> phone;
      private:
   };

   class  AddressBook : public nmsg {
      public:
         typedef nmsg Super;
         AddressBook();
         virtual ~AddressBook();
         virtual void serialize(libhla::MessageBuffer& msgBuffer);
         virtual void deserialize(libhla::MessageBuffer& msgBuffer);
         // specific Getter(s)/Setter(s)
         uint32_t getPersonSize() const {return person.size();}
         void setPersonSize(uint32_t num) {person.resize(num);}
         const std::vector<Person>& getPerson() const {return person;}
         const Person& getPerson(uint32_t rank) const {return person[rank];}
         Person& getPerson(uint32_t rank) {return person[rank];}
         void setPerson(const Person& newPerson, uint32_t rank) {person[rank]=newPerson;}
         void removePerson(uint32_t rank) {person.erase(person.begin() + rank);}
         // the show method
         virtual std::ostream& show(std::ostream& out);
      protected:
         std::vector<Person> person;
      private:
   };

   class  M_Factory {
      public:
         static nmsg* create(M_Type type) throw (std::string); 
      protected:
      private:
   };

} // end of namespace MsgTutorial 
// ADDRESSBOOK_HH
#endif
