// Generated on 2011 July Wed, 20 at 18:05:17 by the CERTI message generator
// ----------------------------------------------------------------------------
// CERTI - HLA Run Time Infrastructure
// Copyright (C) 2010 Andrej Pancik
//
// This program is free software ; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation ; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY ; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program ; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// ----------------------------------------------------------------------------
package certi;

import certi.communication.CertiException;
import certi.communication.MessageBuffer;
import certi.communication.CertiMessageType;
import certi.communication.CertiMessage;
import certi.rti.impl.CertiAttributeHandleSet;
import certi.rti.impl.CertiSuppliedAttributes;
import hla.rti.AttributeHandleSet;
import hla.rti.SuppliedAttributes;
import certi.rti.impl.CertiExtent;
import java.util.List;
import hla.rti.Region;
import hla.rti.FederateHandleSet;
import hla.rti.SuppliedParameters;
import certi.rti.impl.CertiLogicalTime;
import certi.rti.impl.CertiLogicalTimeInterval;
import hla.rti.LogicalTime;
import hla.rti.LogicalTimeInterval;

public class ChangeAttributeOrderType extends CertiMessage {
   private TransportType transport;
   private OrderType order;
   private ObjectHandle object;
   private AttributeHandle attributes;

   public ChangeAttributeOrderType() {
      super(CertiMessageType.CHANGE_ATTRIBUTE_ORDER_TYPE);
   }

   public ChangeAttributeOrderType(CertiLogicalTime federationTime) {
      super(CertiMessageType.CHANGE_ATTRIBUTE_ORDER_TYPE, federationTime);
   }

   @Override
   public void writeMessage(MessageBuffer messageBuffer) {
      super.writeMessage(messageBuffer); //Header

      messageBuffer.write(transport);
      messageBuffer.write(order);
      messageBuffer.write(object);
      messageBuffer.write(attributes);
   }

   @Override
   public void readMessage(MessageBuffer messageBuffer) throws CertiException {
      super.readMessage(messageBuffer); //Header 

      messageBuffer.write(transport);
      messageBuffer.write(order);
      messageBuffer.write(object);
      messageBuffer.write(attributes);
   }

   @Override
   public String toString() {
      return (super.toString() + ", transport: " + transport + ", order: " + order + ", object: " + object + ", attributes: " + attributes);
   }

   public TransportType getTransport() {
      return transport;
   }

   public OrderType getOrder() {
      return order;
   }

   public ObjectHandle getObject() {
      return object;
   }

   public AttributeHandle getAttributes() {
      return attributes;
   }

   public void setTransport(TransportType newTransport) {
      this.transport = newTransport;
   }

   public void setOrder(OrderType newOrder) {
      this.order = newOrder;
   }

   public void setObject(ObjectHandle newObject) {
      this.object = newObject;
   }

   public void setAttributes(AttributeHandle newAttributes) {
      this.attributes = newAttributes;
   }

}

