<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == 0) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_GET["type"]))
{
  ?>

  <h3>Admin's Userlist</h3>
  <table class="maintable" width="80%">
  <tr class="rowberschrift">
      <td><b>ID</b></td>
      <td><b>Username</b></td>
      <td><b>eMail</b></td>
      <td><b>Status</b></td>
      <td><b>Reg-Datum</b></td>
      <td><b>Posts</b></td>
      <td><b>Letzter Post</b></td>
  </tr>
  <?php

  // alle user holen
  $result = sql_select("*", "users", "", NULL, NULL);

  // gast-eintrag berspringen
  $row = sql_fetch_assoc($result);

  // jeden row aus der db holen und in die table einfgen
  $zeile = 2;
  while($row = sql_fetch_assoc($result))
  {
    // letzten post herausfinden
    $postresult = sql_select("*", "posts", "WHERE autor_id=".$row["id"]." ORDER BY created DESC", NULL, NULL);
    $posts = sql_num_rows($postresult);
    if($posts!=0)
    {
      $lastpost = sql_fetch_assoc($postresult);
      $threadresult = sql_select("*", "threads", "WHERE id=".$lastpost["thread"], NULL, NULL);
      $threadergebnis = sql_fetch_assoc($threadresult);
      $lastpost = date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset)." in<br /><a href=\"index.php?action=viewthread&amp;id=".$lastpost["thread"]."#".$lastpost["id"]."\">".$threadergebnis["titel"]."</a>";
    }
    else
    {
      $lastpost = "-";
    }

    echo "<tr class=\"row$zeile\">";
    echo "<td class=\"liste\">"     . $row["id"]       . "</td>\n";
    echo "<td class=\"liste\"><a href=\"index.php?action=admincp&amp;show=userlist&amp;type=edit&amp;id=".$row["id"]."\"><b>"     . htmlspecialchars($row["username"]) . "</b></a></td>\n";
    echo "<td class=\"liste\"><a href=\"index.php?action=sendmail&amp;id=".$row["id"]."\">". str_replace("@", " (at) ", $row["email"])    . "</a></td>\n";
    echo "<td class=\"liste\">";
      if($row["status"]==0) echo "nicht aktiviert";
      if($row["status"]==1) echo "gebannt";
      if($row["status"]==2) echo "aktiviert";
      echo "</td>\n";
    echo "<td class=\"liste\">"     . date("d.m.Y", $row["reg_since"] + $zeitoffset) . "<br />" . date("H:i:s", $row["reg_since"] + $zeitoffset) . "</td>\n";
    echo "<td class=\"liste\">"     . sql_num_rows($postresult) ."</b></td>\n";
    echo "<td class=\"liste\">"     . $lastpost        . "</td>\n";
    echo "</tr>";

    $zeile++;
    if ($zeile>2) $zeile=1;
  }
  ?>
  </table>
  <?php
}
else
{
  //*************************************** edit *************************************
  if($_GET["type"]=="edit")
  {
    if(!isset($_POST["edit_button"]) and !isset($_POST["delete_button"]) and !isset($_POST["delete_bestaetigen"]))
    {
      $user = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$_GET["id"], NULL, NULL));
      ?>
      <h3>Benutzer bearbeiten</h3>
      <form action="./index.php?action=admincp&amp;show=userlist&amp;type=edit&amp;id=<?php echo $user["id"] ?>" method="post">
      <table class="maintable">
      <tr class="row2">
        <td>ID:</td>
        <td><b><?php echo $user["id"]; ?></b></td>
      <tr class="row2">
        <td>Username:</td>
        <td><input type="text" class="inputtext" name="username" value="<?php echo $user["username"] ?>" size="40" /></td>
      </tr>
      <tr class="row2">
        <td>eMail:</td>
        <td><input type="text" class="inputtext" name="email" value="<?php echo $user["email"] ?>" size="40" /></td>
      </tr>
      <tr class="row2">
        <td>ICQ:</td>
        <td><input type="text" class="inputtext" name="icq" value="<?php echo $user["icq"] ?>" size="40" /></td>
      </tr>
      <tr class="row2">
        <td>Status:</td>
        <td><select class="inputtext" name="status" size="1">
        <?php
        echo "<option value=\"0\"";
        if($user["status"]==0) echo " selected";
        echo ">nicht aktiviert</option>\n";
        echo "<option value=\"1\"";
        if($user["status"]==1) echo " selected";
        echo ">gebannt</option>\n";
        echo "<option value=\"2\"";
        if($user["status"]==2) echo " selected";
        echo ">aktiviert</option>\n";
        ?></select></td>
      </tr>
      <tr class="row2">
        <td>Signatur:</td>
        <td><textarea class="inputtext" name="signatur" cols="39" rows="5"><?php echo $user["signatur"] ?></textarea></td>
      </tr>
      <tr class="row2">
        <td>Reg-Datum:</td>
        <td><input class="inputtext" name="reg_since" type="text" size="40" value="<?php echo date("d.m.Y, H:i:s", $user["reg_since"] + $zeitoffset) ?>" /></td>
      </tr>
      <tr class="row2">
        <td>&nbsp</td>
        <td><input type="submit" name="edit_button" value="bearbeiten" /> <input type="submit" name="delete_button" value="lschen" /></td>
      </tr>
      </table>
      </form>
      <?php
    }
    if(isset($_POST["edit_button"]))
    {
      // alle angaben korrekt?
      if(trim($_POST["username"])=="") fehler("Jeder Benutzer muss einen Namen haben!");
      if(trim($_POST["email"])=="") fehler("Jeder Benutzer muss eine E-Mail-Adresse haben!");
      $reg_since = mktime(substr($_POST["reg_since"], 12, 2), substr($_POST["reg_since"], 15, 2), substr($_POST["reg_since"], 18, 2), substr($_POST["reg_since"], 3, 2), substr($_POST["reg_since"], 0, 2), substr($_POST["reg_since"], 6, 4)) - $zeitoffset or fehler("Das angegebene Registrierungs-Datum ist ungltig!");

      // db aktualisieren
      $werte = array(
          "username" => $_POST["username"],
          "email" => $_POST["email"],
          "icq" => $_POST["icq"],
          "status" => $_POST["status"],
          "signatur" => $_POST["signatur"],
          "reg_since" => $reg_since
          );
      sql_update("users", $werte, "WHERE id=".$_GET["id"], NULL, NULL);

      redir("index.php?action=admincp&show=userlist", "Der Benutzer wurde bearbeitet!");
    }
    if(isset($_POST["delete_button"]))
    {
      // besttigung holen
      $user = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$_GET["id"], NULL, NULL));
      ?>
      <h3>Benutzer lschen</h3>
      Wollen Sie den Benutzer <b><?php echo $user["id"]." - ".$user["username"] ?></b> wirklich lschen?<br />
      <form method="POST" action="index.php?action=admincp&amp;show=userlist&amp;type=edit&amp;id=<?php echo $_GET["id"] ?>">
      <input name="delete_bestaetigen" type="submit" value="lschen" />
      </form>
      <?php
    }
    if(isset($_POST["delete_bestaetigen"]))
    {
      // user aus gruppenmembers lschen
      sql_delete("gruppenmembers", "WHERE user_id=".$_GET["id"]);
      // persnliche kalender lschen
      sql_delete("kalender", "WHERE besitzer_id=".$_GET["id"]." AND privat=1");
      // user lschen
      sql_delete("users", "WHERE id=".$_GET["id"]);

      redir("index.php?action=admincp&show=userlist", "Der Benutzer wurde gelscht!");
    }
  }
}
?>