<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// rechte?
if($rechte["suche"] == false) fehler("Sie besitzen nicht die ntigen Zugriffsrechte, um diese Seite anzuzeigen!");

if(!isset($_GET["suchen_knopf"]))
{
  // formular ausgeben
  $result = sql_select("id, titel", "boards", "", NULL, NULL);
  $i = 0;
  while ($ergebnis = sql_fetch_assoc($result))
  {
    $i++;
    $boards[$i]["id"] = $ergebnis["id"];
    $boards[$i]["titel"] = $ergebnis["titel"];
  }
}
else
{
  // suche durchfhren und ergebnisse anzeigen
  if(trim($_GET["suchtext"]) == "") fehler("Sie mssen einen Suchtext eingeben!");
  if(!isset($_GET["boards"])) fehler("Sie mssen mindestens 1 Board durchsuchen!");
  if(!isset($_GET["titel_suchen"]) and !isset($_GET["nachricht_suchen"])) fehler("Sie mssen titel und/oder nachricht durchsuchen!");

  // liste der ids der zu durchsuchenden posts zusammenstellen

  function walkboardids($value)
  {
    global $postids;
    $boardrechte = getboardrechte($value);
    if($boardrechte["lesen"] == true)
    {
      $threads = sql_select("id", "threads", "WHERE board=".$value, NULL, NULL); // alle threads im einzelnen board
      while($thread = sql_fetch_assoc($threads))
      {
        $posts = sql_select("id", "posts", "WHERE thread=".$thread["id"], NULL, NULL); // alle posts im einzelnen thread
        while($post = sql_fetch_assoc($posts))
        {
          $postids[] = $post["id"];
        }
        sql_free_result($posts);
      }
      sql_free_result($threads);
    }
  }
  array_walk($_GET["boards"], 'walkboardids');

  // sql-query-string zusammenbauen
  $such_sql = "SELECT id, thread FROM ".$conf["sql_prefix"]."_posts WHERE (";

  // array mit such-wrtern herstellen
  $keywords1 = explode(" ", $_GET["suchtext"]);
  $keywords = "";
  $kette = false;
  $i = 0;
  function walk_keywords($value, $key)
  {
    global $i, $keywords1, $keywords, $kette;

    if($kette == true)
    {
      $keywords[$i] .= " ".$value;
    }
    else
    {
      $i++;
      $keywords[$i] = $value;
    }

    if(substr($value, 0, 1) == "\"")
    {
      // "anfhrungszeichen-text" beginnt
      $kette = true;
    }
    if(substr($value, -1) == "\"")
    {
      // "anfhrungszeichen-text" ist zuende
      $kette = false;
    }
    if(substr($keywords[$i], 0, 1) == "\"" and substr($keywords[$i], -1) == "\"")
    {
      $keywords[$i] = substr($keywords[$i], 1, -1);
    }
    if($kette == false) $keywords[$i] = "'%".$keywords[$i]."%'";
  }
  array_walk($keywords1, 'walk_keywords');

  function suchstr($wo)
  {
    global $keywords;

    $and = false; $or = false; $andnot = false; $ornot = false;
    $suchstr = "";

    foreach($keywords as $word)
    {
      // ist es AND, OR oder NOT ?
      if($word == "'%AND%'")
      {
        $and = true;
        continue;
      }
      if($word == "'%OR%'")
      {
        $or = true;
        continue;
      }
      if($word == "'%NOT%'")
      {
        // AND NOT oder OR NOT ?
        if($or == true)
        {
          $ornot = true;
        }
        else
        {
          $andnot = true;
        }
        continue;
      }

      if($word != "'%AND%'" and $word != "'%OR%'" and $word != "'%NOT%'")
      {
        // es ist ein suchwort!
        if(($and == true and $andnot == false) or ($or == false and $andnot == false and $ornot == false))
        {
          // AND
          $suchstr .= " AND ".$wo." LIKE ".$word;
        }
        if($or == true and $ornot == false)
        {
          // OR
          $suchstr .= " OR ".$wo." LIKE ".$word;
        }
        if($andnot == true)
        {
          // AND NOT
          $suchstr .= " AND ".$wo." NOT LIKE ".$word;
        }
        if($ornot == true)
        {
          // OR NOT
          $suchstr .= " OR ".$wo." NOT LIKE ".$word;
        }

        //$suchstr .= $wo." LIKE ".$word;
        $and = false; $or = false; $andnot = false; $ornot = false;
      }
    }
    $suchstr = substr($suchstr, 5);
    return $suchstr;
  }

  // in titeln und/oder nachrichten suchen
  if(isset($_GET["titel_suchen"]))
  {
    $such_sql .= "(".suchstr("titel").") ";
    if(isset($_GET["nachricht_suchen"])) $such_sql .= "OR ";
  }
  if(isset($_GET["nachricht_suchen"])) $such_sql .= "(".suchstr("nachricht").")";
  $such_sql .= ") AND (id = 0";
  $i = 0;
  // in welchen posts
  function walkpostids($value)
  {
    global $i, $such_sql;
    $such_sql .= " OR ";
    $such_sql .= "id=".$value;
    $i++;
  }
  array_walk($postids, 'walkpostids');
  $such_sql .= ") AND ";
  // zeitraum
  // -> timestamp von jetzt, daraus den such-timestamp berechnen
  switch($_GET["zeitraum"])
  {
    case "1d":
      $suchzeit = time() - 86400;
      break;
    case "1w":
      $suchzeit = time() - 604800;
      break;
    case "2w":
      $suchzeit = time() - 1209600;
      break;
    case "1m":
      $suchzeit = time() - 2628000;
      break;
    case "3m":
      $suchzeit = time() - 7884000;
      break;
    case "6m":
      $suchzeit = time() - 15768000;
      break;
    case "1y":
      $suchzeit = time() - 31536000;
      break;
    default:
      $suchzeit = 0;
  }
  $such_sql .= "created >= ".$suchzeit.";";
  echo $such_sql;

  if($conf["sql_typ"] == "mysql") $suchposts = mysql_query($such_sql, $link);
  if($conf["sql_typ"] == "postgresql") $suchposts = pg_query($link, $such_sql);
  echo $such_sql; ob_flush();
  if($conf["sql_typ"] == "sqlite") $suchposts = sqlite_query($such_sql, $link);

  // anzahl der gefunden posts pro thread
  while($suchpost = sql_fetch_assoc($suchposts))
  {
    if(!isset($suchthread[$suchpost["thread"]])) $suchthread[$suchpost["thread"]] = 0;
    $suchthread[$suchpost["thread"]]++;
  }

  if(isset($suchthread))
  {
    // ergebnis nach gefundenen posts sortieren
    arsort($suchthread);

    // hiermit ist die eigentliche suche fertig, nur noch fr die ausgabe aufbereiten

    // start und end werte fr die thread-liste feststellen
    if(!isset($_GET["seite"]))
    {
      $seite = 1;
      $threadstart = 0;
    }
    else
    {
      $seite = $_GET["seite"];
      $threadstart = ($seite - 1) * $einstellungen["threadsperpage"];
    }
    $threadzahl = count($suchthread);

    // seiten-navigationsleiste
    // alle $_GET-sachen zu einem string zusammenfgen
    $i = 0;
    function walk_get($value, $key)
    {
      global $get_str, $i;
      if($key != "boards" and $key != "seite")
      {
        if($i != 0) $get_str .= "&amp;";
        $get_str .= $key."=".$value;
        $i++;
      }
    }
    array_walk($_GET,'walk_get');
    function walk_boards($value)
    {
      global $get_str, $i;
      $get_str .= "&amp;boards%5B%5D=".$value;
    }
    array_walk($_GET["boards"], 'walk_boards');

    $seitenzahl = ceil($threadzahl/$einstellungen["threadsperpage"]);
    $startausgeblendet = false;
    $endeausgeblendet = false;
    for($n = 1; $n <= $seitenzahl; $n++)
    {
      if($n < ($seite - 2))
      {
        if($startausgeblendet == false) $startausgeblendet = true;
      }
      if($n <= ($seite + 2) and $n >= ($seite - 2))
      {
        if($n != $seite)
        {
          $seitenlink[$n] = "index.php?".$get_str."&amp;seite=".$n;
        }
        else
        {
          $seitenlink[$n] = "";
        }
      }
      if($n > ($seite + 2))
      {
        if($endeausgeblendet == false)
        {
          $seitenlink["letzte"] = "index.php?".$get_str."&amp;seite=".$seitenzahl;
          $endeausgeblendet = true;
        }
      }
    }

    // array mit allen ausgabefertigen threads erstellen
    $i = -1;
    foreach($suchthread as $key => $value)
    {
      global $i;
      $i++;
      if($i < $threadstart) continue;
      if($i >= ($threadstart + $einstellungen["threadsperpage"])) break;

      $ergebnis = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$key, NULL, NULL));
      $boardrechte = getboardrechte($ergebnis["board"]);

      $threads[$i]["id"] = $ergebnis["id"];

      if($boardrechte["posts"] == true and $ergebnis["status"] == 1)
      {
        $threads[$i]["status"] = "offen";
      }
      else
      {
        $threads[$i]["status"] = "geschlossen";
      }

      // hat der Thread eine Umfrage?
      $umfragen = sql_select("*", "umfragen", "WHERE thread=".$ergebnis["id"], NULL, NULL);
      if(sql_num_rows($umfragen)!=0) $threads[$i]["umfrage"] = true; else $threads[$i]["umfrage"] = false;

      // wieviele seiten hat der thread?
      $anzahlposts = sql_num_rows(sql_select("*", "posts", "WHERE thread=".$ergebnis["id"], NULL, NULL));
      $threadseiten = ceil($anzahlposts / $einstellungen["postsperpage"]);
      if($threadseiten > 1)
      {
        for($n = 1; $n <= $threadseiten; $n++)
        {
          if($n <= $einstellungen["threadsperpage"] )
          {
            $threads[$i]["seitenlink"][$n] = "index.php?action=viewthread&amp;id=".$ergebnis["id"]."&amp;seite=".$n;
          }
          else
          {
            $threads[$i]["seitenlink"]["letzte"] = "index.php?action=viewthread&amp;id=".$ergebnis["id"]."&amp;seite=".$threadseiten;
            break;
          }
        }
      }

      $threads[$i]["titellink"] = "index.php?action=viewthread&amp;id=".$ergebnis["id"];

      $threads[$i]["titel"] = $ergebnis["titel"];

      $threads[$i]["gefundene_posts"] = $value;

      $threads[$i]["boardlink"] = "index.php?action=viewboard&amp;id=".$ergebnis["board"];

      $board = sql_fetch_assoc(sql_select("titel", "boards", "WHERE id=".$ergebnis["board"], NULL, NULL));
      $threads[$i]["boardtitel"] = $board["titel"];

      $threads[$i]["erstellt"] = date("d.m.Y - H:i:s",$ergebnis["created"] + $zeitoffset);

      $userresult = sql_select("*", "users", "WHERE id=".$ergebnis["autor_id"], NULL, NULL);
      $user = sql_fetch_assoc($userresult);
      if($user["id"]!=1 and sql_num_rows($userresult)!=0)
      {
        if($rechte["memberlist"] == true) { $threads[$i]["autorlink"] = "index.php?action=userinfo&amp;id=".$ergebnis["autor_id"]; }
      }
      else
      {
        $threads[$i]["autorlink"] == "";
      }
      $threads[$i]["autorname"] = htmlspecialchars($ergebnis["autor_name"]);

      $postsresult = sql_select("id", "posts", "WHERE thread=".$ergebnis["id"], NULL, NULL);
      $numposts = sql_num_rows($postsresult);
      $threads[$i]["posts"] = $numposts;

      $threads[$i]["hits"] = $ergebnis["hits"];

      if($numposts!=0)
      {
        $lastpostresult = sql_select("*", "posts", "WHERE thread=".$ergebnis["id"]." ORDER BY id DESC", NULL, NULL);
        $lastpost = sql_fetch_assoc($lastpostresult);
        $threads[$i]["lastpostlink"] = "index.php?action=viewthread&amp;id=".$lastpost["thread"]."#".$lastpost["id"];
        $threads[$i]["lastpostdatum"] = date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset);
        $userresult = sql_select("*", "users", "WHERE id=".$lastpost["autor_id"], NULL, NULL);
        if($lastpost["autor_id"]!=1 and sql_num_rows($userresult)!=0)
        {
          if($rechte["memberlist"] == true) { $threads[$i]["lastpostautorlink"] = "index.php?action=userinfo&amp;id=".$lastpost["autor_id"]; }
        }
        else
        {
          $threads[$i]["lastpostautorlink"] = "";
        }
        $threads[$i]["lastpostautor"] = htmlspecialchars($lastpost["autor_name"]);
      }
      else
      {
        $threads[$i]["lastpostlink"] = "";
        $threads[$i]["lastpostdatum"] = "";
        $threads[$i]["lastpostautorlink"] = "";
        $threads[$i]["lastpostautor"] = "";
      }
    }
  }
}

include("./layouts/".$layout."/suche.php");
?>