<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// BB-Code-Parser laden
include("./bbcode_parser.php");
$parser = new HTML_BBCodeParser;

// Smilie-Parser
include("./smilie_parser.php");
?>
<table class="maintable" width="100%">
<tr>
    <td class="leftnav">
        <b>Allgemeine Blogs:</b><br />
        <?php
        $weitereblogs = sql_select("*", "blogs_blogs", "WHERE privat=0 ORDER BY titel ASC");
        while($weiteresblog = sql_fetch_assoc($weitereblogs))
        {
            $weiteresblogrechte = getblogrechte($weiteresblog["id"]);
            if($weiteresblogrechte["lesen"] == true or $weiteresblog["besitzer_id"] == $user["id"])
            {
                ?>
                <a href="index.php?action=module&amp;mod=blogs&amp;id=<?php echo $weiteresblog["id"] ?>"><?php echo $weiteresblog["titel"] ?></a><br />
                <?php
            }
        }
        ?>
        <b>Private Blogs:</b><br />
        <?php
        $weitereblogs = sql_select("*", "blogs_blogs", "WHERE privat=1 ORDER BY titel ASC");
        while($weiteresblog = sql_fetch_assoc($weitereblogs))
        {
            $weiteresblogrechte = getblogrechte($weiteresblog["id"]);
            if($weiteresblogrechte["lesen"] == true or $weiteresblog["besitzer_id"] == $user["id"])
            {
                ?>
                <a href="index.php?action=module&amp;mod=blogs&amp;id=<?php echo $weiteresblog["id"] ?>"><?php echo $weiteresblog["titel"] ?></a>
                <?php
            }
        }
        ?>
    </td>
    <td align="center">
    <?php
    if(!isset($_GET["show"]))
    {
        // blog anzeigen, falls id angegeben, sonst startseite
        if(!isset($_GET["id"]))
        {
            ?>
            <h3>Blogs</h3>
            Whlen Sie ein Blog aus der linken Spalte aus!
            <?php
        }
        else
        {
            // blog anzeigen
            if($aktblogrechte["lesen"] == false and $aktblog["besitzer_id"] != $user["id"]) fehler("Sie haben nicht die ntigen Zugriffsrechte, um diese Seite anzuzeigen!");
            
            ?>
            <h3><?php echo $aktblog["titel"] ?></h3>
            <?php echo $aktblog["beschreibung"] ?><br /><br />
            Besitzer:
            <?php
            // besitzer-info
            $besitzerresult = sql_select("*", "users", "WHERE id=".$aktblog["besitzer_id"]);
            if(sql_num_rows($besitzerresult) != 0)
            {
                //user ist in der datenbank
                $besitzer = sql_fetch_assoc($besitzerresult);
                if($besitzer["id"] != 1)
                {
                    if($rechte["memberlist"] == true)
                    {
                        ?>
                        <a href="index.php?action=userinfo&amp;id=<?php echo $besitzer["id"] ?>"><?php } ?><b><?php echo htmlspecialchars($besitzer["username"]) ?></b><?php if($rechte["memberlist"] == true) { ?></a>
                        <?php
                    }
                }
                else
                {
                    // Gast
                    ?>
                    <b><?php echo htmlspecialchars($aktkalender["besitzer_name"]) ?></b> - <i>(Gast)</i>
                    <?php
                }
            }
            else
            {
                //gelschter user
                ?>
                <b><?php echo htmlspecialchars($aktkalender["besitzer_name"]) ?></b> - <i>(gelschter Benutzer)</i>
                <?php
            }
            ?><br /><br />
            <?php
            // posts anzeigen
            $posts = sql_select("*", "blogs_posts", "WHERE blog=".$aktblog["id"]." ORDER BY id DESC");
            
            $zeile = 2;
            
            while($post = sql_fetch_assoc($posts))
            {
                $posterresult = sql_select("*", "users", "WHERE id=".$post["autor_id"]);
                if(sql_num_rows($posterresult)!=0)
                {
                    //user ist in der datenbank
                    $poster = sql_fetch_assoc($posterresult);
                    if($poster["id"]!=1)
                    {
                        if($rechte["memberlist"] == true)
                        {
                            $autorstring = "<a href=\"index.php?action=userinfo&amp;id=".$poster["id"]."\">";
                        }
                        $autorstring .= "<b>".htmlspecialchars($poster["username"])."</b>";
                        if($rechte["memberlist"] == true)
                        {
                            $autorstring .= "</a>";
                        }
                    }
                    else
                    {
                        // Gast
                        $autorstring = "<b>".htmlspecialchars($post["autor_name"])."</b>";
                    }
                }
                else
                {
                    //gelschter user
                    $autorstring = "<b>".htmlspecialchars($post["autor_name"])."</b>";
                }
                ?>
                <table class="maintable" width="80%">
                <tr class="rowberschrift">
                    <td colspan="3"><?php echo $post["titel"] ?></td>
                </tr>
                <tr class="row<?php echo $zeile ?>">
                    <td colspan="3" class="postnachrichtfeld">
                    <?php
                    if($post["bbcode"] == 1)
                    {
                        $parser->setText($post["text"]);
                        $parser->parse();
                        $text = $parser->getParsed();
                    }
                    else
                    {
                        $text = $post["text"];
                    }
                    if($post["smilies"] == 1)
                    {
                        $text = parse_smilies($text);
                    }
                    echo str_replace("\n", "<br />\n", $text);
                    
                    // signatur?
                    if($post["signatur"] == 1)
                    {
                        if($poster["sig_bbcode"] == 1)
                        {
                            $parser->setText($poster["signatur"]);
                            $parser->parse();
                            $signatur = $parser->getParsed();
                        }
                        else
                        {
                            $signatur = $poster["signatur"];
                        }
                        if($poster["sig_smilies"] == 1)
                        {
                            $signatur = parse_smilies($signatur);
                        }
                        echo str_replace("\n", "<br />\n", "\n___________________\n".$signatur);
                    }
                    ?></td>
                </tr>
                <tr class="row<?php echo $zeile ?>">
                    <td align="left" class="postlinksfeld">
                    Erstellt:
                    <?php echo date("d.m.Y - H:i:s",$post["created"] + $zeitoffset) ?>
                    von:
                    <?php
                    echo $autorstring." ";
                    // modul-links anzeigen
                    if(isset($modlinks["userlinks"]))
                    {
                        foreach($modlinks["userlinks"] as $modtitel => $modlink)
                        {
                            if($modlink["gast"] == true or $post["autor_id"] != 1)
                            {
                                ?>
                                <a href="<?php echo str_replace("{userid}", $post["autor_id"], $modlink["link"]) ?>"><?php echo $modlink["text"] ?></a>
                                <?php
                            }
                        }
                    }
                    
                    if($rechte["mailbox"] == true) { ?><a class="alignleft" href="index.php?action=mailbox&amp;show=neu&amp;type=neu&amp;userid=<?php echo $post["autor_id"] ?>"><?php echo $t_pn ?></a> <?php }
                    if($rechte["sendmail"] == true) { ?><a class="alignleft" href="index.php?action=sendmail&amp;id=<?php echo $post["autor_id"] ?>"><?php echo $t_email ?></a><?php } ?>
                    </td>
                    <td  align="right" class="postlinksfeld">
                    <?php
                    if ($blogrechte["moderieren"] == true or ($post["autor_id"]==$user["id"] and $user["id"] != 1) or $aktblog["besitzer_id"] == $user["id"])
                    {
                        ?><a class="alignright" href="index.php?action=module&amp;mod=blogs&amp;show=bearbeiten&amp;id=<?php echo $post["id"] ?>"><?php echo $t_bearbeiten ?></a><?php
                    }
                    ?></td>
                </tr>
                </table><br /><br />
                <?php
                $zeile++;
                if ($zeile>2) $zeile=1;
            }
            ?>
            <a href="index.php?action=module&amp;mod=blogs&amp;show=neu&amp;blogid=<?php echo $aktblog["id"] ?>">neuer Eintrag</a>
            <?php
        }
    }
    else
    {
        //***************************************** neu *******************************************
        if($_GET["show"] == "neu")
        {
            // neuen eintrag erstellen
            // darf der benutzer in dem Blog posten?
            if($aktblogrechte["schreiben"] == false and $aktblogrechte["moderieren"] == false and $aktblog["besitzer_id"] != $user["id"]) fehler("Sie haben nicht gengend Zugriffsrechte, um diese Seite anzuzeigen!");
            ?>
            <h3>Neuer Eintrag</h3>
            <?php
            if(!isset($_POST["erstellen"]))
            {
                ?>
                <form name="form1" method="POST" action="index.php?action=module&amp;mod=blogs&amp;show=neu&amp;blogid=<?php echo $aktblog["id"] ?>">
                <table class="maintable">
                <tr class="rowberschrift">
                    <td colspan="2">Nachricht</td>
                </tr>
                <tr class="row2">
                    <td>Benutzername:</td><td><?php
                    if($user["id"] == 1)
                    {
                        ?><input class="inputtext" name="autor_name" type="text" size="40" /><?php
                    }
                    else
                    {
                        $autor = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
                        echo htmlspecialchars($autor["username"]);
                    }
                    ?></td>
                </tr>
                <tr class="row2">
                    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
                </tr>
                <tr class="row2">
                    <td>BB-Code:</td><td>
                    <?php $textname = "text"; $formname = "form1"; include("./bbcode_inputs.php") ?>
                    </td>
                </tr>
                <tr class="row2">
                    <td>Text:</td><td><textarea class="inputtext" name="text" cols="39" rows="15"></textarea></td>
                </tr>
                <tr class="rowberschrift">
                    <td colspan="2">Optionen</td>
                </tr>
                <tr class="row2">
                    <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>Smilies aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>Signatur anhngen</td><td><input name="signatur" type="radio" value="1"<?php if($user["auto_sig"] == 1) echo " checked" ?> />Ja <input name="signatur" type="radio" value="0"<?php if($user["auto_sig"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>&nbsp;</td><td><input name="erstellen" type="submit" value="erstellen" /></td>
                </tr>
                </table>
                </form>
                <?php
            }
            else
            {
                // abspeichern
                // ist benutzer eingeloggt -> id gleich bernehmen
                if($user["id"] != 1)
                {
                    $autor = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
                }
                else
                {
                    //poster ist gast, berprfen, ob der name schon vergeben ist
                    $nameresult = sql_select("*", "users", "WHERE username='".$_POST["autor_name"]."'");
                    if(sql_num_rows($nameresult) != 0) fehler("Der Benutzername ist schon an einen registrierten Benutzer vergeben!");
                    $autor["id"] = 1;
                    $autor["username"] = $_POST["autor_name"];
                    if(trim($autor["username"]) == "") fehler("Sie haben keinen Namen angegeben!");
                }
                
                $werte = array(
                    "titel"      => htmlspecialchars($_POST["titel"]),
                    "blog"       => $aktblog["id"],
                    "autor_id"   => $autor["id"],
                    "autor_name" => $autor["username"],
                    "created"    => time(),
                    "text"       => htmlspecialchars($_POST["text"]),
                    "bbcode"     => $_POST["bbcode"],
                    "smilies"    => $_POST["smilies"],
                    "signatur"   => $_POST["signatur"]
                    );
                sql_insert("blogs_posts", $werte);
                
                redir("index.php?action=module&mod=blogs&id=".$aktblog["id"], "Der Eintrag wurde erstellt!");
            }
        }
        //************************************ bearbeiten ******************************************
        if($_GET["show"] == "bearbeiten")
        {
            // post bearbeiten
            // darf der benutzer in dem Blog moderieren?
            if($aktblogrechte["moderieren"] == false and $aktblog["besitzer_id"] != $user["id"] and $aktpost["autor_id"] != $user["id"]) fehler("Sie haben nicht gengend Zugriffsrechte, um diese Seite anzuzeigen!");
            
            if(!isset($_POST["bearbeiten"]) and !isset($_POST["loeschen"]))
            {
                ?><h3>Eintrag bearbeiten</h3>
                <form name="form1" method="POST" action="index.php?action=module&amp;mod=blogs&amp;show=bearbeiten&amp;id=<?php echo $aktpost["id"] ?>">
                <table class="maintable">
                <tr class="rowberschrift">
                    <td colspan="2">Nachricht</td>
                </tr>
                <tr class="row2">
                    <td>Benutzername:</td><td><?php
                    if($aktblogrechte["moderieren"] == true or $aktblog["besitzer_id"] == $user["id"])
                    {
                        ?>
                        <input class="inputtext" name="autor_name" type="text" value="<?php echo $aktpost["autor_name"] ?>" size="<?php
                        //ist der Autor registriert?
                        $autorresult = sql_select("*", "users", "WHERE id=".$aktpost["autor_id"]);
                        $autor = sql_fetch_assoc($autorresult);
                        if(sql_num_rows($autorresult)==0)
                        {
                            // Autor wurde gelscht
                            ?>25" /> <i>gelschter Benutzer</i><?php
                        }
                        if($autor["id"]==1)
                        {
                            // der Autor ist nicht registriert
                            ?>35" /> <i>Gast</i><?php
                        }
                        else
                        {
                            // der Autor ist registriert
                            ?>40" /><?php
                        }
                    }
                    else
                    {
                        // der Autor-Name darf nicht gendert werden
                        ?>
                        <b><?php  echo htmlspecialchars($aktpost["autor_name"]) ?></b><input name="autor_name" type="hidden" value="<?php $aktpost["autor_name"] ?>" />
                        <?php
                    }
                    ?></td>
                </tr>
                <tr class="row2">
                    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo $aktpost["titel"] ?>" /></td>
                </tr>
                <tr class="row2">
                    <td>BB-Code:</td><td>
                    <?php $textname = "text"; $formname = "form1"; include("./bbcode_inputs.php") ?>
                    </td>
                </tr>
                <tr class="row2">
                    <td>Text:</td><td><textarea class="inputtext" name="text" cols="39" rows="15"><?php echo $aktpost["text"] ?></textarea></td>
                </tr>
                <tr class="rowberschrift">
                    <td colspan="2">Optionen</td>
                </tr>
                <tr class="row2">
                    <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($aktpost["bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($aktpost["bbcode"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>Smilies aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($aktpost["smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($aktpost["smilies"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>Signatur anhngen</td><td><input name="signatur" type="radio" value="1"<?php if($aktpost["signatur"] == 1) echo " checked" ?> />Ja <input name="signatur" type="radio" value="0"<?php if($aktpost["signatur"] == 0) echo " checked" ?> />Nein</td>
                </tr>
                <tr class="row2">
                    <td>&nbsp;</td><td><input name="bearbeiten" type="submit" value="bearbeiten" /></td>
                </tr>
                </table>
                </form>
                <?php
            }
            elseif(isset($_POST["bearbeiten"]))
            {
                // db aktualisieren
                ?><h3>Eintrag bearbeiten</h3><?php
                
                if(trim($_POST["autor_name"])=="") fehler("Jeder Name muss Zeichen enthalten!");
                if($aktblogrechte["moderieren"] == true or $aktblog["besitzer_id"] == $user["id"])
                {
                    $postedit["autor_name"] = $_POST["autor_name"];
                    $autorresult = sql_select("*", "users", "WHERE username='".$_POST["autor_name"]."'");
                    $autor = sql_fetch_assoc($autorresult);
                    if(sql_num_rows($autorresult)==0 or $autor["id"]==1)
                    {
                        // der Autor ist nicht registriert
                        $postedit["autor_id"] = 1; // Gast
                    }
                    else
                    {
                        $postedit["autor_id"] = $autor["id"];
                    }
                }
                else
                {
                    $postedit["autor_name"] == $aktpost["autor_name"];
                    $postedit["autor_id"]   == $aktpost["autor_id"];
                }
                if($user["id"] == $aktpost["autor_id"] and $aktblogrechte["moderieren"] == false)
                {
                    // der Autor hat seinen Beitrag selbst bearbeitet
                    $editmsg = "Bearbeitet vom Autor am ".date("d.m.Y, H:i:s", time());
                }
                else
                {
                    // vom Mod bearbeitet
                    $mod = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
                    $editmsg = "Bearbeitet vom Moderator (".htmlspecialchars($mod["username"]).") am ".date("d.m.Y, H:i:s", time())." (Server-Zeit)";
                }
                $postedit["text"] = $_POST["text"]."\n\n".$editmsg;
                $werte = array(
                    "titel"      => htmlspecialchars($_POST["titel"]),
                    "autor_id"   => $postedit["autor_id"],
                    "autor_name" => trim($postedit["autor_name"]),
                    "text"       => htmlspecialchars($postedit["text"]),
                    "bbcode"     => $_POST["bbcode"],
                    "smilies"    => $_POST["smilies"],
                    "signatur"   => $_POST["signatur"]
                    );
                sql_update("blogs_posts", $werte, "WHERE id=".$aktpost["id"]);
                
                redir("index.php?action=module&mod=blogs&id=".$aktblog["id"], "Der Eintrag wurde bearbeitet!");
            }
            elseif(isset($_POST["loeschen"]))
            {
                ?><h3>Eintrag lschen</h3><?php
                // eintrag aus db entfernen
            }
        }
    }
    ?>
    </td>
</tr>
</table>