<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

echo "<a href=\"index.php\">".$einstellungen["titel"]."</a>";
if(isset($_GET["action"]))
{
  switch($_GET["action"])
  {
    case "login":
      echo " -> <a href=\"index.php?action=login\">Login</a>";
      break;
    case "register":
      echo " -> <a href=\"index.php?action=register\">Registrierung</a>";
      break;
    case "logout":
      echo " -> <a href=\"index.php?action=logout\">Logout</a>";
      break;
    case "usercc":
      echo " -> <a href=\"index.php?action=usercc\">Benutzer-Kontroll-Zentrum</a>";
      if(isset($_GET["show"]))
      {
        switch($_GET["show"])
        {
          case "profil":
            echo " -> <a href=\"index.php?action=usercc&amp;show=profil\">Profil</a>";
            break;
          case "passwort":
            echo " -> <a href=\"index.php?action=usercc&amp;show=passwort\">Passwort</a>";
            break;
          case "signatur":
            echo " -> <a href=\"index.php?action=usercc&amp;show=signatur\">Signatur</a>";
            break;
          case "email":
            echo " -> <a href=\"index.php?action=usercc&amp;show=email\">E-Mail-Adresse</a>";
            break;
          case "kalender":
            echo " -> <a href=\"index.php?action=usercc&amp;show=kalender\">Kalender einrichten</a>";
            break;
          case "einstellungen":
            echo " -> <a href=\"index.php?action=usercc&amp;show=einstellungen\">Einstellungen bearbeiten</a>";
            break;
          case "mod":
            if(!isset($_GET["mod"]))
            {
              fehler("Kein Modul ausgewhlt!");
            }
            $modresult = sql_select("*", "module", "WHERE name='".$_GET["mod"]."'");
            if(sql_num_rows($modresult) == 0)
            {
              fehler("Modul nicht gefunden!");
            }
            $aktmodul = sql_fetch_assoc($modresult);
            include("./modules/".$aktmodul["name"]."/nav_bar.php");
            break;
        }
      }
      break;
    case "admincp";
      echo " -> <a href=\"index.php?action=admincp\">Admin's Control Panel</a>";
      if(isset($_GET["show"]))
      {
        switch($_GET["show"])
        {
          case "einstellungen":
            echo " -> <a href=\"index.php?action=admincp&amp;show=einstellungen\">Einstellungen</a>";
            break;
          case "userlist":
            echo " -> <a href=\"index.php?action=admincp&amp;show=userlist\">Benutzerliste</a>";
            if(isset($_GET["type"]) and $_GET["type"]=="edit") echo " -> User bearbeiten/lschen";
            break;
          case "boards":
            echo " -> <a href=\"index.php?action=admincp&amp;show=boards\">Boards und Kategorien verwalten</a>";
            if(isset($_POST["kategorie_erstellen"])) echo " -> Kategorie erstellen";
            if(isset($_POST["kategorie_bearbeiten"])) echo " -> Kategorie bearbeiten";
            if(isset($_POST["kategorie_loeschen"])) echo " -> Kategorie lschen";
            if(isset($_POST["board_erstellen"])) echo " -> Board erstellen";
            if(isset($_POST["board_bearbeiten"])) echo " -> Board bearbeiten";
            if(isset($_POST["board_loeschen"])) echo " -> Board lschen";
            break;
          case "gruppen":
            echo " -> <a href=\"index.php?action=admincp&amp;show=gruppen\">Gruppen verwalten</a>";
            if(isset($_GET["type"]))
            {
              switch($_GET["type"])
              {
                case "neu":
                  echo " -> Gruppe erstellen";
                  break;
                case "bearbeiten":
                  echo " -> Gruppe bearbeiten";
                  break;
              }
            }
            break;
          case "newsletter":
            echo " -> <a href=\"index.php?action=admincp&amp;show=newsletter\">Newsletter senden</a>";
            break;
          case "kalender":
            echo " -> <a href=\"index.php?action=admincp&amp;show=kalender\">Kalender verwalten</a>";
            if(isset($_GET["type"]))
            {
              switch($_GET["type"])
              {
                case "neu":
                  echo " -> Kalender erstellen";
                  break;
                case "bearbeiten":
                  echo " -> Kalender bearbeiten";
                  break;
              }
            }
            break;
          case "faq":
            echo " -> <a href=\"index.php?action=admincp&amp;show=faq\">FAQ verwalten</a>";
            if(isset($_POST["kategorie_erstellen"])) echo " -> Kategorie erstellen";
            if(isset($_POST["kategorie_bearbeiten"])) echo " -> Kategorie bearbeiten";
            if(isset($_POST["kategorie_loeschen"])) echo " -> Kategorie lschen";
            if(isset($_POST["frage_erstellen"])) echo " -> Frage erstellen";
            if(isset($_POST["frage_bearbeiten"])) echo " -> Frage bearbeiten";
            if(isset($_POST["frage_loeschen"])) echo " -> Frage lschen";
            break;
          case "announcements":
            echo " -> <a href=\"index.php?action=admincp&amp;show=announcements\">Ankndigungen verwalten</a>";
            if(isset($_POST["announcement_erstellen"])) echo " -> Ankndigung erstellen";
            if(isset($_POST["announcement_bearbeiten"])) echo " -> Ankndigung bearbeiten";
            if(isset($_POST["announcement_loeschen"])) echo " -> Ankndigung lschen";
            break;
          case "userranks":
            echo " -> <a href=\"index.php?action=admincp&amp;show=userranks\">Benutzerrnge</a>";
            if(isset($_GET["type"]))
            {
              switch($_GET["type"])
              {
                case "bearbeiten":
                  echo " -> Benutzerrang bearbeiten";
                  break;
                case "neu":
                  echo " -> Benutzerrang erstellen";
                  break;
              }
            }
            break;
          case "mod":
            if(!isset($_GET["mod"]))
            {
              fehler("Kein Modul ausgewhlt!");
            }
            $modresult = sql_select("*", "module", "WHERE name='".$_GET["mod"]."'");
            if(sql_num_rows($modresult) == 0)
            {
              fehler("Modul nicht gefunden!");
            }
            $aktmodul = sql_fetch_assoc($modresult);
            include("./modules/".$aktmodul["name"]."/nav_bar.php");
            break;
        }
      }
      break;
    case "activate":
      echo " -> Aktivierung";
      break;
    case "userinfo":
      echo " -> Benutzer-Info";
      break;
    case "memberlist":
      echo " -> <a href=\"index.php?action=memberlist\">Mitglieder</a>";
      break;
    case "viewboard":
      $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$_GET["id"]));
      $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["kategorie"]));
      echo " -> ".$aktkategorie["titel"];
      echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
      break;
    case "viewthread":
      $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$_GET["id"]));
      $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
      $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
      echo " -> ".$aktkategorie["titel"];
      echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
      echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
      break;
    case "newpost":
      if($_GET["type"]=="thread")
      {
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$_GET["boardid"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> Neuer Thread";
      }
      else
      {
        $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$_GET["threadid"]));
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
        echo " -> Antworten";
      }
      break;
    case "moderate":
      if($_GET["type"]=="editpost")
      {
        $aktpost = sql_fetch_assoc(sql_select("*", "posts", "WHERE id=".$_GET["id"]));
        $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$aktpost["thread"]));
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
        echo " -> Moderieren -> Post bearbeiten";
      }
      if($_GET["type"]=="editthread")
      {
        $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$_GET["id"]));
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
        echo " -> Moderieren -> Thread bearbeiten";
      }
      if($_GET["type"]=="editumfrage")
      {
        $aktumfrage = sql_fetch_assoc(sql_select("*", "umfragen", "WHERE id=".$_GET["id"]));
        $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$aktumfrage["thread"]));
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
        echo " -> Moderieren -> Umfrage bearbeiten";
      }
      break;
    case "umfrage":
      $aktthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$_GET["threadid"]));
      $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$aktthread["board"]));
      $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["id"]));
      echo " -> ".$aktkategorie["titel"];
      echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
      echo " -> <a href=\"index.php?action=viewthread&amp;id=".$aktthread["id"]."\">".$aktthread["titel"]."</a>";
      echo " -> Umfrage erstellen";
      break;
    case "sendmail":
      echo " -> E-Mail versenden";
      break;
    case "kalender":
      if(isset($_GET["id"]))
      {
        $aktkalender = sql_fetch_assoc(sql_select("*", "kalender", "WHERE id=".$_GET["id"]));
      }
      else
      {
        $aktkalender = sql_fetch_assoc(sql_select("*", "kalender", ""));
      }
      echo " -> <a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."\">".$aktkalender["titel"]."</a>";

      if(!isset($_GET["show"]))
      {
        $jetzt = getdate(time() + $zeitoffset);

        if(isset($_GET["jahr"]))
        {
          $aktjahr = $_GET["jahr"];
        }
        else
        {
          $aktjahr = $jetzt["year"];
        }
        if(isset($_GET["monat"]))
        {
          $aktmonat = $_GET["monat"];
        }
        elseif(isset($_GET["tag"]))
        {
          $aktmonat = $jetzt["mon"];
        }
        if(isset($_GET["tag"]))
        {
          $akttag = $_GET["tag"];
        }
        if(!isset($_GET["jahr"]) and !isset($_GET["monat"]) and !isset($_GET["tag"]))
        {
          $aktmonat = $jetzt["mon"];
        }

        if(isset($aktmonat))
        {
          switch($aktmonat)
          {
            case 1:  $aktmonatname = "Januar"; break;
            case 2:  $aktmonatname = "Februar"; break;
            case 3:  $aktmonatname = "Mrz"; break;
            case 4:  $aktmonatname = "April"; break;
            case 5:  $aktmonatname = "Mai"; break;
            case 6:  $aktmonatname = "Juni"; break;
            case 7:  $aktmonatname = "Juli"; break;
            case 8:  $aktmonatname = "August"; break;
            case 9:  $aktmonatname = "September"; break;
            case 10: $aktmonatname = "Oktober"; break;
            case 11: $aktmonatname = "November"; break;
            case 12: $aktmonatname = "Dezember"; break;
          }
        }

        echo " -> <a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."\">".$aktjahr."</a>";
        if(isset($aktmonatname)) echo " -> <a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$aktmonat."\">".$aktmonatname."</a>";
        if(isset($akttag)) echo " -> <a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$aktmonat."&amp;tag=".$akttag."\">".$akttag."</a>";
      }
      else
      {
        if($_GET["show"] == "neu")
        {
          echo " -> <a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;show=neu\">Neues Event</a>";
        }
      }
      break;
    case "gruppencp":
      echo " -> <a href=\"index.php?action=gruppencp\">Gruppen-Control-Panel</a>";
      if(isset($_GET["show"]))
      {
        switch($_GET["show"])
        {
          case "info":
            echo " -> Info";
            break;
          case "entfernen":
            echo " -> Mitglied entfernen";
            break;
          case "beitreten":
            echo " -> Gruppe beitreten";
            break;
          case "akzeptieren":
            echo " -> Mitglied akzeptieren";
            break;
        }
      }
      break;
    case "suche":
      echo " -> <a href=\"index.php?action=suche\">Suche</a>";
      break;
    case "faq":
      echo " -> <a href=\"index.php?action=faq\">FAQ</a>";
      break;
    case "onlinelist":
      echo " -> <a href=\"index.php?action=onlinelist\">Online-Liste</a>";
      break;
    case "statistik":
      echo " -> <a href=\"index.php?action=statistik\">Statistik</a>";
      break;
    case "announcement":
      $aktannouncement = sql_fetch_assoc(sql_select("*", "announcements", "WHERE id=".$_GET["id"]));
      if(isset($_GET["kategorie"]))
      {
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$_GET["kategorie"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=announcement&amp;kategorie=".$aktkategorie["id"]."&amp;id=".$aktannouncement["id"]."\">".$aktannouncement["titel"]."</a>";
      }
      if(isset($_GET["board"]))
      {
        $aktboard = sql_fetch_assoc(sql_select("*", "boards", "WHERE id=".$_GET["board"]));
        $aktkategorie = sql_fetch_assoc(sql_select("*", "kategorien", "WHERE id=".$aktboard["kategorie"]));
        echo " -> ".$aktkategorie["titel"];
        echo " -> <a href=\"index.php?action=viewboard&amp;id=".$aktboard["id"]."\">".$aktboard["titel"]."</a>";
        echo " -> <a href=\"index.php?action=announcement&amp;board=".$aktboard["id"]."&amp;id=".$aktannouncement["id"]."\">".$aktannouncement["titel"]."</a>";
      }
      break;
    case "lostpassword":
      echo " -> <a href=\"index.php?action=lostpassword\">Passwort zurcksetzen</a>";
      break;
    case "module":
      if(!isset($_GET["mod"]))
      {
        fehler("Kein Modul ausgewhlt!");
      }
      $modresult = sql_select("*", "module", "WHERE name='".$_GET["mod"]."'");
      if(sql_num_rows($modresult) == 0)
      {
        fehler("Modul nicht gefunden!");
      }
      $aktmodul = sql_fetch_assoc($modresult);
      include("./modules/".$aktmodul["name"]."/nav_bar.php");
      break;
  }
}
?>