<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

function parse_smilies($text)
{
  // alle smilie-codes durch entsprechende img-tags ersetzen
  global $smilieset;
  $text = str_replace(":?:",       "<img src=\"./gfx/smilies/".$smilieset."/question.png\"  alt=\":?:\" />",       $text);
  $text = str_replace(":)",        "<img src=\"./gfx/smilies/".$smilieset."/smile.png\"     alt=\":)\" />",        $text);
  $text = str_replace(":D",        "<img src=\"./gfx/smilies/".$smilieset."/biggrin.png\"   alt=\":D\" />",        $text);
  $text = str_replace(":(",        "<img src=\"./gfx/smilies/".$smilieset."/sad.png\"       alt=\":(\" />",        $text);
  $text = str_replace(";)",        "<img src=\"./gfx/smilies/".$smilieset."/wink.png\"      alt=\";)\" />",        $text);
  $text = str_replace(":o",        "<img src=\"./gfx/smilies/".$smilieset."/surprised.png\" alt=\":o\" />",        $text);
  $text = str_replace(":shock:",   "<img src=\"./gfx/smilies/".$smilieset."/shock.png\"     alt=\":shock:\" />",   $text);
  $text = str_replace(":S",        "<img src=\"./gfx/smilies/".$smilieset."/confused.png\"  alt=\":S\" />",        $text);
  $text = str_replace("8)",        "<img src=\"./gfx/smilies/".$smilieset."/cool.png\"      alt=\"8)\" />",        $text);
  $text = str_replace(":lol:",     "<img src=\"./gfx/smilies/".$smilieset."/lol.png\"       alt=\":lol:\" />",     $text);
  $text = str_replace(":x",        "<img src=\"./gfx/smilies/".$smilieset."/mad.png\"       alt=\":x:\" />",       $text);
  $text = str_replace(":P",        "<img src=\"./gfx/smilies/".$smilieset."/tongue.png\"    alt=\":P\" />",        $text);
  $text = str_replace(":blush:",   "<img src=\"./gfx/smilies/".$smilieset."/blush.png\"     alt=\":blush:\" />",   $text);
  $text = str_replace(":cry:",     "<img src=\"./gfx/smilies/".$smilieset."/cry.png\"       alt=\":cry:\" />",     $text);
  $text = str_replace(":evil:",    "<img src=\"./gfx/smilies/".$smilieset."/evil.png\"      alt=\":evil:\" />",    $text);
  $text = str_replace(":twisted:", "<img src=\"./gfx/smilies/".$smilieset."/twisted.png\"   alt=\":twisted:\" />", $text);
  $text = str_replace(":roll:",    "<img src=\"./gfx/smilies/".$smilieset."/roll.png\"      alt=\":roll:\" />",    $text);
  $text = str_replace(":!:",       "<img src=\"./gfx/smilies/".$smilieset."/exclaim.png\"   alt=\":!:\" />",       $text);
  $text = str_replace(":idea:",    "<img src=\"./gfx/smilies/".$smilieset."/idea.png\"      alt=\":idea:\" />",    $text);
  $text = str_replace(":arrow:",   "<img src=\"./gfx/smilies/".$smilieset."/arrow.png\"     alt=\":arrow:\" />",   $text);
  $text = str_replace(":|",        "<img src=\"./gfx/smilies/".$smilieset."/neutral.png\"   alt=\":|\" />",        $text);
  $text = str_replace(":mrgreen:", "<img src=\"./gfx/smilies/".$smilieset."/mrgreen.png\"   alt=\":mrgreen:\" />", $text);

  return $text;
}
?>