/*****************************************************************************************/
/* Copyright 2008,2009,2010,2011,2012,2013 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
   2008, 2009, 2010, 2011 The GSL Team. */
/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Tampere University of Technology, Department of Signal Processing
   Moscow, Russia / Tampere, Finland */
/****************************************************************************************/

#include "init.h"
#include "errors.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#define TRUE 1
#define FALSE 0
//size of the buffer defined in trajectory determination function traj()
#define MAX_N_CMPPAIRS 100
#define MIN_ISEC 6
#define MIN_PEAK 6

double D(double eps_abs, double eps_rel, double value) {
  return(eps_abs + eps_rel*value);
}
int traj()
{
  int i,j,k,l,m;
  int n=LDIM;
  int p=(int)DIM/LDIM;
  int min_n_isec[p];//Min amount of intersections, that all vars have.
  int min_n_peak[p];//Min amount of peaks, that all vars have.
	
  double E_tper[MAX_N_ISEC][MAX_N_CMPPAIRS][p];//Errors for intersections.
  /* You should uncomment next line if You want counting for peak height in regime */
  /*+definition. */
  //double E_peak[MAX_N_ISEC][MAX_N_CMPPAIRS][MAX_LOCAL_DIM];//Errors for peaks.
  double E_t_peak[MAX_N_PEAKS][MAX_N_CMPPAIRS][p];//Errors for time of peaks. Not used.
  double E,E1;//E---errors for amplitude. E1---helping error.
  int count[p];
  int count_a[p];
  int short cmppairs; //Number of compared variables pairs.
  float period=0.0;
  double regime_ratio[p];
  /*We add numerical values for each dynamical state to the
    value of `regime' variable each time particular regime is
    determined. It would help to debug wrong determination of
    dynamical state. So first we need to nullify `regime' and
    `reg[i]'.*/
  regime=0;
  for(i=0;i<DIM;i++)
    reg[i]=0;
  /******************/
  /**STEADY STATE**/
  for(i=0;i<DIM;i++)
    ss_factor[i]=0.0;
  steady_state(ss_factor);
  /*Here comes criterion of the SS existence*/
  j=0;k=0;
  for(i=0;i<DIM;i++)
    if(ss_factor[i]>0.5){/*50% criterion*/
      reg[i]=SS;/*We have SS for the i-th var*/
      j++;
    }
  E=0;E1=0;/*errors nullifying*/
  if(j==DIM){
    regime+=SS;
    for(i=0;i<DIM;i++){
      for(l=i;l<DIM-p;l+=p){
	E1=xs[n_steps-1][l]-xs[n_steps-1][l+p];
	if(E1>0) E1=-E1;
	E+=E1;
      }
      E=E/LDIM;/*In case LDIM=1 => E=0.*/
      /*Then we decide what is bigger: ihss variables or hss. In
	general, all vars should the same type(hss or ihss), but in
	some case of bad error comparing they can be different.*/
      if(E<eps_abs_am) k--;
      if(E>eps_abs_am) k++;
    }
  }
  if(k>0)
    regime+=IHSS;
  if(k<0)
    regime+=HSS;
  if(j==DIM && LDIM==1)/*j==DIM means all variables in SS, i.e. reg[i]s==SS*/
    regime=SS;/*There is no homogeneous or inhomogeneous states
		in single(not coupled to any other) system*/
  print_regime();
  if(regime>0)/*Regime is SS+...so SS is the dynamical state*/
    return 0;
  /**END OF STEADY STATE**/
  /*========================================================*/
  for(i=0; i<n; i++){
    count[i]=0;
    count_a[i]=0;
    min_n_isec[i]=n_isec[0];
    min_n_peak[i]=n_peaks[0];
    regime_ratio[i]=1.0;/*This is necessary for correct
			  trajectory determination*/
  }
  /*****Creating min of INTERSECTIONS.******/
  for(k=0;k<n;k++){/*...intersections.*/
    for(i=k;i<DIM;i+=n){
      if(n_isec[i] < min_n_isec[k])
	min_n_isec[k] = n_isec[i];
    }
  }
  /**Forming counts (l), if l>0 then additional integration.**/
  j=0;
  while(per_method == 0){
    for(k=0;k<n;k++){
      l=0;
      if(min_n_isec[k] < MIN_ISEC)
	l++;
    }
    m=0;
    for(i=0;i<DIM;i++){
      if(per_ratio[i]>eps_per_ratio)
	m++;
    }
    if(l==0 && m==0)
      break;/* We have enough to form per_ratios(l==0) and
	       convergence to L.C(m==0). */

    /* Additional integration, getting attractor. */
    if(j<traj_trans){
      if(l>0){
	fprintf(stdout,"Too few intersections.\n");
	fprintf(stdout,"Getting attractor...%d\n",j+1);
	run(mynum.method,mynum.trans_time,0,1,1);
	fprintf(stdout,"Done.\n");
      }
      if(m>0){
	fprintf(stdout,"Did not get L.C\n");
	fprintf(stdout,"Getting attractor...%d\n",j+1);
	run(mynum.method,mynum.trans_time,0,1,1);
	fprintf(stdout,"Done.\n");
      }
    }
    j++;
    if(j==traj_trans){
      not_get_flag=TRUE;
      break;
    }
  }
  /*****Creating min of PEAKS.******/
  for(k=0;k<n;k++){
    for(i=k;i<DIM;i+=n){
      if(n_peaks[i] < min_n_peak[k])
	min_n_peak[k] = n_peaks[i];
    }
  }
  /**Forming counts (l), if l>0 then additional integration.**/
  j=0;
  while(per_method == 1){
    l=0;
    for(i=0;i<n;i++){
      if(min_n_peak[i] < MIN_PEAK)
	l++;
    }
    m=0;
    for(i=0;i<DIM;i++){
      if(per_ratio[i]>eps_per_ratio)
	m++;
    }
    if(l==0 && m==0)
      break;/* We have enough to form per_ratios(l==0) and
	       convergence to L.C(m==0).. */
	  
    /* Additional integration, getting attractor. */
    if(j<traj_trans){
      if(l>0){
	fprintf(stdout,"Too few peaks.\n");
	fprintf(stdout,"Getting attractor...%d\n",j+1);
	run(mynum.method,mynum.trans_time,0,1,1);
	fprintf(stdout,"Done.\n");
      }
      if(m>0){
	fprintf(stdout,"Did not get L.C\n");
	fprintf(stdout,"Getting attractor...%d\n",j+1);
	run(mynum.method,mynum.trans_time,0,1,1);
	fprintf(stdout,"Done.\n");
      }
    }
    j++;
    if(j==traj_trans){
      not_get_flag=TRUE;
      break;
    }
  }

  /*==============================================================================
    FORMING ERRORS
    ==============================================================================*/
  /* Creating calculation errors for intersections. A bit of sophisticated code.*/
  if(per_method == 0){
    for(k=0; k < n; k++){ //Looping over certain type of var(local dim).
      cmppairs=0;
      for(l=0; l < p-1; l++){//How many vars of certain type(k).
	for(i=k+l*n; i < DIM-n; i+=n){//Actual stepping over certain type(local dim) of var.
	  for(j=0; j < min_n_isec[k]; j++)//Looping over intersections.
	    E_tper[j][cmppairs][k] = tper[j][k+l*n] - tper[j][i+n];
	  cmppairs+=1;
	  if(cmppairs > MAX_N_CMPPAIRS){fprintf(stdout,"Warning(tper):too much values to store.Missing some.\n");
	    fprintf(stdout,"Try to descrease total time of integration.\n");break;
	  }
	}
      }
    }
  }
  // Creating calculation errors for peaks and time of peaks. Peculiar enough.
  if(per_method == 1){
    for(k=0; k < n; k++){//Looping over certain type of var(local dim).
      cmppairs=0;
      for(l=0; l < p-1; l++){//How many vars of certain type(k).
	for(i=k+l*n; i < DIM-n; i+=n){//Actual stepping over certain type(local dim) of var.
	  for(j=0; j < min_n_peak[k]; j++){//Looping over peaks.
	    // If You decide to uncomment next line You should add for counting
	    //+to the following code. It is superfluous. Not recommended.
	    // Moreover, You should uncomment initializing string at the begining of this
	    //+function.
	    //E_peak[j][cmppairs][k] = x_peak[j][k+l*n] - x_peak[j][i+n];
	    E_t_peak[j][cmppairs][k] = t_peak[j][k+l*n] - t_peak[j][i+n];
	  }
	  cmppairs+=1;
	  if(cmppairs > MAX_N_CMPPAIRS){fprintf(stdout,"Warning(peaks):too much values to store.Missing some.\n");
	    fprintf(stdout,"Try to descrease total time of integration.\n");break;
	  }
	}
      }
    }
  }
  //==================================================================================
  //==================================================================================
  //******************************************************************************************
  // FORMATION OF COUNT[K]S
  // Comparing calculation errors with certain level of error defined by the user(D-function).
  // *******************************************************************************************

  if(per_method == 0){
    for(k=0; k<n; k++){
      period=0.0;
      for(l=k;l<DIM;l+=n){ period=period + big_per[l]/p;}
      for(j=0; j<cmppairs; j++){
	for(i=0; i<min_n_isec[k];i++){
	  if(E_tper[i][j][k] < 0)
	    E_tper[i][j][k] = -E_tper[i][j][k];
	  if(E_tper[i][j][k] > D(eps_abs_tper,eps_rel_tper,period))
	    count[k]+=1;
	}
      }
    }
  }
  if(per_method == 1){
    for(k=0; k<n; k++){
      period=0.0;
      for(l=k;l<DIM;l+=n){period=period + big_per[l]/p;}
      for(j=0; j<cmppairs; j++){
	for(i=0; i<min_n_peak[k];i++){
	  if(E_t_peak[i][j][k] < 0)
	    E_t_peak[i][j][k] = -E_t_peak[i][j][k];
	  if(E_t_peak[i][j][k] > D(eps_abs_peak,eps_rel_peak,period))
	    count[k]+=1;
	}
      }
    }
  }
  //COMPARING AMPLITUDES
  for(k=0;k<n; k++){
    for(i=0;i<p-1;i++){
      for(j=k+i*n; j<DIM-n; j+=n){
	E=ampl[k+i*n] - ampl[j+n];
	if( E < 0 )
	  E = -E;
	if(E > D(eps_abs_am,eps_rel_am,(float)ampl[k+i*n]))
	  count_a[k]+=1;
      }
    }
  }
  //================================================================================================
  //FORMING REGIME RATIOS FROM COUNTS.
  if(per_method == 0){
    for(i=0; i<n ; i++)
      regime_ratio[i] = (double)count[i]/((double)cmppairs*(double)min_n_isec[i]);
  }
  if(per_method == 1){
    for(i=0; i<n ; i++)
      regime_ratio[i] = (double)count[i]/((double)cmppairs*(double)min_n_peak[i]);
  }
  for(i=0; i<n; i++)
    if(regime_ratio[i] > 1.0)
      fprintf(stdout,"RATIO GREATER THAN ONE!");
  //==========================================================================================================

  //REPORTING ABOUT IN-PHASE, ANTI-PHASE and ALL-ANTI-PHASE("WAVE") REGIMES IF THEY EXIST.ALSO ABOUT IHLC.
  //fprintf(stdout,"Regime ratios:\n");

  regime=LC;
  for(i=0;i<n;i++){
    reg[i]=LC;
    if( count_a[i] != 0){
      regime=LC+IHLC;
      reg[i]+=IHLC;
      continue;    
    }
    if(regime_ratio[i] < eps_inregime_ratio){
      regime=HLC+INLC;
      reg[i]+=HLC+IHLC;
      continue;    
    }
	  
    if(per_method == 0){
      E = ((double)cmppairs-1.0)*(double)min_n_isec[i];
      E1 = (double)cmppairs*(double)min_n_isec[i];}
    if(per_method == 1){
      E = ((double)cmppairs-1.0)*(double)min_n_peak[i];
      E1 = (double)cmppairs*(double)min_n_peak[i];}
	  
    if((regime_ratio[i] > eps_inregime_ratio) && (regime_ratio[i] <= E/E1)){
      regime=HLC+OUTLC;/*PANTI*/
      reg[i]+=HLC+OUTLC;/*PANTI*/
      continue;    
    }
    if(regime_ratio[i] > E/E1){
      regime=HLC+ANTILC;/*PANTIALL*/
      reg[i]+=HLC+ANTILC;/*PANTIALL*/
      continue;    
    }

  }
  /******************************************************************************/
  for(i=0;i<n;i++){
    if(reg[i]!=0 && (reg[i]==HLC+ANTILC)){/* If any of var type is in PANTIALL regime then*/
      regime=HLC+ANTILC;            /* total REGIME is PANTIALL. */
      break;
    }
  }
  for(i=0;i<n;i++){
    if(reg[i]!=0 && (reg[i]==IHLC)){/* If any of trajectory is IHLC then total REGIME is IHLC. */
      regime=LC+IHLC;
      break;
    }
  }
  for(i=0;i<n;i++)
    fprintf(stdout,"Var type #%d: %d\n",i+1,reg[i]);
	
  fprintf(stdout,"REGIME: %d\n",regime);
  //===========================================================================================================
  return 0;
}

int get_dynamics_1d(char const *fname)
{
  int i,j,k;
  int frame_size;
  double **frame;
  int varInd = graph.yInd[0];
  trajPeak *peak;
  trajSlope *slope;
  //double *sl_ampl;
  int sl_ampl_size;
  FILE *in = fopen(fname,"r");
  if(in == NULL){
    fprintf(stderr,"Error: could not open file `%s'\n",fname);
    return 10;
  }
  else{
    frame = load_frame(in,frame,&frame_size);
    if(frame == NULL){
      fprintf(stderr,"Error: frame was not loaded\n");
      return 15;
    }
    /* Get info on peaks and troughs */
    peak = peak_trough2(frame,frame_size,varInd);
    free_frame(frame);/* We dont need the frame anymore */
    fclose(in);/* We dont need the file as well */
    sl_ampl_size = peak->size-1;
    if(sl_ampl_size == -1){/* There is no single peak/trough in the system */
      /* If the user trusts his/her time scale, then it is SS */
      printf("SS: no peak/trough was found.\n");
      printf("(Could be not enough data.)\n");
      return 0;
    }
    if(sl_ampl_size < 2){
      /* We need at least 2 amplitudes. However, this is not enough as well. */
      fprintf(stderr,"Error: only %d amplitude(s), get more data.\n",sl_ampl_size);
      return 10;
    }
    if(sl_ampl_size < 4){
      fprintf(stdout,"Warning: too few amplitudes, analysis might be hampered.\n");
    }
    /* Compute slope amplitudes */
    slope = slope_ampl(*peak);
    /* Check the sanity of the amplitudes */
    slope = check_slope_ampl(slope,&sl_ampl_size);
    /* printf("Peak True Table:\n"); */
    /* for(i=0;i<peak->size;i++) */
    /*   printf("%d ",peak->peak_true_table[i]); */
    /* printf("\n"); */
    /* ******************* */
    /* Check the last slope amplitude, compare it with the tolerance, which is
       system-wide and equal to eps_abs_am. */
    if(slope->ampl[sl_ampl_size-1] < eps_abs_am){
      printf("SS: abs.tol=%G.\n",eps_abs_am);
    }
    /* If the last slope amplitude is not sufficiently small, but the whole set(50%) of
       the slope amplitudes going down along the trajectory, this indicates the
       steady state. This is checked from the end to the start direction of the
       trajectory. For the opposite direction see the next <else if> statement.*/
    else if((slope->ampl[sl_ampl_size-2] - slope->ampl[sl_ampl_size-1]) >	\
	    D(eps_abs_am,eps_rel_am,slope->ampl[sl_ampl_size-1])){
      printf("sam[%d]=%G,sam[%d]=%G => ",
	     sl_ampl_size-2,slope->ampl[sl_ampl_size-2],
	     sl_ampl_size-1,slope->ampl[sl_ampl_size-1]);
      j = 1;
      printf("%G%% decrease for mutual slope comparison #%d\n",
	     100*(1-slope->ampl[sl_ampl_size-1]/slope->ampl[sl_ampl_size-2]),j);
      for(i=sl_ampl_size-2;i>0;i--){
	if((slope->ampl[i-1] - slope->ampl[i]) > D(eps_abs_am,eps_rel_am,slope->ampl[i])){
	  j++;
	  printf("sam[%d]=%G,sam[%d]=%G => ",i-1,slope->ampl[i-1],i,slope->ampl[i]);
	  printf("%G%% decrease for mutual slope comparison #%d\n",
		 100*(1-slope->ampl[i]/slope->ampl[i-1]),j);
	}
	else
	  /* Break here since we are interested in monotonical decrease without
	     interruptions. */
	  break;
      }
      /* min 50% of slopes decrease + total decrease > 50% ==> SS */
      if(((double)100*(j+1)/(sl_ampl_size) > 50) &&
	 (100*(1-slope->ampl[sl_ampl_size-1]/slope->ampl[sl_ampl_size-1-j]) > 50)){
	printf("%d of %d(%G%%) slopes demonstrate monotonical decrease\n",
	       j+1,sl_ampl_size,(double)100*(j+1)/(sl_ampl_size));
	printf("SS: total decrease=%G%%,abs.tol=%G,rel.tol=%G\n",
	       100*(1-slope->ampl[sl_ampl_size-1]/slope->ampl[sl_ampl_size-1-j]),
	       eps_abs_am,eps_rel_am);
      }
      else{
	printf("SS: failed to pass 50%% criteria for monotonical decrease.\n");
      }
    }
    /* If the last slope amplitude is not sufficiently small, but the whole set(50%) of
       the slope amplitudes going down along the trajectory, this indicates the
       steady state. This is checked from the start to the end direction of the
       trajectory. For the opposite direction see the previous <else if> statement.*/
    /* if((slope->ampl[0]-slope->ampl[1]) > D(eps_abs_am,eps_rel_am,slope->ampl[1])){ */
    /*   printf("sam[0]=%G,sam[1]=%G => ", */
    /* 	     slope->ampl[0],slope->ampl[1]); */
    /*   j = 1; */
    /*   printf("%G%% decrease for mutual slope comparison #%d\n", */
    /* 	     100*(1-slope->ampl[1]/slope->ampl[0]),j); */
    /*   for(i=2;i<sl_ampl_size;i++){ */
    /* 	if((slope->ampl[i-1] - slope->ampl[i]) > D(eps_abs_am,eps_rel_am,slope->ampl[i])){ */
    /* 	  j++; */
    /* 	  printf("sam[%d]=%G,sam[%d]=%G => ",i-1,slope->ampl[i-1],i,slope->ampl[i]); */
    /* 	  printf("%G%% decrease for mutual slope comparison #%d\n", */
    /* 		 100*(1-slope->ampl[i]/slope->ampl[i-1]),j); */
    /* 	} */
    /* 	else */
    /* 	  /\* Break here since we are interested in monotonical decrease without */
    /* 	     interruptions. *\/ */
    /* 	  break; */
    /*   } */
    /*   /\* min 50% of slopes decrease + total decrease > 50% ==> SS *\/ */
    /*   if(((double)100*(j+1)/(sl_ampl_size) > 50) && */
    /* 	 (100*(1-slope->ampl[j]/slope->ampl[0]) > 50)){ */
    /* 	printf("%d of %d(%G%%) slopes demonstrate monotonical decrease. Checked from the start\n", */
    /* 	       j+1,sl_ampl_size,(double)100*(j+1)/(sl_ampl_size)); */
    /* 	printf("SS: total decrease=%G%%,abs.tol=%G,rel.tol=%G\n", */
    /* 	       100*(1-slope->ampl[j]/slope->ampl[0]), */
    /* 	       eps_abs_am,eps_rel_am); */
    /*   } */
    /*   else{ */
    /* 	printf("SS: failed to pass 50%% criteria for monotonical decrease.\n"); */
    /*   } */
    /* } */
    /* If the final slope amplitude is not small enough, if the amplitudes do not
       monotonically decrease, we have oscillatory regime. */
    else{/* How to sort out the oscillations? */
      j = 0;
      //      k = 0;
      for(i=sl_ampl_size-2;i>0;i--){
        if(fabs(slope->ampl[i] - slope->ampl[sl_ampl_size-1]) <
	   D(eps_abs_am,eps_rel_am,slope->ampl[sl_ampl_size-1])){
	  if(!j)
	    j = sl_ampl_size-1-i;
	  //	  k++;
        }
      }
      if(j == 0){
	/* Do mutual comparisons before giving up saying that cannot recognize the
	   regime. This is for finding monotonical increase of the amplitudes. */
	if((slope->ampl[sl_ampl_size-2] - slope->ampl[sl_ampl_size-1]) <	\
	   D(eps_abs_am,eps_rel_am,slope->ampl[sl_ampl_size-1])){
	  j++;/* First comparison succeeded. */
	  printf("sam[%d]=%G,sam[%d]=%G => ",sl_ampl_size-2,slope->ampl[sl_ampl_size-2],
		 sl_ampl_size-1,slope->ampl[sl_ampl_size-1]);
	  printf("%G%% increase for mutual slope comparison #%d\n",
		 100*slope->ampl[sl_ampl_size-1]/slope->ampl[sl_ampl_size-2],j);
	  for(i=sl_ampl_size-2;i>0;i--){
	    if((slope->ampl[i-1] - slope->ampl[i]) < D(eps_abs_am,eps_rel_am,slope->ampl[i])){
	      j++;
	      printf("sam[%d]=%G,sam[%d]=%G => ",i-1,slope->ampl[i-1],i,slope->ampl[i]);
	      printf("%G%% increase for mutual slope comparison #%d\n",
		     100*slope->ampl[i]/slope->ampl[i-1],j);
	    }
	    else/* Non monotonical increase of the amplitudes. */
	      break;
	  }
	  /* min 50% of slopes increase + total increase > 150% ==> OS. */
	  if(((double)(100*(j+1)/sl_ampl_size) > 50) &&
	     (100*slope->ampl[sl_ampl_size-1-j]/slope->ampl[sl_ampl_size-1] < 50)){
	    printf("%d of %d(%G%%) slopes demonstrate monotonical increase\n",
		   j+1,sl_ampl_size,(double)100*(j+1)/(sl_ampl_size));
	    printf("OS: total increase=%G%%,abs.tol=%G,rel.tol=%G\n",
		   100*slope->ampl[sl_ampl_size-1]/slope->ampl[sl_ampl_size-1-j],
		   eps_abs_am,eps_rel_am);
	  }
	  else
	    printf("OS: failed to pass 50%% criteria for monotonical increase.\n");
	}
	else{
	  printf("OS: could not recognize the regime.\n");
	}
      }
      /* else if((double)(100*(k+1)/sl_ampl_size) < 50){ */
      /* 	printf("OS: failed to pass 50%% criterion.\n"); */
      /* } */
      else
	printf("OS: period-%d,abs.tol=%G,rel.tol=%G.\n",
	       j,eps_abs_am,eps_rel_am);
    }
  }

  return 0;
}

trajSlope *check_slope_ampl(trajSlope *slope, int *sampl_size)
{
  int i = 0;/* Main looping var, holding the amplitude resumption index */
  int j = 0;/* Helping var, holding the amplitude drop index */
  int k;/* Looping var for cutting the non-relevant values */
  int num_removed = 0;/* Number of removed amplitudes */
  int tot_num_ampl = *sampl_size;/* Total number of amplitudes before checking */
  int num_drop = 0;/* Number of amplitude drops. Needed for single drop trajectories. */
  /* Find the max of all amplitudes and take 1% from it. This will be the global
     error level. Either amplitude of the comparison pair should be larger than
     that. */
  double eps = 0.01*gsl_stats_max(slope->ampl,1,(*sampl_size));
  while(i<(*sampl_size-1)){
    if((slope->ampl[i] > eps) || (slope->ampl[i+1] > eps)){
      if((20*slope->ampl[i]) < slope->ampl[i+1]){/* Amplitude boom first */
	/* First <i+1> values are removed, <i+1> holds the postion of the amplitude
	   resumption. */
	num_removed += i+1;
	/* Shift the array by <i+1> position leftwards(to the beginning). */
	for(k=i+1;k<*sampl_size;k++){
	  slope->ampl[k-i-1] = slope->ampl[k];
	  slope->t0[k-i-1] = slope->t0[k];
	  slope->t1[k-i-1] = slope->t1[k];
	}
	*sampl_size = *sampl_size - i - 1;/* Reduce the size and reallocate */
	slope->ampl = (double *)realloc(slope->ampl,(*sampl_size)*sizeof(double));
	slope->t0 = (double *)realloc(slope->t0,(*sampl_size)*sizeof(double));
	slope->t1 = (double *)realloc(slope->t1,(*sampl_size)*sizeof(double));
	i = 0;/* Reset <i> to the beginning, since we removed first elements. */
	continue;/* Do not need to go further, it implied i++ we don't need. */
      }
      if( (0.05*slope->ampl[i]) > slope->ampl[i+1] ){/* Amplitude drop */
	num_drop++;
	j = i;/* We copy the position before the large drop in the amplitude */
	i++;/* Move to the next value */
	/* Move next until we get a large boom or end of the array */
	while(i<(*sampl_size-1)){
	  if((slope->ampl[i] > eps) || (slope->ampl[i+1] > eps)){
	    if((20*slope->ampl[i]) < slope->ampl[i+1])
	      break;
	  }
	  i++;
	}
	/* After the above <i> holds the index(0-based) of the value which is the last
	   of the amplitude array OR the last before the normal size amplitudes
	   resumption. Everything between <j> and <i>(excluding <j>, including <i>)
	   must be cut and removed. */
	num_removed += i-j;
	*sampl_size = *sampl_size - (i-j);/* Reduce the size of the array */
	/* Cut the non-relevant values: elements are preserved until <j>, after <j> we
	   need to do the shift of the values. */
	for(k=j+1;k<*sampl_size;k++){
	  slope->ampl[k] = slope->ampl[k+(i-j)];
	  slope->t0[k] = slope->t0[k+(i-j)];
	  slope->t1[k] = slope->t1[k+(i-j)];
	}
	/* Reallocate memory for the reduced array */
	slope->ampl = (double *)realloc(slope->ampl,(*sampl_size)*sizeof(double));
	slope->t0 = (double *)realloc(slope->t0,(*sampl_size)*sizeof(double));
	slope->t1 = (double *)realloc(slope->t1,(*sampl_size)*sizeof(double));
	i = j;/* To reset the starting point after the reallocation */
      }
    }
    i++;
  }
  printf("Slope check: removed %d/%d slope(s).\n",num_removed,tot_num_ampl);
  gplot_slope_ampl(slope,*sampl_size);
  
  return slope;
}

trajSlope *slope_ampl(const trajPeak peak)
{
  int i;
  //double *sl_ampl = (double *)malloc((peak.size-1)*sizeof(double));
  trajSlope *slope = (trajSlope *)malloc(sizeof(trajSlope));
  slope->ampl = (double *)malloc((peak.size-1)*sizeof(double));
  slope->t0 = (double *)malloc((peak.size-1)*sizeof(double));
  slope->t1 = (double *)malloc((peak.size-1)*sizeof(double));
  FILE *out = fopen("slopeAmpl.dat","w");
  if(slope == NULL){
    fprintf(stderr,"Error: could not allocate trajSlope object\n");
    return NULL;
  }
  for(i=0;i<peak.size-1;i++){
    //sl_ampl[i] = peak.x[i] - peak.x[i+1];
    slope->ampl[i] = peak.x[i] - peak.x[i+1];
    if(slope->ampl[i] < 0)
      slope->ampl[i] = -slope->ampl[i];
    slope->t0[i] = peak.t[i];
    slope->t1[i] = peak.t[i+1];
    /* Writing the file */
    fprintf(out,"%G %G\n",slope->t0[i],slope->ampl[i]);
  }
  gnuplot_cmd(plot_handle,"set term x11 1\n");
  gnuplot_cmd(plot_handle,"set xlabel \"Time\"\n");
  gnuplot_cmd(plot_handle,"set ylabel \"Slope Amplitude\"\n");
  gnuplot_cmd(plot_handle,"plot 'slopeAmpl.dat' ps 3 not\n");
  fclose(out);
  return slope;
}

void gplot_slope_ampl(trajSlope *sampl,int const sampl_size)
{
  int i;
  FILE *out = fopen("slopeAmpl1.dat","w");
  for(i=0;i<sampl_size;i++)
    fprintf(out,"%G %G\n",sampl->t0[i],sampl->ampl[i]);
  gnuplot_cmd(plot_handle,"set term x11 1\n");
  gnuplot_cmd(plot_handle,"replot 'slopeAmpl1.dat' ps 3 not\n");
  fclose(out);
}

int steady_state(double *ss_factor)
{/*This function determines Steady State regime existence being based
   on calculating a difference between variables in the computed
   trajectory. This function returns back how many points are passed
   the criterion of SS.*/

  int i,j;
  double E[DIM];/*It is the difference(error)*/
  double eps=eps_abs_am;/*We use Amplitude absolute error here*/
  for(j=0;j<DIM;j++){
    i=n_steps-1;/*Indexing in C starts from zero=0*/
    while(i>0){/*We moving backward*/
      E[j]=xs[i][j]-xs[i-1][j];if(E[j]<0) E[j]=-E[j];/*Forming the error*/
      if(E[j]>eps)
	{printf("Step of returning %d\n",i);break;}
      i--;
    }
    ss_factor[j]=(ts[n_steps-1]-ts[i])/ts[n_steps-1];
  }
    
  return 0;
}

int print_regime()
{
  int i;
  fprintf(stdout,"Dynamics detected:\n");
  for(i=0;i<DIM;i++){
    if(reg[i]==SS)
      fprintf(stdout,"%s-->SS(%lf)\n",var_name[i],ss_factor[i]);
    else if(reg[i]==LC)
      fprintf(stdout,"%s-->LC(%lf)\n",var_name[i],per_ratio[i]);
    else
      fprintf(stdout,"=%s-->%d=\n",var_name[i],reg[i]);
  }
  fprintf(stdout,"==========\n");
  if(regime==SS)
    fprintf(stdout,"**SS**\n");
  else if(regime==SS+HSS)
    fprintf(stdout,"**HSS**\n");
  else if(regime==SS+IHSS)
    fprintf(stdout,"**IHSS**\n");
  else
    fprintf(stdout,"**%d**\n",regime);

  return 0;
}

int attr_conv(double **dat, int const size)
{
  /* Attractor convergence function */
  /* dat[][] is the 2d array of data points and size is the size of the array */
  /* This function takes the last point of the data and compares it with all previous
     points trying to find the closest vicinity in the phase space. If it finds the
     vicinity with a given accuracy it reports success(0) in getting the
     attractor. Dimension of the data is DIM, to be defined elsewhere. */
  FILE *out;
  double dist;/* the Euclidean distance between points*/
  int i,j,k;
  i = size-1;
  while(i >= 0){
    k = size-1;
    while(k >= 0){
      if(k == i) {
	k--;
	continue;
      }
      dist = 0.0;
      for(j=0;j<DIM;j++)/* Compute the distance */
	dist += (dat[k][j]-dat[i][j])*(dat[k][j]-dat[i][j]);/*avoiding pow function*/
      dist = sqrt(dist);
      if(dist < 0.01) {/* How to determine this error??? */
	printf("k/i/size=%d/%d/%d\n",k,i,size);
	return 0;
      }/* we are at the attractor */
      k--;
    }
    i--;
  }
  fprintf(stdout,"Did not get attractor.\n");
  return 1;/* we are NOT at the attractor, needing more integration or chaos(?) */
}

int period_sort(double * per_ratio)
{
  // Criterion of convergence to limit cycle attractor.
  int i,j,k;
  int count[MAXDIM];
  float period;
  double E[MAX_N_PERIODS-1][MAXDIM]; 
  if(per_method == 0){
    for(i=0; i<DIM; i++){
      count[i]=0;
      k=n_subperiods[i];
      if(n_subperiods[i] == 0) k=k+1;
      for(j=0; j<n_isec[i]-1-k; j++){
	E[j][i] = (double)per[j][i] - (double)per[j+k][i];
	if(E[j][i] < 0)
	  E[j][i] = -E[j][i];
      }
      //Set to unity all elements of per_ratio(this means no convergence to L.C.)
      *(per_ratio+i)=1.0;
    }
    for(i=0;i<DIM; i++){
      k=n_subperiods[i];
      if(n_subperiods[i] == 0) k=k+1;
      for(j=0; j<n_isec[i]-1-k; j++){
	period = (per[j][i] + per[j+k][i]) / 2;
	if(E[j][i] > D(eps_abs_per,eps_rel_per,period))
	  count[i]++;
      }
    }
    for(i=0;i<DIM;i++){
      *(per_ratio+i) = (double)count[i]/((double)n_isec[i] - 1.0 - \
    (double)k);
      if( *(per_ratio+i) < 0 )
	*(per_ratio+i) = 1.0;
      if(*(per_ratio+i) > eps_per_ratio)
	fprintf(stdout,"Did not get attractor: %lf for var #%d(%s)\n",*(per_ratio+i),i+1,var_name[i]);
    }
  }
  if(per_method == 1){
    for(i=0; i<DIM; i++){
      count[i]=0;
      k=n_subperiods[i];
      if(n_subperiods[i] == 0) k=k+1;
      for(j=0; j<n_peaks[i]-1-k; j++){
	E[j][i] = (double)per[j][i] - (double)per[j+k][i];
	if(E[j][i] < 0)
	  E[j][i] = -E[j][i];
      }
      //Set to unity all elements of per_ratio(this means no convergence to L.C.
      *(per_ratio+i)=1.0;
    }
    for(i=0;i<DIM; i++){
      k=n_subperiods[i];
      if(n_subperiods[i] == 0) k=k+1;
      for(j=0; j<n_peaks[i]-1-k; j++){
	period = (per[j][i] + per[j+k][i]) / 2;
	if(E[j][i] > D(eps_abs_per,eps_rel_per,period))
	  count[i]+=1;
      }
    }
    for(i=0;i<DIM;i++){
      *(per_ratio+i) = (double)count[i]/((double)n_peaks[i] - 1.0 - \
    (double)k);
      if( *(per_ratio+i) < 0 )
	*(per_ratio+i) = 1.0;
      if(*(per_ratio+i) > eps_per_ratio)
	fprintf(stdout,"Did not get attractor: %lf for var #%d(%s)\n",*(per_ratio+i),i+1,var_name[i]);
    }
  }
  return 0;
}

int subper(int * spectrum_per,int * n_subperiods)
{/*This functions computes subperiods of the oscillations*/
  int i,j;

  int n_false[MAXDIM],n_true[MAXDIM];
  double E[MAX_N_PERIODS-1][MAXDIM]; 
  float period;
  if(per_method == 0){
    for(i=0; i<DIM; i++){
      n_false[i]=0;
      n_true[i]=0;
      for(j=0; j<n_isec[i]-2; j++){
	E[j][i] = (double)per[0][i] - (double)per[j+1][i];
	if(E[j][i] < 0)
	  E[j][i] = -E[j][i];
      }
      // Set to zeros ALL spectrum_per's elements
      for(j=0;j<MAX_N_ISEC-2;j++){
	*(spectrum_per+j*MAXDIM+i)=FALSE;
      }
      // Set to zeros ALL n_subperiods's elements
      *(n_subperiods+i)=0;
    }
    for(i=0; i<DIM; i++){
      period = per[0][i];
      for(j=0; j<n_isec[i]-2; j++){
	if(E[j][i] > D(eps_abs_per,eps_rel_per,period)){
	  *(spectrum_per+j*MAXDIM+i) = FALSE;
	  n_false[i]+=1;}
	if(E[j][i] < D(eps_abs_per,eps_rel_per,period)){
	  *(spectrum_per+j*MAXDIM+i) = TRUE;
	  if(n_true[i] == 0)
	    *(n_subperiods+i) = j+1;
	  n_true[i]+=1;}
      }
    }
  }
  if(per_method == 1){
    for(i=0; i<DIM; i++){
      n_false[i]=0;
      n_true[i]=0;
      for(j=0; j<n_peaks[i]-2; j++){
	E[j][i] = (double)per[0][i] - (double)per[j+1][i];
	if(E[j][i] < 0)
	  E[j][i] = -E[j][i];
      }
      // Set to zeros ALL spectrum_per's elements
      for(j=0;j<MAX_N_ISEC-2;j++){
	*(spectrum_per+j*MAXDIM+i)=FALSE;
      }
      // Set to zeros ALL n_subperiods's elements
      *(n_subperiods+i)=0;
    }
    for(i=0; i<DIM; i++){
      period = per[0][i];
      for(j=0; j<n_peaks[i]-2; j++){
	if(E[j][i] > D(eps_abs_per,eps_rel_per,period)){
	  *(spectrum_per+j*MAXDIM+i) = FALSE;
	  n_false[i]+=1;}
	if(E[j][i] < D(eps_abs_per,eps_rel_per,period)){
	  *(spectrum_per+j*MAXDIM+i) = TRUE;
	  if(n_true[i] == 0)
	    *(n_subperiods+i) = j+1;
	  n_true[i]+=1;}
      }
    }
  }
  for(i=0; i<DIM; i++){
    if(n_false[i] == 0)
      *(n_subperiods+i) = 0;
  }
  return 0;
}

int get_index_trans(const double **frame, const int frame_size, const double trans_time)
{/* This function is intended for finding index in the loaded <frame> close to the
    time threshold <trans_time> defined by the user. This function is useful, for
    example, when one needs to skip some initial amount of data corresponding to the
    transient dynamics until the system reaches the attractor. The found index is
    pointing to the time value >= trans_time. The function returns the index. */
  /* ************************************************************************* */
  /* Time is always stored in the first row of frame. */
  int i;
  for(i=0;i<frame_size;i++)
    if(frame[0][i] >= trans_time)
      return i;
  return -1;/* Not found */
}

int mol_dist(const int n_frames,const int bin)
{/* The function creates the molecular/species distribution of the stochastic time
    series. It takes the current data file as a source for downloading the frames,
    number of which to consider is specified in n_frames. Number of bins for the
    histogram is specified by bin.*/
  int data_offset,i,frame_size,total_frame_size;
  /* First get info about the time series */
  int *info;
  FILE *in = fopen(data_name,"r");
  if((info=get_info_data(info,in)) == NULL){
    fprintf(stderr,"Error occurred. Exit.");
    return 10;
  }
  fclose(in);
  /* Then we load the frames */
  double **frame;
  in = fopen(data_name,"r");
  if(info[0])
    data_offset = 1;/* We need to skip first frame, since it is determ */
  else/* Only if not complex run then it is possible to have hist for determ */
    data_offset = 0;
  for(i=0;i<data_offset;i++){/* Skip the offset frames, at max 1 */
    frame = load_frame(in,frame,&frame_size);
    if(frame == NULL){
      fprintf(stderr,"Error: frame was not loaded.\n");
      return 14;
    }
    free_frame(frame);
  }
  for(i=0;i<n_frames;i++){/* Load actual stoch frames */
    frame = load_frame(in,frame,&frame_size);
    if(i == 0)
      total_frame_size = frame_size;
    else
      total_frame_size = total_frame_size + frame_size;
    if(frame == NULL){
      fprintf(stderr,"Error: frame was not loaded.\n");
      return 15;
    }
  }
  /* Finally, we compute histogram */
  double **hist;
  if(perVarInd == -1){
    /* Automatic detection of the variable: by the largerst amplitude, which is
       computed automatically along with the run().*/
    perVarInd = gsl_stats_max_index(ampl,1,DIM);
    hist = compute_hist_per(hist,frame[perVarInd+1],	\
			    total_frame_size,bin);
    perVarInd = -1;
  }
  else{
    hist = compute_hist_per(hist,frame[perVarInd+1],	\
			    total_frame_size,bin);
  }
  write_histPer_file(hist,bin,"hist.dat","w");
  if(graph_flag){/* print histogram */
    graph_set_labels(graph,"mdist");
    gnuplot_cmd(plot_handle,"set title \"n=%d\"\n",total_frame_size);
    gnuplot_cmd(plot_handle,"plot 'hist.dat' u 1:2 w boxes ls 1\n");
  }
  free_frame(frame);
  return 0;
}
