<?PHP
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Free Web Based Training System                          //
// ------------------------------------------------------------------------- //
// <G a n e s h a> - Plate-forme de tlformation gratuite et en open source //
// ------------------------------------------------------------------------- //
// Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>          //
// ------------------------------------------------------------------------- //
//            Developer : Georges CALDEIRA <gcaldeira@anemalab.org>          //
// ------------------------------------------------------------------------- //
//               Infos on project <http://anemalab.org/>                     //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //

/**
* Page inscription de la partie Admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaAdmin
*/
	/**
	* include des fichiers + verification de la cnx
	*/
	include_once("anema.inc.php");
	
	debugf(__FILE__);

	/**#@+
    * @access public
	* @ignore
	*/
	define('SUBMENU',	MENU_INSCRIPTION)	;
	define('ACTION',	$HTTP_GET_VARS['action'])	;
	define('CODE',		(isset($HTTP_GET_VARS['code'])?urldecode($HTTP_GET_VARS['code']):'0'));
	define('PAGE',		HTTP_ADMIN.$PAGE_ADMIN[SUBMENU]."?connexion=".$gconnexionid)	;
	/**#@-*/
	
/**
* Gestion de la page inscription de l'admin
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaAdmin
*/
class PageInscriptionAdmin {
		
	/**
	* Affiche la liste des societes
	* @access	public
	*/
     function liste() { 
	 	global $ClsInscription, $ad_menu, $color3, $ad_titre, $ad_form, $ad_texte ;
	    GetTitre($ad_menu[1]);

		$ajouter= PAGE.'&action=add';
		put('<center><a class="student" href="'.$ajouter.'" >'.IMG_ADD.'&nbsp;'.$ad_titre['ajtinsc'].'</a></center>');
		BR();

		$ret = $ClsInscription->read() ;
		
		for($i=0;$i<$ret['cnt'];$i++) {
			BeginBorder("90%",$color3);	
			SubTitle(CSS($ret[$i]['code']));
			InitTableau();
			DebutLigne();
			TitreTableau($ad_form['date'],25);
			TitreTableau($ad_form['listegrp'],25);
			TitreTableau($ad_form['etat'],15);
			TitreTableau($ad_form['nbrinsc']	,20);
			TitreTableau($ad_form['action'],15);
			FinLigne();
			DebutLigne()	;
			ColTableau('&nbsp;'.date(FORMATDATE ,$ret[$i]['date']))	;
			$groupe = '' ;
			for($j=0;$j<count($ret[$i]['groupe']);$j++) {
				$groupe.= '&nbsp;'.$ret[$i]['groupe'][$j].'<br>';
			} 
			if ( $groupe == '' ) {
				$groupe = '&nbsp;';
			}
			ColTableau($groupe)	;
			ColTableau('&nbsp;'.($ret[$i]['etat']==0?$ad_texte['arrete']:$ad_texte['active']))	;
			ColTableau('&nbsp;'.$ret[$i]['nb'])	;
			$modif	= PAGE.'&action=modif&code='.urlencode($ret[$i]['code']);
			$lmodif	= '<a href="'.$modif.'" >'.IMG_MODIF.'</a>';
			$del	= PAGE.'&action=delete&code='.urlencode($ret[$i]['code']);
			$ldel	= '<a href="#" onclick="DeleteItem(\''.$del.'\');" >'.IMG_DEL.'</a>';
			$laction = '<center>'.$ldel.'&nbsp;'.$lmodif.'</center>';			
			ColTableau('&nbsp;'.$laction)	;
			FinLigne()		;
			FermeTableau();
			BR();
			CloseBorder();
			BR();
		}
        GoTop();
     }

	/**
	* Supprime un item de la table
	* @access	public
	*/
	function del() {
		global $ClsMembre ;	
		$this->liste();
	}

	/**
	* Affiche un formulaire pour modifier une societe
	* @access	public
	*/
     function modif() { 
		global $ad_menu, $ClsInscription, $ad_texte ;
		GetTitre($ad_menu[3]);
		GoBack();
		$ret = $ClsInscription->readInsciption(CODE);
        BeginFormulaire(PAGE.'&action=modif&code='.urlencode(CODE)) ;
        AddText($ad_texte['codeinscr'],Unreplace(CODE),1) ;
        AddCheck($ad_texte['activ_arret'],'etat',2,$ret['etat']);
        AddHidden(CODE,3);
        SelectGroupeInscription($ret['groupe'], $ret['id_groupe']);
		EndFormulaire('VerifInscription');
		GoTop();
     }

	/**
	* Affiche un formulaire pour une societe
	* @access	public
	*/
	function add() {
		global $ad_menu, $ad_texte ;
		GetTitre($ad_menu[2]);
		GoBack();
		BeginFormulaire(PAGE.'&action=add');
		AddText( $ad_texte['codeinscr'],'',1);
		SelectGroupe(AUCUN);	
		EndFormulaire('VerifAddInscription');
		GoTop();		
	}

	/**
	* Traitement des variables POST et redirection
	* @access	public
	*/	
	function traite_post() {
		global $HTTP_POST_VARS, $ClsInscription ;
		if (count($HTTP_POST_VARS) > 0) {
			$url = 	PAGE.'&action=liste';
			switch(ACTION) {
			case 'add'	:	
				$code		= trim($HTTP_POST_VARS['text1'])	;
				$nbgroupe	= (isset($HTTP_POST_VARS['nbgroupe'])?$HTTP_POST_VARS['nbgroupe']:0)	;
				for ($i=0;$i<$nbgroupe;$i++) {
					if ( $HTTP_POST_VARS['checkGroupe'.$i] != '' ) {
						$groupes[] = $HTTP_POST_VARS['checkGroupe'.$i] ;
					}
				}
				$ClsInscription->add($code,$groupes);
				location($url);
				exit();
				break;
			case 'modif':	
				$code		= trim($HTTP_POST_VARS['text1']);
				$oldcode	= trim($HTTP_POST_VARS['text3']);
				$etat		= (isset($HTTP_POST_VARS['check2'])?1:0);				
				$nbgroupe	= (isset($HTTP_POST_VARS['nbgroupe'])?$HTTP_POST_VARS['nbgroupe']:0)	;
				$groupes= array() ;
				for ($i=0;$i<$nbgroupe;$i++) {
					if ( isset($HTTP_POST_VARS['checkGroupe'.$i]) && $HTTP_POST_VARS['checkGroupe'.$i] != '' ) {
						$groupes[] = $HTTP_POST_VARS['checkGroupe'.$i] ;
					}
				}
				$ClsInscription->update($code,$groupes,$etat,$oldcode);
				location($url);
				exit();				
				break;
			}
		}
	}

	/**
	* Traitement des variables GET et redirection
	* @access	public
	*/		
	function traite_get() {
		global $ClsInscription ;
		if (CODE != '' ) {
			switch(ACTION) {
			case 'delete':	
				$ClsInscription->del(CODE) ;
				location(PAGE.'&action=liste');
				exit();
				break;
			}
		}
	}

} // class 


/**
* Instance de la classe PageInscriptionAdmin
* @var	object	PageInscriptionAdmin
*/
$ClsPageAdmin = new PageInscriptionAdmin ;

	
	// Affichage de la page
	pageAdmin();

?>