<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion du tracking
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder au tracking
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Tracking {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise la connexion locale
	* @access	public
	*/
	function Tracking() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* Retourne le nombre de chapitre 'tracke' pour le module d'un user.
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idg Id du groupe
	* @return	integer	Retourne le nombre de chapitre 'tracke' pour le module d'un user.
	* @access	public
	*/
	function NbChapterTracked($idu,$idm,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT chapitre_id FROM ".$TBL['tracking']." " ;
		$sSQL.= "WHERE module_id=".$idm." AND user_id=".$idu." AND groupe_id=".$idg;
		$db->query($sSQL)	 ;
		$nb = $db->num_rows();
		$db->free()			 ;
		return($nb)			 ;
	}

	/**
	* Retourne la note moyenne pour le chapitre d'un module
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @param	integer	$idg Id du groupe	
	* @return	integer	Retourne la note moyenne pour le chapitre d'un module. -1 si aucune note.
	* @access	public
	*/
	function Moyenne($idu,$idm,$idc,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT score,time FROM ".$TBL['tracking']." " ;
		$sSQL.= "WHERE module_id=".$idm." AND chapitre_id=".$idc." AND user_id=".$idu." ";
		$sSQL.= "AND groupe_id=".$idg;
		$db->query($sSQL);
		$nb = $db->num_rows();
		if ( $nb == 0 ) {
			return(0);
		} else {
			$score = 0 ;
			while( $db->next_record() ) {
				$score += $db->f('score');
			}
		}
		$db->free()		 ;
		return($score/$nb);
	}

	/**
	* Ajoute un nouveau 'tracking' dans la base
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @param	integer	$note note a ajouter
	* @param	integer	$temps temps de realisation du test
	* @access	public
	*/
	function Add($idu,$idm,$idc,$note,$temps,$idg,$max_score=0,$status='') {
	 global $TBL, $db ;
	 	$stat = ($status==''?COMPLETED:$status);
		$date = getdate()	;
		$date = $date["0"]	;
		$sSQL = "insert into ".$TBL['tracking']." (user_id,module_id,chapitre_id,date,score,time,groupe_id,max_score,status) "	;
		$sSQL.= "values (".$idu.",".$idm.",".$idc.",'".$date."',".$note.",".$temps.",".$idg.",".$max_score.",'".$stat."') "	;
		$db->query($sSQL);
	}

	/**
	* Ajoute un nouveau 'tracking' normalise
	* @param	array	$tab Tableau avec tous les elements d'un nouveau tracking
	* @access	public
	*/
	function addg($tab) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['gtracking']." WHERE cnx=".$tab['connexion']	;	
		$db->query($sSQL); 
		$sSQL = "INSERT INTO ".$TBL['gtracking']." (cnx,user_id,groupe_id,module_id,chapitre_id,date,score,max_score,time,status)"	;
		$sSQL.= "VALUES (".$tab['connexion'].",'".$tab['user']."','".$tab['groupe']."','".$tab['module']."',";
		$sSQL.= "'".$tab['chapitre']."','".$tab['date']."','".$tab['score']."','".$tab['max_score']."',";
		$sSQL.= "'".$tab['time']."','".$tab['status']."') "	;
		$db->query($sSQL);
	}

	/**
	* maj du nouveau 'tracking' dans la table tracking
	* @param	string	connexion
	* @access	public
	*/
	function updateg($cnx) {
	 global $TBL, $db ;
		$sSQL = "SELECT user_id,groupe_id,module_id,chapitre_id,date,score,max_score,time,status " ;
		$sSQL.= "FROM ".$TBL['gtracking']." WHERE cnx=".$cnx ;
		$db->query($sSQL);
		$ret = -1 ;
		if ( $db->num_rows() > 0 ) {
			$db->next_record() ;
			if ( is_integer($db->f('time')) ) {
				$time = $db->f('time');
			} else {
				$tab = explode(':',$db->f('time'));
				for($i=0;$i<count($tab);$i++) {
					$time = 0 + $tab[$i];
				}
			}
			$this->Add( $db->f('user_id'),$db->f('module_id'),$db->f('chapitre_id'),
						$db->f('score'),$time,$db->f('groupe_id'),$db->f('max_score'),
						$db->f('status'));
			$ret = $db->f('chapitre_id') ;		
			$sSQL = "DELETE FROM ".$TBL['gtracking']." WHERE cnx=".$cnx ;
			$db->query($sSQL);
		}
		return($ret);
	}	

	/**
	* Supprime le module d'un user
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idg Id du groupe	
	* @access	public
	*/
	function del($idu,$idm,$idg) {
	 global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['tracking']." "	;
		$sSQL.= "WHERE user_id=".$idu." AND module_id=".$idm." AND groupe_id=".$idg	;		
		$db->query($sSQL);
	}

	/**
	* Supprime un module 
	* @param	integer	$idm Id du module
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function delModule($idm,$idg) {
	 	global $TBL, $db ;
	 	$grp = '' ;
	 	if ( $idg != 0 ) {
	 		$grp = " AND groupe_id=".$idg	;
		}
		$sSQL = "DELETE FROM ".$TBL['tracking']." ";
		$sSQL.= "WHERE module_id=".$idm.$grp	;
		$db->query($sSQL);
	}

	/**
	* Supprime un groupe 
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function delGroupe($idg) {
	 	global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['tracking']." WHERE groupe_id=".$idg	;
		$db->query($sSQL);
	}
		
	/**
	* Supprime un chapitre 
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @access	public
	*/
	function delChapitre($idm,$idc) {
	 	global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['tracking']." ";
		$sSQL.= "WHERE module_id=".$idm." AND chapitre_id=".$idc	;
		$db->query($sSQL);
	}
		
	/**
	* Retourne le nombre de tracking stocke dans la base pour le membre $idu
	* @param	integer	$idu Id du membre
	* @param	integer	$idg Id du groupe
	* @return	integer	Retourne le nombre de tracking stocke dans la base pour le membre $idu
	* @access	public
	*/
	function Nb($idu,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT module_id FROM ".$TBL['tracking']." ";
		$sSQL.= "WHERE user_id=".$idu." AND groupe_id=".$idg	; ;
		$db->query($sSQL)		;
		$nb = $db->num_rows()	;
		$db->free()				;
		return($nb)				;
	}

	/**
	* Retourne le nombre de tracking stocke pour le membre $idu 
	* concernant le chapitre $idc du module $idm
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @param	integer	$idg Id du groupe
	* @return	integer	Retourne le nombre de tracking stocke pour le membre $idu 
	* @access	public
	*/
	function NbTrackingByChapter($idu,$idm,$idc,$idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT module_id FROM ".$TBL['tracking']." ";
		$sSQL.= "WHERE user_id=".$idu." AND chapitre_id=".$idc." AND module_id=".$idm ;
		$sSQL.= " AND groupe_id=".$idg ;
		$db->query($sSQL)		;
		$nb = $db->num_rows()	;
		$db->free()				;
		return($nb)				;
	}

	/**
	* Retourne le nombre de tracking stocke pour le membre $idu 
	* concernant le module $idm
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idg Id du groupe
	* @return	integer	Retourne le nombre de tracking stocke pour le membre $idu 
	* @access	public
	*/
    function NbTracking($idu,$idm,$idg) { 
	global $TBL, $db ;
        $sSQL = "SELECT module_id FROM ".$TBL['tracking']." "	;
        $sSQL.= "WHERE user_id=".$idu." AND module_id=".$idm." AND groupe_id=".$idg	;
		$db->query($sSQL)		;
        $nb = $db->num_rows()	;
		$db->free()				;
        return $nb				;
    }

	/**
	* Initialise la liste avec le resultat du tracking pour le membre $idu
	* @param	integer	$idu Id du membre
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function readTrackingUser($idu,$idg) {
	 global $TBL;
		$sSQL = "SELECT module_id,chapitre_id,date,score,time,status FROM ".$TBL['tracking']." ";
		$sSQL.= "WHERE user_id=".$idu." AND groupe_id=".$idg." " ;
		$sSQL.= "ORDER BY module_id ASC, chapitre_id ASC,date DESC" ;
		$this->_db->query($sSQL);
		$ret = false ;
		while ($this->_db->next_record() ) {
			$module = $this->_db->f("module_id")			;
			$chapitre = $this->_db->f("chapitre_id")		;
			$date = date(FORMATDATE,$this->_db->f("date"))	;
			$ret[$module][$chapitre][$date]['note'] = $this->_db->f("score")	;
			$ret[$module][$chapitre][$date]['temps'] = $this->_db->f("time")	;
			$ret[$module][$chapitre][$date]['status'] = $this->_db->f("status")	;
		}
		$this->_db->free()	;
		return($ret)		;
	}

	/**
	* Initialise la liste avec le resultat du tracking pour le membre $idu
	* concernant le module $idm
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function InitListModule($idu,$idm,$idg) {
	 global $TBL;
		$sSQL = "SELECT chapitre_id,date,score,time FROM ".$TBL['tracking']." "	;
		$sSQL.= "WHERE user_id=".$idu." AND module_id=".$idm." AND groupe_id=".$idg." "	;
		$sSQL.= "ORDER BY chapitre_id ASC,date DESC,score ASC,time ASC"			;
		$this->_db->query($sSQL)												;
	}

	/**
	* Initialise la liste avec le resultat du tracking pour le membre $idu avec des dates Ascendates
	* concernant le chapitre $idc du module $idm
	* @param	integer	$idu Id du membre
	* @param	integer	$idm Id du module
	* @param	integer	$idc Id du chapitre
	* @param	integer	$idg Id du groupe
	* @access	public
	*/
	function InitListChapterA($idu,$idm,$idc,$idg) {
	 global $TBL;
		$sSQL = "SELECT chapitre_id,date,score,time FROM ".$TBL['tracking']." "	;
		$sSQL.= "WHERE user_id=".$idu." AND chapitre_id=".$idc." AND module_id=".$idm." "	;
		$sSQL.= "AND groupe_id=".$idg." "	;
		$sSQL.= "ORDER BY chapitre_id ASC,date ASC, score ASC,time ASC"	;
		$this->_db->query($sSQL)	;
	}

	/**
	* Retourne l'enregistrement suivant
	* @return	arrayt	Retourne un tableau avec les informations concernant un module
	* @access	public
	*/
	function NextItemUser() {
		if ($this->_db->next_record() ) {
			$ret['moduleId']	= $this->_db->f("module_id")				;
			$ret['chapitreId']	= $this->_db->f("chapitre_id")				;
			$ret['date']		= date("j/m/Y  H:i",$this->_db->f("date"))	;
			$ret['note']		= $this->_db->f("score")						;
			$ret['temps']		= $this->_db->f("time")					;
		} else {
			$ret = false ;
		}
		return($ret);
	}

	/**
	* Retourne l'enregistrement suivant
	* @return	integer	Retourne un tableau avec les informations concernant un module
	* @access	public
	*/
	function NextItem() {
		if ( $this->_db->next_record() ) {
			$ret['chapitreId']	= $this->_db->f(0)				;
			$ret['date']		= date("j/m/Y  H:i",$this->_db->f("date"))	;
			$ret['note']		= $this->_db->f("score")						;
			$ret['temps']		= $this->_db->f("time")					;
			$ret['moduleId']	= $this->_db->f("module_id")				;
		} else {
			$ret = false ;
		}
		return($ret);
	}

}// class Tracking

/**
* Instance de la classe Tracking
* @var	object	Tracking	$ClsTracking
*/
$ClsTracking = new Tracking ;

?>