<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des valuations annexes
*
* @author		Eric Villard <evillard@nef.fr>
* @package		GaneshaInc
*/

	/**
	* formulaire de cration d'valuation
	* @access	public
	*/
	function creerEval() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $tu_titre, $tu_table;
	 	if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
		// url formulaire
		$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd.'" ' ;
		// interface
		DebutFormulaire($tu_titre['creevalform'],"creeval",$url,IMG_ADD);
		AjoutText($tu_table['nomeval'].' *','',0,41,100);
		AjoutTextarea($tu_table['contexte'].' *','',1,45);
		FinFormulaire("validerCreeval(document.evalx);");
	}

	/**
	* formulaire de modification d'valuation
	* @access	public
	*/
	function modifierEval() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
	 global $color1, $color2, $color2a;
	 
	 	if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd.'" ' ;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;

		// ajout d'une option aucune valuation dans la liste des valuations
		$tabEval = $ClsEvalanx->getListEval();
		$lgEval = count($tabEval);
		for ($i=$lgEval; $i >= 0; $i--) {
			$tabEval[$i]["id"] = $tabEval[$i-1]["id"];
			$tabEval[$i]["nom"] = $tabEval[$i-1]["nom"];
		}
		$tabEval[0]["id"] = 0;
		$tabEval[0]["nom"] = "Aucune";
		
		if ($HTTP_POST_VARS["LEval"]!="" && $HTTP_POST_VARS["LEval"]!=0) {
			$HTTP_POST_VARS["nom"] = $ClsEvalanx->getNomEval($HTTP_POST_VARS["LEval"]);
			$HTTP_POST_VARS["contexte"] = $ClsEvalanx->getContexteEval($HTTP_POST_VARS["LEval"]);
		} else {
			// initialisation des variables pour champs nom, contexte
			$HTTP_POST_VARS["nom"] = "";
			$HTTP_POST_VARS["contexte"] = "";
		}

		// interface
		DebutFormulaire($tu_titre['modifevalform'],"modif",$url,IMG_MODIF);

		// valuation
		listeMulti($tu_table['seleval'],$tabEval, "LEval", "changeFormAction(document.evalx,'".$url2."');",$HTTP_POST_VARS["LEval"], "", false);	
		AjoutText($tu_table['nomeval'],$HTTP_POST_VARS["nom"],0,41,100);
		AjoutTextarea($tu_table['contexte'],Unreplace($HTTP_POST_VARS["contexte"]),1,45);
		FinFormulaire("validerModifeval(document.evalx);");
	}

	/**
	* formulaire de suppression d'valuation
	* @access	public
	*/
	function supprimerEval() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act;
	 global $tu_titre, $tu_table, $ClsEvalanx;
	 global $color1, $color2, $color2a;
	 	if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd.'" ' ;
		
		// rcupration des donnes
		$tab = $ClsEvalanx->getListEval();

		// interface
		DebutFormulaire($tu_titre['supprevalform'],"suppr",$url,IMG_DEL);
		listeMulti($tu_table['seleval'],$tab,"LEval[]",'','',10,true,'0','0');
		FinFormulaire("validerSuppreval(document.evalx)");
	}

// assignation
	/**
	* formulaire d'assignation d'valuations  un ou plusieurs stagiaires
	* @access	public
	*/
	function assignerEval() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act, $guserid;
	 global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
	 global $color1, $color2, $color2a;

	 	if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd.'" ' ;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;
		 
		// interface		
		DebutFormulaire($tu_titre['assignform'],"assign",$url);		
		listeMulti($tu_table['selgpe'],$ClsEvalanx->getListGroup($guserid), "LGroupe", "changeFormAction(document.evalx,'".$url2."')",$HTTP_POST_VARS['LGroupe'], "", false);
		listeMulti($tu_table['seleval'],$ClsEvalanx->getListEval(), "LEval[]", "", "", 10, true,'0','1');
		listeMulti($tu_table['selstag'],$ClsEvalanx->getListStagiaire($HTTP_POST_VARS['LGroupe']), "LStagiaire[]", "", "", 10, true,2,4);
		put('<script language="javascript">selectAll(document.evalx.elements[4], true)</script>');
		FinFormulaire("validerAssigneval(document.evalx)");
	}

	/**
	* formulaire suppression de session d'valuations d'un ou plusieurs stagiaires
	* @access	public
	*/
	function supprSession() {
		global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act, $guserid;
		global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
		global $color1, $color2, $color2a;

		if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd.'" ' ;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;

	 	// ajout d'une option aucun stagiaire dans la liste des stagiaires
		$tabStag = $ClsEvalanx->getListStagiaire($HTTP_POST_VARS['LGroupe']);
		if ($HTTP_POST_VARS['LGroupe'] == 0 || $HTTP_POST_VARS['LGroupe'] == "") {
			$lgStag = count($tabStag);
			for ($i=$lgStag; $i >= 0; $i--) {
				$tabStag[$i]["id"] = $tabStag[$i-1]["id"];
				$tabStag[$i]["prenom"] = $tabStag[$i-1]["prenom"];
				$tabStag[$i]["nom"] = $tabStag[$i-1]["nom"];
			}
			$tabStag[0]["id"] = 0;
			$tabStag[0]["prenom"] = "";
			$tabStag[0]["nom"] = "Aucun";
		}
		if ($HTTP_POST_VARS['LGroupe'] != $HTTP_POST_VARS['oldgroup']) {
			$HTTP_POST_VARS["LStagiaire"] = $tabStag[0]["id"];
		}

	 	if (isset($HTTP_POST_VARS["LStagiaire"])) {
			$tabEval = $ClsEvalanx->getEval($HTTP_POST_VARS["LStagiaire"]);
		}

		// interface
		DebutFormulaire($tu_titre['supprSession'],"supprSession",$url,IMG_DEL);
		listeMulti($tu_table['selgpe'],$ClsEvalanx->getListGroup($guserid), 
		           "LGroupe", "changeFormAction(document.evalx,'".$url2."')",
		           $HTTP_POST_VARS['LGroupe'], '', false);
		listeMulti($tu_table['selstag'],$tabStag, "LStagiaire", 
		           "changeFormAction(document.evalx,'".$url2."')", 
		           $HTTP_POST_VARS["LStagiaire"], '', false);
		listeMulti($tu_table['seleval'],$tabEval, "LEval[]", "", "", 10, true,'0','2');
		// stockage groupe
		AjoutHidden("oldgroup",$HTTP_POST_VARS['LGroupe']);
		FinFormulaire("validerSupprSession(document.evalx)");
	}

// rapports d'valuations
	/**
	* formulaire de cration de rapport d'valuation
	* @access	public
	*/
	function creerRapport() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act, $guserid;
	 global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
	 global $color1, $color2, $color2a;
	 	
		if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;
		
		// ajout d'une option aucun stagiaire dans la liste des stagiaires
		$tabStag = $ClsEvalanx->getListStagiaire($HTTP_POST_VARS['LGroupe']);
		if ($HTTP_POST_VARS['LGroupe'] == 0 || $HTTP_POST_VARS['LGroupe'] == "") {
			$lgStag = count($tabStag);
			for ($i=$lgStag; $i >= 0; $i--) {
				$tabStag[$i]["id"] = $tabStag[$i-1]["id"];
				$tabStag[$i]["prenom"] = $tabStag[$i-1]["prenom"];
				$tabStag[$i]["nom"] = $tabStag[$i-1]["nom"];
			}
			$tabStag[0]["id"] = 0;
			$tabStag[0]["prenom"] = "";
			$tabStag[0]["nom"] = "Aucun";
		}
		if ($HTTP_POST_VARS['LGroupe'] != $HTTP_POST_VARS['oldgroup']) {
			$HTTP_POST_VARS["LStagiaire"] = $tabStag[0]["id"];
		}

		// ajout d'une option aucune valuation dans la liste des valuations
		$tabEval = $ClsEvalanx->getListEval();
		$lgEval = count($tabEval);
		for ($i=$lgEval; $i >= 0; $i--) {
			$tabEval[$i]["id"] = $tabEval[$i-1]["id"];
			$tabEval[$i]["nom"] = $tabEval[$i-1]["nom"];
		}
		$tabEval[0]["id"] = 0;
		$tabEval[0]["nom"] = "Aucune";

		if ($HTTP_POST_VARS["LEval"]!="" && $HTTP_POST_VARS["LEval"]!=0) {
			$HTTP_POST_VARS["contexte"] = $ClsEvalanx->getContexteEval($HTTP_POST_VARS["LEval"]);
		} else {
			// initialisation des variables pour champs date, contexte, statut, temps, commentaire
			$HTTP_POST_VARS["text1"] = "";
			$HTTP_POST_VARS["text2"] = "";
			$HTTP_POST_VARS["text3"] = "";
			//
			$HTTP_POST_VARS["contexte"] = "";
			//	
			$HTTP_POST_VARS["LStatut"] = 0;
			//
			$HTTP_POST_VARS["text5"] = "";
			$HTTP_POST_VARS["text6"] = "";
			//
			$HTTP_POST_VARS["textarea7"] = "";
		}

		// interface
		DebutFormulaire($tu_titre['crerapform'],"crerap",$url,IMG_ADD);

		// valuation
		$grp = isset($HTTP_POST_VARS["LGroupe"])?$HTTP_POST_VARS["LGroupe"]:0 ;
		listeMulti($tu_table['seleval'],$tabEval, "LEval", "changeFormAction(document.evalx,'".$url2."')",$HTTP_POST_VARS["LEval"], "", false);
		listeMulti($tu_table['selgpe'],$ClsEvalanx->getListGroup($guserid), "LGroupe", "changeFormAction(document.evalx,'".$url2."')",$HTTP_POST_VARS["LGroupe"], "", false);
		listeMulti($tu_table['selstag'],$tabStag, "LStagiaire", "", $HTTP_POST_VARS["LStagiaire"], "", false);
		listeMulti($tu_table['nomevalu'],$ClsEvalanx->getListTuteur($grp), "LTuteur", "",$HTTP_POST_VARS["LTuteur"], "", false);
		$date = array($HTTP_POST_VARS["text1"],$HTTP_POST_VARS["text2"],$HTTP_POST_VARS["text3"]);
		AjoutTextDate($tu_table['evaldate'],$date,1) ;
		AjoutTextarea($tu_table['contexte'],$HTTP_POST_VARS["contexte"],4,45,10,false,true);

		// statut
		$tabStatut[0] = array("id" => 0, "nom" => $tu_table['nonacquis']);
		$tabStatut[1] = array("id" => 1, "nom" => $tu_table['acquis']);

		listeMulti($tu_table['statut'],$tabStatut, "LStatut", "", $HTTP_POST_VARS["LStatut"], "", false);
		//put('<tr bgcolor="'.CoulForm().'"><td>&nbsp;'.$tu_table['temps'].'&nbsp;</td><td>*');	
		$time = array($HTTP_POST_VARS["text5"],$HTTP_POST_VARS["text6"]);
		AjoutTextTime($tu_table['temps'],$time,5); 
		AjoutTextarea($tu_table['comment'],$HTTP_POST_VARS["textarea7"],7,45,10,false,false);

		// stockage groupe
		AjoutHidden("oldgroup",$HTTP_POST_VARS['LGroupe']);
		
		FinFormulaire("validerCrerap(document.evalx)");
	}
	
	/**
	* formulaire de modification de rapport d'valuation
	* @access	public
	*/
	function modifierRapport() {
	 global $gconnexionid, $ext, $cmd, $menu, $evx_menu, $evx_act, $guserid;
	 global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
	 global $color1, $color2, $color2a;
	 	
		if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;
	
		// ajout d'une option aucun stagiaire dans la liste des stagiaires
		$tabStag = $ClsEvalanx->getListStagiaire($HTTP_POST_VARS['LGroupe']);
		// si aucun groupe de slectionner
		if ($HTTP_POST_VARS['LGroupe'] == 0 || $HTTP_POST_VARS['LGroupe'] == "") {
			$lgStag = count($tabStag);
			for ($i=$lgStag; $i >= 0; $i--) {
				$tabStag[$i]["id"] = $tabStag[$i-1]["id"];
				$tabStag[$i]["prenom"] = $tabStag[$i-1]["prenom"];
				$tabStag[$i]["nom"] = $tabStag[$i-1]["nom"];
			}
			$tabStag[0]["id"] = 0;
			$tabStag[0]["prenom"] = "";
			$tabStag[0]["nom"] = "Aucun";
		}
		// si on change de groupe
		if ($HTTP_POST_VARS['LGroupe'] != $HTTP_POST_VARS['oldgroup']) {
			$HTTP_POST_VARS["LStagiaire"] = $tabStag[0]["id"];
			$HTTP_POST_VARS["LEval"] = "";
		}
		// si on change de stagiaire
		if ($HTTP_POST_VARS['LStagiaire'] != $HTTP_POST_VARS['oldstag']) {
			$HTTP_POST_VARS["LEval"] = "";
		}
	
		// rcupration des donnes
		if ($HTTP_POST_VARS["LStagiaire"] != "" && $HTTP_POST_VARS["LStagiaire"] != 0) {
			$t = array($HTTP_POST_VARS["LStagiaire"]);
			$tabEval = $ClsEvalanx->getDataReport($t);
		}
		$lgEval = count($tabEval);

		if ($lgEval == 0) {
			$tabEval[0]['id'] = 0;
			$tabEval[0]['nom'] = "Aucune";
			$tabEval[0]['id_stagiaire'] = 0;
			$tabEval[0]['id_evaluation'] = 0;
			$tabEval[0]['id_evaluateur'] = 1;
			$tabEval[0]['date'] = "";
			$tabEval[0]['contexte'] = "";
			$tabEval[0]['statut'] = 0;
			$tabEval[0]['temps'] = 0;
			$tabEval[0]['commentaire'] = "";
			
			// initialisation des variables pour champs tuteur, date, contexte, statut, temps, commentaire
			$HTTP_POST_VARS["LTuteur"] = 1;
			//
			$HTTP_POST_VARS["text1"] = "";
			$HTTP_POST_VARS["text2"] = "";
			$HTTP_POST_VARS["text3"] = "";
			//
			$HTTP_POST_VARS["contexte"] = "";
			//
			$HTTP_POST_VARS["LStatut"] = 0;
			//
			$HTTP_POST_VARS["text5"] = "";
			$HTTP_POST_VARS["text6"] = "";
			//
			$HTTP_POST_VARS["textarea7"] = "";
			
		} else {
			(!empty($HTTP_POST_VARS["LEval"])) ? $idrap = $HTTP_POST_VARS["LEval"]: $idrap = $tabEval[0]['id'];
			$ideval = $ClsEvalanx->getIdEval($idrap);
			
			// mise  jour des variables correpsondant aux diffrents champs
			// slection valuation
			for ($i=0; $i < $lgEval; $i++) {
				$tabEval[$i]['nom'] = "ID : ".$tabEval[$i]['id']." -- ".$tabEval[$i]['nom']." -- ".date("d/m/Y",$tabEval[$i]['date']);
			}
			// nom valuateur
			$HTTP_POST_VARS["LTuteur"] = $ClsEvalanx->getIdTuteur($idrap);
			// date
			// jour
			$HTTP_POST_VARS["text1"] = date("d",$ClsEvalanx->getDateRap($idrap));
			// mois
			$HTTP_POST_VARS["text2"] = date("m",$ClsEvalanx->getDateRap($idrap));
			// anne
			$HTTP_POST_VARS["text3"] = date("Y",$ClsEvalanx->getDateRap($idrap));
			// contexte
			$HTTP_POST_VARS["contexte"] = $ClsEvalanx->getContexteEval($ideval);
			// statut
			$HTTP_POST_VARS["LStatut"] = $ClsEvalanx->getStatut($idrap);
			// temps
			// heures
			$HTTP_POST_VARS["text5"] = date("H",$ClsEvalanx->getTemps($idrap));
			// minutes
			$HTTP_POST_VARS["text6"] = date("i",$ClsEvalanx->getTemps($idrap));
			// commentaires
			$HTTP_POST_VARS["textarea7"] = $ClsEvalanx->getComment($idrap);
		}

			
		// interface
		$grp = isset($HTTP_POST_VARS["LGroupe"])?$HTTP_POST_VARS["LGroupe"]:0 ;
		DebutFormulaire($tu_titre['modifrapform'],"modifrap",$url,IMG_MODIF);
		listeMulti($tu_table['selgpe'],$ClsEvalanx->getListGroup($guserid), "LGroupe", 
		           "changeFormAction(document.evalx,'".$url2."')",
		           $HTTP_POST_VARS["LGroupe"], "", false);
		listeMulti($tu_table['selstag'],$tabStag, "LStagiaire", 
		           "changeFormAction(document.evalx,'".$url2."')", 
		           $HTTP_POST_VARS["LStagiaire"], "", false);
		listeMulti($tu_table['nomevalu'],$ClsEvalanx->getListTuteur($grp), "LTuteur", '',
		           $HTTP_POST_VARS["LTuteur"], "", false);
		listeMulti($tu_table['seleval'],$tabEval, "LEval", 
		           "changeFormAction(document.evalx,'".$url2."')",
		           $HTTP_POST_VARS["LEval"], "", false);
		$date = array($HTTP_POST_VARS["text1"],$HTTP_POST_VARS["text2"],$HTTP_POST_VARS["text3"]);
		AjoutTextDate($tu_table['evaldate'],$date,1) ;
		AjoutTextarea($tu_table['contexte'],$HTTP_POST_VARS["contexte"],4,45,10,false,true);

		$tabStatut[0] = array("id" => 0, "nom" => $tu_table['nonacquis']);
		$tabStatut[1] = array("id" => 1, "nom" => $tu_table['acquis']);

		listeMulti($tu_table['statut'],$tabStatut, "LStatut", "", 
		           $HTTP_POST_VARS["LStatut"], "", false);
		put('<tr bgcolor="'.CoulForm().'"><td>&nbsp;'.$tu_table['temps'].'&nbsp;</td><td>*');	
		$time = array($HTTP_POST_VARS["text5"],$HTTP_POST_VARS["text6"]);
		AjoutTextTime($tu_table['temps'],$time,5); 
		AjoutTextarea($tu_table['comment'],$HTTP_POST_VARS["textarea7"],7,45,10,false,false);

		// stockage groupe courant
		AjoutHidden("oldgroup",$HTTP_POST_VARS['LGroupe']);
		
		// stockage stagiaire courant
		AjoutHidden("oldstag",$HTTP_POST_VARS['LStagiaire']);
		
		FinFormulaire("validerModifrap(document.evalx)");
	}
	
	/**
	* formulaire de suppression de rapport d'valuation
	* @access	public
	*/
	function supprimerRapport() {
	 global $gconnexionid, $HTTP, $ext, $cmd, $menu, $evx_menu, $evx_act, $guserid;
	 global $tu_titre, $tu_table, $ClsEvalanx, $HTTP_POST_VARS;
	 global $color1, $color2, $color2a;
	 	
		if (!isset($evx_act) || empty($evx_act)) { $evx_act = 0 ; }
	 	// url formulaire
	 	$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url.= '&confirm=1&menu='.$menu.'&cmd='.$cmd;
		// url rechargement de page
	 	$url2 = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
		$url2.= '&menu='.$menu.'&cmd='.$cmd;
		
		// ajout d'une option aucun stagiaire dans la liste des stagiaires
		$tabStag = $ClsEvalanx->getListStagiaire($HTTP_POST_VARS['LGroupe']);
		if ($HTTP_POST_VARS['LGroupe'] == 0 || $HTTP_POST_VARS['LGroupe'] == "") {
			$lgStag = count($tabStag);
			for ($i=$lgStag; $i >= 0; $i--) {
				$tabStag[$i]["id"] = $tabStag[$i-1]["id"];
				$tabStag[$i]["prenom"] = $tabStag[$i-1]["prenom"];
				$tabStag[$i]["nom"] = $tabStag[$i-1]["nom"];
			}
			$tabStag[0]["id"] = 0;
			$tabStag[0]["prenom"] = "";
			$tabStag[0]["nom"] = "Aucun";
		}
		if ($HTTP_POST_VARS['LGroupe'] != $HTTP_POST_VARS['oldgroup']) {
			$HTTP_POST_VARS["LStagiaire"] = $tabStag[0]["id"];
		}
		
		
		
		// rcupration des donnes
		if ($HTTP_POST_VARS["LStagiaire"] != "" && $HTTP_POST_VARS["LStagiaire"] != 0) {
			$t = array($HTTP_POST_VARS["LStagiaire"]);
			$tabEval = $ClsEvalanx->getDataReport($t);
		}
		$lgEval = count($tabEval);
		if ($lgEval != 0) {
			// mise  jour des variables correpsondant aux diffrents champs
			// slection valuation
			for ($i=0; $i < $lgEval; $i++) {
				$tabEval[$i]['nom'] = "ID : ".$tabEval[$i]['id']." -- ".$tabEval[$i]['nom']." -- ".date("d/m/Y",$tabEval[$i]['date']);
			}
		}
		
		// interface
		DebutFormulaire($tu_titre['supprrapform'],"supprrap",$url,IMG_DEL);
		listeMulti($tu_table['selgpe'],$ClsEvalanx->getListGroup($guserid), "LGroupe", "changeFormAction(document.evalx,'".$url2."')",$HTTP_POST_VARS["LGroupe"], "", false);
		listeMulti($tu_table['selstag'],$tabStag, "LStagiaire", "changeFormAction(document.evalx,'".$url2."')", $HTTP_POST_VARS["LStagiaire"], "", false);
		listeMulti($tu_table['seleval'],$tabEval, "LEval[]", "",$HTTP_POST_VARS["LEval"], 10, true,'0','2');

		// stockage groupe
		AjoutHidden("oldgroup",$HTTP_POST_VARS['LGroupe']);
		
		FinFormulaire("validerSupprrap(document.evalx)");
	}
	
	/**
	* formulaire de consultation de rapport d'valuation
	* @access	public
	*/
	function consulterRapport() {
	 global $gconnexionid, $guserid, $ext, $cmd, $menu, $evx_menu, $evx_act, $idconsult;
	 global $tu_titre, $tu_table, $st_texte ;
	 global $color1, $color2;
	 global $ClsGroupe, $ClsMembre, $ClsEvalanx, $groupe;
	 	BR();
		// Consultation : cran d'accueil
		if (!isset($idconsult)) {
			$listGroup = $ClsGroupe->read($guserid);
			
			for ($i=0; $i<$listGroup['cnt']; $i++) {
				SubTitleImage('Groupe ['.$listGroup[$i]['name'].']',IMG_GRP);
				BeginBorder("98%",$color2);	
				put('        <table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="'.$color1.'">');
				put('        <tr class="title1" align="middle" >');
				put('          <td width="20%"><b>'.$tu_table['staggpe'].'</b></td>');
				put('          <td width="15%"><b>'.$tu_table['nbevaleff'].'</b></td>');
				put('          <td width="15%"><b>'.$tu_table['nbevalok'].'</b></td>');
				put('          <td width="15%"><b>'.$tu_table['derneval'].'</b></td>');
				put('          <td width="15%"><b>'.$tu_table['datederneval'].'</b></td>');
				put('          <td width="20%"><b>'.$tu_table['nomevalu'].'</b></td>');
				put('        </tr>');

				$tStag = $ClsEvalanx->getListStagiaire($listGroup[$i]['id']);
				$lgStag = count($tStag) ;
				for ( $j=0; $j<$lgStag; $j++) {
					// lien stagiaire
					$idStag = $tStag[$j]["id"];
					$prenomStag = $tStag[$j]["prenom"];
					$nomStag = $tStag[$j]["nom"];
					// url pour passer aux dtails des stagiaires
					$url = HTTP_TUTEUR.'index'.$ext.'?connexion='.$gconnexionid.'&evx_menu='.$evx_menu.'&evx_act='.$evx_act;
					$url.= '&menu='.$menu.'&cmd='.$cmd.'&idconsult='.$idStag;
					
					$status = Status ($st_texte['details']) ;
					$linkstag  = '<A class="student" href="'.$url.'" '.$status.'>'.$prenomStag." ".$nomStag.'</A>';

					// session du stagiaire
					$tIdEval = $ClsEvalanx->getListEvalStag($idStag);
					$lgIdEval = count($tIdEval);
					// id rapports
					$tIdRap = $ClsEvalanx->getIdRapEvalDone($idStag);	
					$lgIdRap = count($tIdRap);
				
					// nombre d'valuations  effectuer par le stagiaire
					$nbEvaltot = $lgIdEval;
					// nombre d'valuations dj effectues par le stagiaire
					$nbEvaleff = $lgIdRap;
					$nbval=0;
					for ($k=0; $k<$lgIdRap; $k++) {
						if ($ClsEvalanx->getStatut($tIdRap[$k])==1) $nbval++;
					}
					// nombre d'valuations valides
					$nbEval_valid = $nbval;
					unset($nbval);
					// dernire valuation effectue + sa date
					$tDernEval = $ClsEvalanx->getDernEval($idStag);
					if (!empty($tDernEval[0]["id"])) {
						$derneval = $tDernEval[0]["nom"];
						$dateDerneval = date("d/m/Y",$tDernEval[0]["date"]);
					
						// tuteur de la dernire valuation effectue
						$idtut = $ClsEvalanx->getIdTuteur($tDernEval[0]["id"]);
						$nmtut = $ClsMembre->GetNom($idtut);
						$pnmtut = $ClsMembre->GetPrenom($idtut);
						$cv = $ClsMembre->GetCvLink($idtut);
					} else {
						$derneval = "&nbsp;";
						$dateDerneval = "&nbsp;";
					
						// tuteur de la dernire valuation effectue
						$idtut = "&nbsp;";
						$nmtut = "&nbsp;";
						$pnmtut = "&nbsp;";
						$cv = "&nbsp;";
					}
					if ( $cv == '' ) {
						$linktut = $pnmtut." ".$nmtut;
					} else {
						$linktut = "<A class=student href=\"#\" onMouseOver=\"window.status='Affichage du CV';return true;\" onMouseOut=\"window.status='Ganesha ".VERSION."';return true;\"  onClick=\"openWindow('".HTTP_CV.$cv."?connexion=".$gconnexionid."','fenetre','scrollbars=yes,width=620,height=400')\">".$pnmtut." ".$nmtut."</A>";
					}
				
					put('        <tr align="middle" bgcolor="'.( ( $j % 2 ) == 0 ? "#EEEEEE" :  "#FFFFFF" ).'" >');
					put('          <td>'.$linkstag.'</td>');
					put('          <td>'.$nbEvaleff." / ".$nbEvaltot.'</td>');
					put('          <td>'.$nbEval_valid.'</td>');
					put('          <td>'.$derneval.'</td>');
					put('          <td>'.$dateDerneval.'</td>');
					put('          <td>'.$linktut.'</td>');
					put('        </tr>');
				}

				put('        </table>');
				put('    </td></tr>');
				CloseBorder();
				BR(2);
			}
			
		// Consultation : cran de stagiaire
		} else {
				$nmstag = $ClsMembre->GetNom($idconsult);
				$pnmstag = $ClsMembre->GetPrenom($idconsult);
				
				put('    <table width="98%" border="0" align="center" cellspacing="0" cellpadding="2" bgcolor="'.$color2.'" >');
				put('    <tr><td>');
				/*
				put('        <table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="'.$color1.'">');
				put('        <tr align="middle">');
				put('           <td><p class="title1">Stagiaire : '.$pnmstag." ".$nmstag.'</p> </td>');
				put('        </tr>');
				put('        </table>');
				*/
				put('        <table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="'.$color1.'">');
				put('        <tr class="title1" align="middle" >');
				put('          <td width="15%"><b>'.$tu_table['nomeval'].'</b></td>');
				put('          <td width="15%"><b>'.$tu_table['nomevalu'].'</b></td>');
				put('          <td width="12%"><b>'.$tu_table['evaldate'].'</b></td>');
				put('          <td width="12%"><b>'.$tu_table['temps'].'</b></td>');
				put('          <td width="12%"><b>'.$tu_table['statut'].'</b></td>');
				put('          <td width="34%"><b>'.$tu_table['comment'].'</b></td>');
				put('        </tr>');
				
				$tId = array($idconsult);
				$tRap = $ClsEvalanx->getDataReport($tId);			
				$lgRap = count($tRap) ;
				
				for ( $j=0; $j<$lgRap; $j++) {
					// tableau des valuations  faire
					$tEval[$j] = $tRap[$j]["id_evaluation"];
					
					// lien stagiaire
					$idRap 		= $tRap[$j]["id"];
					$nomEval	= $tRap[$j]["nom"];
					$idEval 	= $tRap[$j]["id_evaluation"];
					$idTut 		= $tRap[$j]["id_evaluateur"];
					$date 		= $tRap[$j]["date"];
					$contexte 	= $tRap[$j]["contexte"];
					$statut 	= $tRap[$j]["statut"];
					$temps 		= $tRap[$j]["temps"];
					$commentaire= $tRap[$j]["commentaire"];
					
					// tuteur
					$nmtut = $ClsMembre->GetNom($idTut);
					$pnmtut = $ClsMembre->GetPrenom($idTut);
					$cv = $ClsMembre->GetCvLink($idTut);
					$over_out = Status('CV');
					if ( trim($cv) != '' ) {
						$linktut = '<A class="student" href="#" '.$over_out.' onClick="openWindow(\''.HTTP_CV.$cv.'?connexion='.$gconnexionid.'\',\'fenetre\',\'scrollbars=yes,width=620,height=400\')\">'.$pnmtut.' '.$nmtut.'</A>';
					} else {
						$linktut = $pnmtut." ".$nmtut ;						
					}
					
					// statut
					($statut==1) ? $stt = $tu_table['acquis']: $stt = $tu_table['nonacquis'];
				
					put('        <tr align="middle" bgcolor="'.( ( $j % 2 ) == 0 ? "#EEEEEE" :  "#FFFFFF" ).'" >');
									 
					put('          <td>'.$nomEval.'</td>');
					put('          <td>'.$linktut.'</td>');
					put('          <td>'.date("d/m/Y",$date).'</td>');
					put('          <td>'.date("H : i",$temps).'</td>');
					put('          <td>'.$stt.'</td>');
					put('          <td align="left">'.$commentaire.'</td>');
					put('        </tr>');
				}
				
				// affichage des valuations  effectuer
				$tEvalAFaire = $ClsEvalanx->getEvalToDo($idconsult, $tEval);
				$lgEAF = count($tEvalAFaire);
				// rajustement pour une continuit dans l'alternace des bandes
				($lgRap % 2) == 0 ? $ajust = 0: $ajust = 1;
				
				for ( $j=0; $j < $lgEAF; $j++) {
					$color = ((($j+$ajust) % 2 ) == 0 ? "#EEEEEE" :  "#FFFFFF" ) ;
					
					$conf  = 'scrollbars=yes,width=420,height=410';
					$url   = HTTP_COMMUN."p_eval.php?connexion=".$gconnexionid."&groupe=".$groupe."&id_eval=".$tEvalAFaire[$j]["id"] ;
					$link  = '<a class="student" href="javascript:void(0);" onClick="openWindow(\''.$url.'\',\'Eval\',\''.$conf.'\')" >'.$tEvalAFaire[$j]["nom"].'</a>';

					put('        <tr align="middle" bgcolor="'.$color.'" >');
					put('          <td>'.$link.'&nbsp;</td>');
					put('          <td>&nbsp;</td>');
					put('          <td>&nbsp;</td>');
					put('          <td>&nbsp;</td>');
					put('          <td>'.$tu_table['nonacquis'].'&nbsp;</td>');
					put('          <td>&nbsp;</td>');
					put('        </tr>');
				}
				$color = ((($j+$ajust) % 2 ) == 0 ? "#EEEEEE" :  "#FFFFFF" ) ;
				put('		<tr bgcolor="'.$color.'" >');
				put('          <td>&nbsp;</td>');
				put('          <td>&nbsp;</td>');
				put('          <td>&nbsp;</td>');
				put('          <td>&nbsp;</td>');
				put('          <td>&nbsp;</td>');
				put('          <td>&nbsp;</td>');				
				put('        </tr>');
				put('        </table>');
				put('    </td></tr>');
				put('    </table>' ) ;

		}
	}
	/**
	* Affiche la liste des rapports d'valuations annexes d'un membre
	* @access	public
	*/
	function listeRapEval() {
	 	global $gconnexionid, $ext, $guserid, $menu, $groupe;
	 	global $st_titre, $tu_titre, $tu_table ;
	 	global $color1, $color2;
	 	global $ClsGroupe, $ClsMembre, $ClsEvalanx;

	 	// rcupration des rapports
	 	$tUser = array($guserid)	;
		$tRap = $ClsEvalanx->getDataReport($tUser);
		$lgRap = count($tRap);

		// rcupration des valuations du programme de formation
		$tEvalToDo = $ClsEvalanx->getEvalToDo($guserid, $ClsEvalanx->getIdRapEvalDone($guserid));
		$lgEvalToDo = count($tEvalToDo);

		if ($lgRap>0 || $lgEvalToDo>0) {
			SubTitle(MENU_IMG_EVALX.'&nbsp;&nbsp;'.$st_titre['rapeval']);
			put('<br>');
			put('<table width="100%" border="0" cellspacing="0" cellpadding="0">');
			put(' <tr><td>');
			UL();

			if ($lgRap > 0 && $lgEvalToDo > 0) {
				$msg = $st_titre['consult'].$st_titre['rap'].$st_titre['et'].$st_titre['prog'].$st_titre['eval'];
			} elseif ($lgRap>0) {
				$msg = $st_titre['consult'].$st_titre['rap'].$st_titre['eval'];
			} else {
				$msg = $st_titre['consult'].$st_titre['prog'].$st_titre['eval'];
				$msg2 = $st_titre['aucunrap'] ;
			}

			// lien vers le tableau de consultation des rapports
			$url  = HTTP_STAGIAIRE.'index'.$ext.'?connexion='.$gconnexionid.'&menu='.$menu.'&groupe='.$groupe.'&idconsult='.$guserid;
			$status = Status($msg);
			$link = '<A class="student" target="_self" href="'.$url.'" '.$status.'> '.$msg.'</A>';
			
			put('           '.$link);
			put('			<br>');
			put($msg2.'<br>');
	
			for ( $i=0; $i<$lgRap; $i++ ) {
		
				// lien stagiaire
				$idRap 		= $tRap[$i]["id"]			;
				$nomEval 	= $tRap[$i]["nom"]			;
				$idEval 	= $tRap[$i]["id_evaluation"];
				$idTut 		= $tRap[$i]["id_evaluateur"];
				$date 		= $tRap[$i]["date"]			;
				$contexte 	= $tRap[$i]["contexte"]		;
				$statut 	= $tRap[$i]["statut"]		;
				$temps 		= $tRap[$i]["temps"]		;
				$commentaire= $tRap[$i]["commentaire"]	;
				
				// liste des rapports
				LI();
				put('	           '.$tu_table["nomeval"]." : <b>".$nomEval."</b>")	;
				put('<br>')	;
				put('           '.$tu_table["evaldate"]." : <b>".date("d/m/Y",$date)."</b>")	;
				_LI();
				put('<br>')	;
			}
			_UL();
			put('  </td></tr>')	;
			put('</table>')				;
		}
	}

?>