<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des formations
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche la liste des formations d'un membre et son avancement
	* @access	public
	*/
	function ListFormation() {
		global $ClsFormation, $ClsSession, $ClsModule, $ClsMembre, $gconnexionid, $ext, $guserid, $groupe ;
	 	global $st_titre ;

		$img = '<img src="'.HTTP_IMAGES.'dtodo.gif" border="0" alt="'.$st_titre['module'].'" />&nbsp;&nbsp;';
		SubTitleImage($st_titre['module'],$img);
		put('<BR>');
		put('<table width="100%" border="0" cellspacing="0" cellpadding="0">');
		put(' <tr><td>');

		UL();

		$ret = $ClsSession->read($groupe);
		for ( $i=0; $i<$ret['cnt']; $i++ ) {
			$idm = $ret[$i]['id']	;

			$avancement = $ClsModule->avancement($guserid,$groupe,$idm);
			$titre = CSS(UnReplace($ret[$i]['name']))	;

			$lgko = (100 - $avancement)								;
			$pourcent = number_format($avancement, 2, ",", "")		;

			$param = '?connexion='.$gconnexionid.'&module='.$idm.'&groupe='.$groupe ;
			$url   = HTTP_STAGIAIRE.'f_module'.$ext.$param ;
			$over  = 'onMouseOver="window.status=\'Module \';return true;" ' ;
			$out   = 'onMouseOut="window.status=\'Ganesha '.VERSION.'\';return true;"'	;
			$link  = '<a class="student" target="_top" href="'.$url.'" '.$over.' '.$out.'> '.$titre.'</a>';
			$imgspace = '<img align="absmiddle" src="'.HTTP_IMAGES.'space.gif" width="10" height="10">'			;
			$imgok    = '<img align="absmiddle" src="'.HTTP_IMAGES.'ok.gif" width="'.($avancement/2).'" height="10">';
			$imgko    = '<img align="absmiddle" src="'.HTTP_IMAGES.'ko.gif" width="'.($lgko/2).'" height="10">'	;
			$image    = $imgspace.$imgok.$imgko.' '.$pourcent.'%' ;
			LI();
			put($link)	;
			put($image)	;
			_LI();
		}
		_UL();

		put('  </td></tr>')	;
		put('</table>')	;
	}

	/**
	* Affiche le BNO pour une formation
	* @access	public
	*/
	function BNOFormation() {
	 global $ClsMembre, $guserid ;
		// debut modif Pyg [addon BNO] : ajoute le lien vers les objectifs		
		if ( OPT_BNO_ACTIVE ) {
			$ret = $ClsMembre->GetGroupe($guserid);
			AfficheLienBNO($ret['idgroupe']); 
		}
		// fin  modif pyg [addon BNO]
	}

	/**
	* Affiche les statistiques d'un membre
	* @access	public
	*/
	function StatFormation() {
	 global $ClsMembre, $ClsGroupe, $guserid, $ClsWebMail, $gconnexionid, $ext ;
	 global $st_titre, $st_texte, $ClsCnx ;
		$ret = $ClsMembre->GetGroupe($guserid);
		$grp	  = $ret['groupe']	;
		$idgroupe = $ret['idgroupe'];
		$nb_msg = $ClsWebMail->NbRecNotRead($guserid,$idgroupe)	;
		$link = "" ;
		if ( $nb_msg != 0 ) {
			$url  = HTTP_GANESHA.'index'.$ext.'?menu=2&connexion='.$gconnexionid;
			$link = '<a target="_top" class="student" href="'.$url.'">'	;
		}
		BR();
		$img = '<img src="'.HTTP_IMAGES.'graph.gif" border="0" alt="'.$st_titre['stat'].'" />&nbsp;&nbsp;';
		SubTitleImage($st_titre['stat'],$img)	;
		BR();
		put('<table width="100%" border="0" cellspacing="0" cellpadding="0" >');
//		put(' <tr><td>'.$st_texte["dernierecnx"].'<b>'.$ClsCnx->Last($guserid).'</b></td></tr>');

		$urlcnx	= HTTP_COMMUN.'p_details'.$ext.'?connexion='.$gconnexionid.'&id_membres='.$guserid.'&groupe='.$idgroupe	;
		$click 	= "onClick=\"openWindow('".$urlcnx."','wind','scrollbars=yes,width=620,height=400')\" ";
		$status	= Status('groupe');
		$lcnx	='<a class=student href="#" '.$click.$status.'>'.$ClsMembre->GetNbConnexion($guserid).'</a>'	;

		put(' <tr><td>'.$st_texte["nbcnx"].' <b>'.$lcnx.'</b></td></tr>');
		put(' <tr><td>&nbsp;</TD></TR>');
		put(' <tr><td><P>'.$st_texte["nvmess"].$link.$nb_msg.($link==""?"":"</a>").'</td></tr>');
		put(' <tr><td>&nbsp;</TD></TR>');
		put(' <tr><td>'.$st_texte["4derniers"].'</td></tr>');
		put('</table>');
		PhorumMessages($ClsGroupe->IdForum($idgroupe));
	}

?>