<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des forums
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Initialise toutes les variables utilisees par l'application Phorum
	* @param	integer	$idf numero(id) du forum 
	* @return	boolean	true si OK
	* @access	public
	*/
	function InitVariablesPhorum ($idf) {
	 global $ForumId,$ForumActive,$ForumName,$ForumDescription,$ForumConfigSuffix,$ForumFolder ;
	 global $ForumParent,$ForumLang,$ForumDisplay,$ForumTableName,$ForumModeration,$ForumModEmail;
	 global $ForumModPass,$ForumEmailList,$ForumEmailReturnList,$ForumEmailTag,$ForumCheckDup;
	 global $ForumMultiLevel,$ForumCollapse,$ForumFlat,$ForumStaffHost,$ForumAllowHTML ;
	 global $ForumAllowUploads,$ForumTableBodyColor2,$ForumTableBodyFontColor2,$ForumTableWidth;
	 global $ForumNavColor,$ForumNavFontColor,$ForumTableHeaderColor,$ForumTableHeaderFontColor;
	 global $ForumTableBodyColor1,$ForumTableBodyFontColor1;
	 global $TBL ;
	 global $db ;
		$sSQL = "select  id, name, active, description, config_suffix, folder, parent, "	;
		$sSQL.= "display, table_name, moderation, mod_email, mod_pass, email_list, "		;
		$sSQL.= "email_return, email_tag, check_dup, multi_level, collapse, flat, "			;
		$sSQL.= "staff_host, lang, html, table_width, table_header_color, table_header_font_color, ";
		$sSQL.= "table_body_color_1, table_body_color_2, table_body_font_color_1,"			;
		$sSQL.= "table_body_font_color_2, nav_color, nav_font_color, allow_uploads "		;
		$sSQL.= "FROM ".$TBL['forums']." where id='".$idf."'";
		$db->query($sSQL);
		if ( $db->num_rows() != "0" ) {
			$db->next_record();
			$ForumId					= $db->f("id")						;
			$ForumActive				= $db->f("active")					;
			$ForumName					= $db->f("name")					;
			$ForumDescription			= $db->f("description")				;
			$ForumConfigSuffix			= $db->f("config_suffix")			;
			$ForumFolder				= $db->f("folder")					;
			$ForumParent				= $db->f("parent")					;
			$ForumLang					= GLANG							; //$db->f("lang"];
			$ForumDisplay				= $db->f("display")					;
			$ForumTableName				= $db->f("table_name")				;
			$ForumModeration			= $db->f("moderation")				;
			$ForumModEmail				= $db->f("mod_email")				;
			$ForumModPass				= $db->f("mod_pass")				;
			$ForumEmailList				= $db->f("email_list")				;
			$ForumEmailReturnList		= $db->f("email_return")			;
			$ForumEmailTag				= $db->f("email_tag")				;
			$ForumCheckDup				= $db->f("check_dup")				;
			$ForumMultiLevel			= $db->f("multi_level")				;
			$ForumCollapse				= $db->f("collapse")				;
			$ForumFlat					= $db->f("flat")					;
			$ForumStaffHost				= $db->f("staff_host")				;
			$ForumAllowHTML				= $db->f("html")					;
			$ForumAllowUploads			= $db->f("allow_uploads")			;
			$ForumTableWidth			= $db->f("table_width")				;
			$ForumNavColor				= $db->f("nav_color")				;
			$ForumNavFontColor			= $db->f("nav_font_color")			;
			$ForumTableHeaderColor		= $db->f("table_header_color")		;
			$ForumTableHeaderFontColor	= $db->f("table_header_font_color")	;
			$ForumTableBodyColor1		= $db->f("table_body_color_1")		;
			$ForumTableBodyFontColor1	= $db->f("table_body_font_color_1")	;
			$ForumTableBodyColor2		= $db->f("table_body_color_2")		;
			$ForumTableBodyFontColor2	= $db->f("table_body_font_color_2")	;
			$db->free();
			return(true);
		} else {
			return(false);
		}
	  }

	/**
	* retourne le nom du forum
	* @param	integer	$idf numero(id) du forum 
	* @return	string	Nom du forum qui a pour id $idf
	* @access	public
	*/
	function PhorumName($idf) {
	 global $TBL, $db ;
		$sql = "SELECT name FROM ".$TBL['forums']." WHERE id=".$idf ;
		$db->query($sql)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* maj du nom du forum
	* @param	integer	$idg numero du groupe
	* @return	string	Nom du forum qui a pour id $idf
	* @access	public
	*/
	function SetPhorumName($idg,$name) {
	 global $TBL, $db, $ClsGroupe ;
	 	$idf = $ClsGroupe->IdForum($idg);
		$sql = "UPDATE  ".$TBL['forums']." set name='".$name."' WHERE id=".$idf ;
		$db->query($sql)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* retourne le nom de la table du forum $idf
	* @param	integer	$idf numero(id) du forum 
	* @return	string	Nom de la table du forum qui a pour id $idf
	* @access	public
	*/
	function GetTableName($idf) {
	 global $TBL, $db ;
		$sql = "SELECT table_name FROM ".$TBL['forums']." WHERE id=".$idf ;
		$db->query($sql)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* Affiche les 4 derniers messages du forum
	* @param	integer	$idf numero(id) du forum 
	* @access	public
	*/
	function PhorumMessages($idf) {
	 global $ext, $gconnexionid ;
	 global $st_texte, $db ;
		$mydb = new DB_GANESHA	;
		$forum = GetTableName($idf)	;
		if ( trim($forum) == '' ) {
			return;
		}
		$sql = "SELECT id,subject,datestamp "	;
		$sql .= "FROM ".$forum." "				;
		$sql .= "WHERE parent = 0 AND approved='Y' "	;
		$sql .= "ORDER BY id DESC LIMIT 0,4"	;
		$db->query($sql)						;
		$init = false							;
		while ( $db->next_record() ) {
			if ( $init == false ) {
				put('		<TABLE width="100%" border="0" cellspacing="0" cellpadding="0" >');
			}
			$init = true	;
			$sql2 = "SELECT count(*) "	;
			$sql2.= "FROM ".$forum." "	;
			$sql2.= "WHERE thread=".$db->f(0)." AND parent <> 0 AND approved='Y'";
			$mydb->query($sql2)		;
			$mydb->next_record()	;
			$date = substr($db->f(2), 8, 2) . "/"	;
			$date.= substr($db->f(2), 5, 2) . " "	;
			$date.= substr($db->f(2), 11, 5)		;
			if ( strlen($db->f(1)) > 35 ) {
				$msg = substr($db->f(1), 0, 35)." ..."	;
			} else {
				$msg = $db->f(1);
			}
			$href = HTTP_FORUM.'read'.$ext.'?f='.$idf.'&loc=0&i='.$db->f(0).'&t='.$db->f(0) ;
			$href.= '&connexion='.$gconnexionid ;
			$over = 'onMouseOver="window.status=\'Message sur le forum\';return true;"'	; 
			$out  = 'onMouseOut="window.status=\'Ganesha '.VERSION.'\';return true;"'	;
			$frm = '['.$date.'] <a class="student" href="'.$href.'" '.$over.' '.$out.'>'.$msg.'</a>';
			if ($mydb->f(0) > 0) {
				$frm = $frm." <b>[".$mydb->f(0)."]</b>";
			}
			put('         <TR><TD>'.$frm.'</TD></TR>');
		}
		if ( ! $init ) {
			put("<B>".$st_texte['nomess']."</B>");
		}else {
			put('       </TABLE>');
		}
	}


	/**
	* Supprime un forum
	* @param	integer	$idg numero(id) du groupe
	* @access	public
	*/
	function DeletePhorum($idg) {
	 global $TBL, $ClsGroupe, $ext, $db ;
		$sSQL = "DROP TABLE IF EXISTS g".$idg; 
		$db->query($sSQL)	;
		$sSQL = "DROP TABLE IF EXISTS g".$idg."_bodies";
		$db->query($sSQL)	;
		$id_phorum = $ClsGroupe->IdForum($idg);
		$sSQL = "DELETE FROM ".$TBL['forums']." WHERE id=".$id_phorum;	
		$db->query($sSQL)		;
		if ( file_exists(RP_MAIN."phorum/admin/forums/".$id_phorum.$ext) ) {
			unlink(RP_MAIN."phorum/admin/forums/".$id_phorum.$ext);
		}
		return(1);
	}

	/**
	* Retourne la date du dernier message poste sur le forum $idf
	* @param	integer	$idf numero(id) du forum
	* @access	public
	*/
	function LastPost ($idf) {
	 global $TBL, $db ;
		$sSQL="select table_name FROM ".$TBL['forums']." where id=".$idf ;
		if ( ! $db->query($sSQL) ) {
			return("")	;
		}
		$db->next_record();
		$table_name= $db->f("table_name");
		$sSQL = "select max(datestamp) as max_date FROM ".$table_name." where approved='Y'";
		$db->query($sSQL)	;
		$db->next_record()	;
		if( $db->num_rows() != 0 ) {
			$last = "" ;
		} else {
			$last = $db->f("max_date");
		}
		return($last);
	}

	/**
	* retourne le nombre de post sur le forum $idf
	* @param	integer	$idg numero(id) du groupe
	* @access	public
	*/
	function NbPost ($idf) {
	 global $TBL, $db ;
		$sSQL="select table_name FROM ".$TBL['forums']." where id=".$idf ;
		if ( ! $db->query($sSQL) ) {
			return(0)	;
		}
		$db->next_record();
		$table_name= $db->f("table_name");
		$sSQL="SELECT count(*) as posts FROM ".$table_name." where approved='Y'";
		$db->query($sSQL)		;
		if ( $db->num_rows() != 0 ) {
			$db->next_record()		;
			$nb   = $db->f("posts")	;
		} else {
			$nb   = 0 ;
		}
		return($nb);
	}

?>