<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion du tracking
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

$connexion 	= (isset($HTTP_GET_VARS['connexion'])?$HTTP_GET_VARS['connexion']:0)	;
$module 	= (isset($HTTP_GET_VARS['module'])?$HTTP_GET_VARS['module']:0)		;
$chapitre 	= (isset($HTTP_GET_VARS['chapitre'])?$HTTP_GET_VARS['chapitre']:0)	;

$groupe = (isset($groupe)?$groupe:0);
$score_ganesha = HTTP_STAGIAIRE."p_tracking".$ext."?connexion=".$connexion ."&module=".$module."&chapitre=".$chapitre.'&groupe='.$groupe ;

$chapitre_lu = '
<script language="JavaScript">
 var date_jour=new Date();
 var heure=date_jour.getHours()*3600;
 var min=date_jour.getMinutes()*60;
 var sec=date_jour.getSeconds();
 deb = heure + min + sec ;

 function validChapitreLu(form) {
   var date_jour=new Date();
   var heure=date_jour.getHours()*3600;
   var min=date_jour.getMinutes()*60;
   var sec=date_jour.getSeconds();
   fin = heure + min + sec ;
   form.temps.value = fin - deb ;
   form.submit();
 }
</script> 
        <form name="test" method="post" action="'.$score_ganesha.'&note=100">
		  <input name="temps" type="hidden" value="0">
          <input name="chapitrelu" type="button" class="bouton" onclick="validChapitreLu(this.form);" value="'.$st_texte['chapitrelu'].'">
        </form>';

$score_cb_js = '<script language="JavaScript">
function score_cb(form,score,time){
        form.note.value = score ;
        form.temps.value = time ;
        return 1 ;
}
</script>';


	/**
	* Affiche l'entete du tableau qui liste le tracking d'un membre pour un module
	* @param	string	$titremodule	Titre du module
	* @access	public
	*/
	function BeginTableTracking($titremodule) {
	 global $color3, $color2 ;
	 global $st_table ;
		SubTitle($titremodule );
		put('	<table width="90%" align="center" border="0" cellpadding="3" cellspacing="0">')	;
		put('	<tr bgcolor="#FFFFFF" valign="top">');
		put('	<td width="70%">');
		BeginBorder("100%",$color2);
		put('	  <table  width="100%" align=center border="0" cellpadding="0" cellspacing="0">')			;
		put('		<tr bgcolor="'.$color2.'">');
		put('		  <th align="middle" nowrap width="40%" class="title2"> '.$st_table['date'].'</th>')	;
		put('		  <th align="left" nowrap width="20%" class="title2"> '.$st_table['score'].'</th>')	;
		put('		  <th align="left" nowrap width="20%" class="title2"> '.$st_table['temps'].'</th>')	;
		put('		  <th align="left" nowrap width="20%" class="title2"> STATUS</th>')	;
		put('		</tr>');
	}

	/**
	* Ajoute une ligne au tableau tracking d'un module.
	* @param	integer	$i	Numero de ligne
	* @param	string	$date Valeur de la date 
	* @param	string	$titrechapitre Nom du chapitre
	* @param	integer	$note	valeur de la note 
	* @param	integer	$temps valeur du temps
	* @param	integer	$status valeur du status 
	* @return	string	retourne si c'est un chapitre lu
	* @access	public
	*/
	function ItemTableTracking($i,$date,$titrechapitre,$note,$temps,$status) {
	 global $st_texte ;
		//$lnote = ( $note==100 && $temps==100?$st_texte['chapitrelu']:$note)	;
		//$ltemps= ( $note==100 && $temps==100?"&nbsp;":FormatTime($temps))	;
		$lnote = $note	;
		$ltemps= FormatTime($temps)	;
		put('		<tr bgcolor="'.GetColor($i).'">')						;
		put('		  <td align="middle" nowrap>'.$date.'</td>')			;
		put('		  <td align="left" nowrap >'.$lnote.'</td>')			;
		put('		  <td align="left" nowrap >'.$ltemps.'</td>')			;
		put('		  <td align="left" nowrap >'.$status.'</td>')			;
		put('		</tr>')	;
		return($lnote)		;
	}

	/**
	* Ferme le tableau qui liste le tracking d'un membre pour un module
	* @access	public
	*/
	function CloseTableTracking($stat) {
		global $color2, $st_table ;
		$i=1;
		put('	  </table>')	;
		CloseBorder();
		put('   </td>')	;
		put('	<td width="30%">');
		BeginBorder("100%",$color2);
		put('	  <table width="100%" align=center border="0" cellpadding="0" cellspacing="0">')			;
		put('		<tr bgcolor="'.$color2.'">');
		put('		  <td align="middle" nowrap width="40%" class="title2">&nbsp;</td>')	;
		put('		  <td align="left" nowrap width="60%" class="title2">'.$st_table['valeur'].'</td>')	;
		put('		</tr>');
		if ( is_array($stat) ) {
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['nombre'].'</td>')	;
			put('		  <td align="left" nowrap width="60%" >'.$stat['count'].'</td>')	;
			put('		</tr>');
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['max'].'</td>')	;
			put('		  <td align="left" nowrap width="60%" >'.$stat['max'].'</td>')	;
			put('		</tr>');
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['min'].'</td>')	;
			put('		  <td align="left" nowrap width="60%" >'.$stat['min'].'</td>')	;
			put('		</tr>');
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['somme'].'</td>')	;
			put('		  <td align="left" nowrap width="60%" >'.$stat['sum'].'</td>')	;
			put('		</tr>');
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['moyenne'].'</td>')	;
			$stat['mean']	= number_format($stat['mean'], 2, ".", "");
			$stat['mean']	= str_replace(".00","",$stat['mean']);
			put('		  <td align="left" nowrap width="60%" >'.$stat['mean'].'</td>')	;
			put('		</tr>');
		} else {
			put('		<tr bgcolor="'.GetColor($i++).'">');
			put('		  <td align="middle" nowrap width="40%" > '.$st_table['nombre'].'</td>')	;
			put('		  <td align="left" nowrap width="60%" >'.$stat.'</td>')	;
			put('		</tr>');
		}
		put('	  </table>');
		CloseBorder();
		put('   </td>')	;
		put('   </tr>')	;
		put('   </table>')	;
		CloseBorder()	;
		BR(2)			;
	}

	/**
	* Ferme le tableau qui liste le tracking d'un membre pour un module
	* @param	integer	$module	Numero du module
	* @param	string	$chapitre numero du chapitre
	* @access	public
	*/
	function Graph($module,$chapitre='') {
	global $ext, $gconnexionid, $tu_titre ;
		$height = ($chapitre==''?450:250);
		$url  = HTTP_COMMUN.'p_graph'.$ext.'?connexion='.$gconnexionid."&module=".$module."&chapitre=".$chapitre ;
		$click  = "onClick=\"openWindow('".$url."','graph','scrollbars=yes,width=500,height=".$height."')\" ";
		return(' <A class="title2" href="#" '.$click.'><img align="absmiddle" border="0" src="'.HTTP_IMAGES.'graph.gif"></A>'); 
	}

	/**
	* Ajoute un nouveau tracking dans la base
	* @access	public
	*/
	function addTracking($score,$time,$module,$chapitre,$grp) {
		global $guserid, $st_titre, $st_texte ;
		global $ClsTracking, $ClsChapitre, $ClsModule ;
		if ( strlen(trim($score))==0   ||
			 strlen(trim($time))==0    ||
			 strlen(trim($module))==0  ||
			 strlen(trim($grp))==0  ||
			 strlen(trim($chapitre))==0 ) {
			put ("<b>Erreur : Aucun champ ne doit etre vide !</b><br>");
			put ("score=>[".$score."] | time=>[".$time."] | module=>[".$module."] | chapitre=>[".$chapitre."] | groupe=>[".$grp."]");
			ClosePageHtml()	;
			exit		;
		}

		$ClsTracking->Add($guserid,$module,$chapitre,$score,$time,$grp)	;
		$nbchapitre = $ClsChapitre->NbQuizz($module);
		if ( $nbchapitre == 0 ) {
			$avance=0 ;
		} else {
			$nbchaptertracked = $ClsTracking->NbChapterTracked($guserid,$module,$grp)	;
			$avance = number_format(($nbchaptertracked/$nbchapitre)*100,2,",","")	;
		}

		Title( $st_titre['resultest']);
		BR();

		SubTitle($st_texte['result1']);
		$myscore	= " - ".$st_texte['result1']."<b>".$score." %</b> "							;
		$mymodule	= $st_texte['result2']." <b>".$ClsChapitre->Title($module, $chapitre)."</b> ";
		$mychapitre	= $st_texte['result3']." <b>".$ClsModule->Title($module)."</b>"				;
		put($myscore.$mymodule.$mychapitre);
		BR(2);

		SubTitle($st_texte['result4']);
		$lgko = (100 - $avance)								;
		$imgspace = '<IMG src="'.HTTP_IMAGES.'space.gif" width="10" height="10">'			;
		$imgok    = '<IMG src="'.HTTP_IMAGES.'ok.gif" width="'.$avance.'" height="10">'	;
		$imgko    = '<IMG src="'.HTTP_IMAGES.'ko.gif" width="'.$lgko.'" height="10">'		;
		$image    = $imgspace.$imgok.$imgko.$avance.'%' ;
		put(" - ".$st_texte['result4']." : <b>".$nbchaptertracked."/".$nbchapitre." (".$avance."%)</b>".$image);
		BR(2);
	}

	/**
	* Affiche le sommaire des chapitre pour un module
	* @param	integer	$module	Numero du module
	* @param	string	$chap numero du chapitre
	* @param	integer	$userid id du user
	* @access	public
	*/
//	function displayTracking($module,$chap=0,$userid=0) {
	function displayTracking() {
		global $ClsTracking, $ClsChapitre, $st_texte, $st_table;

		$oldChapitre= ''	;
		//$chapitreLu	= false	;
		$link		= 0		;
		$line		= 0		;
		$data = array()		;
		while ( $ret = $ClsTracking->NextItem() ) {
			die();
			$line++ ;
			$module_id	= $ret['moduleId']	; // if $userid
			$chapitre	= $ret['chapitreId'];
			$date		= $ret['date']		;
			$note		= $ret['note']		;
			$temps		= $ret['temps']		;
			
			$module = ($module==0?$module_id:$module);
			$titrechapitre=$ClsChapitre->Title($module,$chapitre)	;

			if ( $oldChapitre != $chapitre ) {
//			echo("---".$chapitre);
				// nouveau
				if ( $oldChapitre != '' ) {
					// Terminer l'ancien tableau
					$stat = stats($data) ;
					//$stat = ( $chapitreLu == true ? $stat['count']:$stat);
					CloseTableTracking($stat);
					unset($data);
					$data = array();
					//if ( ! $chapitreLu ) { put ( Graph($module,$oldChapitre) ); }
					put ( Graph($module,$oldChapitre) );
					linkAnchor("Top","Top",true);
					BR();
				}
				BeginTableTracking($st_table['chapitre'].' : '.$titrechapitre);
				$oldChapitre = $chapitre ;
			}
			$data[] = $note ;
			$ret = ItemTableTracking($line,$date,$titrechapitre,$note,$temps)	;
			//$chapitreLu = (($note==100 && $temps==100)?true:false);
		} //  while

		if (  $oldChapitre != '' ) {
			$stat = stats($data) ;
			//$stat = ( $chapitreLu == true ? $stat['count']:$stat);
			CloseTableTracking($stat);
			//if ( ! $chapitreLu ) { put ( Graph($module,$oldChapitre) ); }
			put ( Graph($module,$oldChapitre) );
			linkAnchor("Top","Top",true);
			BR();
		} 
	}

	/**
	* Affiche le sommaire des chapitre pour un module
	* @param	integer	$idu	id du user
	* @param	string	$idm	id du module
	* @param	integer	$idc	id du chapitre
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function displayTrackingChapitre($idu,$idm,$idc,$idg) {
		global $ClsTracking, $ClsChapitre, $st_texte, $st_table, $module, $NORME_STATUS ;

		$ret = $ClsTracking->readTrackingUser($idu,$idg) ;
		$tab = $ret[$idm]; // defini le module
		if ( is_array($tab) ) {
			$chapitre = array_keys ($tab);
			for($chap=0;$chap<count($chapitre);$chap++) {
				if ( $chapitre[$chap] != $idc ) {
					continue;
				}
				$titrechapitre = $ClsChapitre->Title($idm,$idc);
				BeginTableTracking($titrechapitre);
				$date = array_keys($tab[$idc]);
				$line = 0 ;
				$data = array();
				for($track=0;$track<count($date);$track++) {
					$score = $tab[$idc][$date[$track]]['note'];
					$time  = $tab[$idc][$date[$track]]['temps'];
					$status = $NORME_STATUS[$tab[$idc][$date[$track]]['status']];
					$data[] = $score ;
					ItemTableTracking($line++,$date[$track],$titrechapitre,$score,$time,$status) ;
				}
				$stat = stats($data) ;
				CloseTableTracking($stat);
				//put(Graph($idm,$idc));
				linkAnchor("Top","Top",true);
				BR();
			}
		}
	}

	/**
	* Affiche le tracking des chapitres pour un module
	* @param	integer	$idu	id du user
	* @param	string	$idm	id du module
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function displayTrackingModule($idu,$idm,$idg) {
		global $ClsTracking, $ClsChapitre, $st_texte, $st_table, $module ;

		$ret = $ClsTracking->readTrackingUser($idu,$idg) ;
		$tab = isset($ret[$idm])?$ret[$idm]:0; // defini le module
		if ( is_array($tab) ) {
			//put(Graph($idm));
			$chapitre = array_keys ($tab);
			for($chap=0;$chap<count($chapitre);$chap++) {
				displayTrackingChapitre($idu,$idm,$chapitre[$chap],$idg) ;
			}
		}
	}

?>