<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//ACS check
if (!isset($rss_access_granted) && (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['poll'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP POLL ------------------------------------------------------------
require_once('class/Poll.class.php');
$poll = new Poll($db, null);
$poll->rsp_level_id = $rsp_level_id;

if (isset($_REQUEST['poll_id'])) {
	$poll->poll_id = $_REQUEST['poll_id'];
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['poll']);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;


// SETUP TAGS ------------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['poll']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}


// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['poll'], $me['user_id']);
}


// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['poll_id'];
	$tag->deleteTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: pol_view.php?poll_id=". $frmdata['poll_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['preview'])) {
	unset($poll->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$poll->poll_id = $_REQUEST['poll_id'];
	
	$output_poll = $poll->selPoll();
	
	$display = "preview_comment";
}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['poll_id'];
	$comment->insertComment($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db);
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());

		return header("Location: pol_view.php?poll_id=". $frmdata['poll_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	unset($poll->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$poll->poll_id = $_REQUEST['poll_id'];
	
	$output_poll = $poll->selPoll();
}
elseif ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) || !empty($_REQUEST['tag'])) {
	
	if (!empty($_REQUEST['tag'])) {
		$poll->tag = $_REQUEST['tag'];
	}
	
	//get the latest node polls
	$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_polls = $poll->selPolls(trim($frmdata['search_text']));
}
elseif (isset($frmdata['options']) && $frmdata['options'] != "list_node") {
	if ($frmdata['options'] == "list_relation") {
		unset($poll->rsp_level_id);
		//get the latest relations polls
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$poll->file = $file;
		
		foreach($_SESSION['relations'] as $key => $i):
			$poll->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		if (!empty($poll->user_ids)) {
			$output_polls = $poll->selPolls();
		}
	}
	elseif ($frmdata['options'] == "list_my") {
		unset($poll->rsp_level_id);
		//get my polls
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$poll->file = $file;
		$poll->user_id = $me['user_id'];
		
		$output_polls = $poll->selPolls();
	}
	elseif ($frmdata['options'] == "list_marked") {
		unset($poll->rsp_level_id);
		//get my marked polls
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$poll->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$watched_poll_ids = $bookmark->getBookmarks();
		
		$poll->user_id = $me['user_id'];
		
		if (!empty($watched_poll_ids)) {
			$poll->poll_ids = $watched_poll_ids;
			$output_polls = $poll->selPolls();
		}
	}
	elseif ($frmdata['options'] == "list_relation_tips") {
		unset($poll->rsp_level_id);
		//get my relations tipped polls
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$poll->file = $file;
		
		unset($bookmark->user_id);
		foreach($_SESSION['relations'] as $key => $i):
			$bookmark->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$recommended_poll_ids = $bookmark->getBookmarks();
		
		if (!empty($recommended_poll_ids)) {
			$poll->poll_ids = $recommended_poll_ids;
			$output_polls = $poll->selPolls();
		}
		
	}
	elseif ($frmdata['options'] == "list_user") {
		unset($poll->rsp_level_id);
		//get polls for this user (if relation)
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$poll->file = $file;
		
		if (!empty($_SESSION['relations'])) {
			foreach($_SESSION['relations'] as $key => $i):
				if (!empty($frmdata['user_id']) && $frmdata['user_id'] == $i['user_id_relation']) {
					$poll->user_id = $frmdata['user_id'];
					
					$output_polls = $poll->selPolls();
					
					break;
				}
			endforeach;
		}
	}
	elseif ($frmdata['options'] == "item_mark") {
		unset($poll->rsp_level_id);
		//mark this item
		$bookmark->item_id = $frmdata['poll_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->insertBookmark();
		
		$poll->poll_id = $frmdata['poll_id'];
		$output_poll = $poll->selPoll();
	}
	elseif ($frmdata['options'] == "item_tip") {
		unset($poll->rsp_level_id);
		//tip this item
		$bookmark->item_id = $frmdata['poll_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
		
		$poll->poll_id = $frmdata['poll_id'];
		$output_poll = $poll->selPoll();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: pol_edit.php?poll_id=" . $frmdata['poll_id'] . "&".SID);
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: pol_edit.php?".SID);
		exit;
	}
	
	$display = $frmdata['options'];
}
elseif (isset($_REQUEST['poll_id']) && (!isset($frmdata['options']) || $frmdata['options'] != "list_node")) {
	$poll->poll_id = $_REQUEST['poll_id'];
	
	$output_poll = $poll->selPoll();
}
else {
	//get the latest node polls
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];

	$poll->file = $file;
	$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_polls = $poll->selPolls();
}


// CHECK PERMISSION TO VIEW POLL ------------------------------------------
if (!empty($output_poll)) {
	// Are we allowed to see this poll?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['poll']);
	$output_poll['rsp'] = $rsp->selRspItem($poll->poll_id);
	
	if (isset($me['user_id']) && $me['user_id'] == $output_poll['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (!empty($output_poll['rsp'])) {
		// is the item published to node or public and can I see it?
		foreach ($output_poll['rsp'] as $key => $i):
			if ($i['level_id'] == $rsp_level_id) {
				$allow_view = 1;
				break;
			}
			
			// is it set to network and ar they in my network?
			if (!empty($i['degree_id'])) {
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_poll['user_id'] == $i['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!isset($allow_view)) {
		unset($output_poll);
	}
}


if (!empty($output_poll)) {
	if (isset($me['user_id'])) {
		$output_poll['current_answer']= $poll->pollUserCurrentVote($me['user_id']);
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', "lib_view.php?user_id=" . $output_poll['user_id'] . "&page=");
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', "lib_edit.php?page=");
	$wiki->setRenderConf('xhtml', 'image', 'base', "get_file.php?file=");
	$output_poll['poll_body_display'] = $wiki->transform($output_poll['poll_body'], 'Xhtml');
	
	// GET AUTHOR
	$output_author = $user->selProfile(null, $output_poll['user_id']);
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $poll->poll_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_poll['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_poll['bookmark']['recommend'] = 1;
		}
	}
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($poll->poll_id);
	
	//get users vote for each comment
	if (isset($output_comments)) {
		foreach($output_comments as $key => $i):
			$output_comments[$key]['vote'] = $poll->pollUserVoteHistory($i['user_id']);
		endforeach;
	}
	
	
	//get tags
	$tag->item_id = $poll->poll_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags();
}



if (!empty($output_polls)) {
	foreach($output_polls as $key => $i):
		unset($comment->user_id, $comment->section_item_id, $comment->rsp_item_type_id);
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		$output_polls[$key]['comment_total'] = $comment->getCommentCount($i['poll_id']);
	endforeach;
	
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
	foreach ($output_polls as $key => $i):
		$tag->item_id = $i['poll_id'];
		$output_polls[$key]['tags'] = $tag->selTags();
	endforeach;
}


//move to template
if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (!empty($output_poll)) {
	$body->set('poll', $output_poll);
	$body->set('rsp_config', $c_node['rsp']); 
}

if (!empty($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

$template_pageLink = $lang['txt_poll'];

include "inc/footer.inc.php";

?>
