<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "magazine";
include "inc/header.inc.php";


//ACS check
if (!isset($rss_access_granted) && (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['blog'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


// SETUP BLOG ------------------------------------------------------------
require_once('class/Blog.class.php');
$blog = new Blog($db, null, null);
$blog->rsp_level_id = $rsp_level_id;


// SETUP LANGUAGE --------------------------------------------------------
require_once($languageArrayPath . 'arr_user.lang.php');


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


// SETUP COMMENTS --------------------------------------------------------
require_once('class/Comment.class.php');
$comment = new Comment($db, $c_node['rsp']['item_type']['blog']);

if (isset($me['user_id'])) {
	$comment->user_id = $me['user_id'];
}

$comment->wiki = $wiki;


// SETUP TAGS ------------------------------------------------------------
require_once('class/Tag.class.php');
$tag = new Tag($db, $c_node['rsp']['item_type']['blog']);

if (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
}

// SETUP BOOKMARKS -------------------------------------------------------
if (isset($me['user_id'])) {
	require_once('class/Bookmark.class.php');
	$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['blog'], null);
	$bookmark->user_id = $me['user_id'];
}



// PROCESS FORM ----------------------------------------------------------
if (isset($_POST['update_tag'])) {
	$frmdata['item_id'] = $frmdata['blog_id'];
	$tag->deleteItemTags($frmdata);
	$tag->insertTags($frmdata);
	
	return header("Location: blg_view.php?blog_id=". $frmdata['blog_id'] . "&" . strip_tags(SID));
	exit;
}
elseif (isset($_POST['preview'])) {
	unset($blog->rsp_level_id);
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['comment_body'] = str_replace("\"", "'", $output_comment['comment_body']);
	$output_comment['display_comment_body'] = $wiki->transform($output_comment['comment_body'], 'Xhtml');
	
	$blog->blog_id = $_REQUEST['blog_id'];
	
	$output_blog = $blog->selBlog();
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $frmdata['blog_id'];
	$comment->insertComment($frmdata);
	
	if (empty($GLOBALS['igloo_error_log'])) {
		//setup statistics
		require_once('class/Statistic.class.php');
		$statistic = new Statistic($db, $date);
		//update stats
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id, $comment->section_id, $comment->section_item_id);
		$statistic->user_id = $me['user_id'];
		$statistic->setStatistic($comment->getCommentCount());

		return header("Location: blg_view.php?blog_id=". $frmdata['blog_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	
	$blog->blog_id = $_REQUEST['blog_id'];
	
	$output_blog = $blog->selBlog();
}
elseif ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) || !empty($_REQUEST['tag'])) {
	
	if (!empty($_REQUEST['tag'])) {
		$blog->tag = $_REQUEST['tag'];
	}
	
	//get the latest node blogs
	$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_blogs = $blog->selBlogs(trim($frmdata['search_text']));
}
elseif (isset($_POST['list_all'])) {
	//get the latest node blogs
	if (!empty($frmdata['user_id'])) {
		$blog->user_id = $frmdata['user_id'];
	}
	
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];

	$blog->file = $file;
	$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	
	$output_blogs = $blog->selBlogs();
}
elseif (isset($frmdata['options']) && $frmdata['options'] != "list_node") {
	if ($frmdata['options'] == "list_relation") {
		//get the latest relations blogs
		unset($blog->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		
		foreach($_SESSION['relations'] as $key => $i):
			$blog->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		if (!empty($blog->user_ids)) {
			$output_blogs = $blog->selBlogs();
		}
	}
	elseif ($frmdata['options'] == "list_my") {
		//get my blogs
		unset($blog->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		$blog->user_id = $me['user_id'];
		
		$output_blogs = $blog->selBlogs();
	}
	elseif ($frmdata['options'] == "list_marked") {
		//get my marked blogs
		unset($blog->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$watched_blog_ids = $bookmark->getBookmarks();
		
		$blog->user_id = $me['user_id'];
		
		if (!empty($watched_blog_ids)) {
			$blog->blog_ids = $watched_blog_ids;
			$output_blogs = $blog->selBlogs();
		}
	}
	elseif ($frmdata['options'] == "list_relation_tips") {
		//get my relations tipped blogs
		unset($blog->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		
		unset($bookmark->user_id);
		foreach($_SESSION['relations'] as $key => $i):
			$bookmark->user_ids[] = $i['user_id_relation'];
		endforeach;
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$recommended_blog_ids = $bookmark->getBookmarks();
		
		if (!empty($recommended_blog_ids)) {
			$blog->blog_ids = $recommended_blog_ids;
			$output_blogs = $blog->selBlogs();
		}
		
	}
	elseif ($frmdata['options'] == "list_user") {
		//get blogs for this user (if relation)
		unset($blog->rsp_level_id);
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$blog->file = $file;
		
		if (!empty($_SESSION['relations'])) {
			foreach($_SESSION['relations'] as $key => $i):
				if (!empty($frmdata['user_id']) && $frmdata['user_id'] == $i['user_id_relation']) {
					$blog->user_id = $frmdata['user_id'];
					
					$output_blogs = $blog->selBlogs();
					
					break;
				}
			endforeach;
		}
	}
	elseif ($frmdata['options'] == "item_mark") {
		//mark this item
		$bookmark->item_id = $frmdata['blog_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		$bookmark->insertBookmark();
		
		$blog->blog_id = $frmdata['blog_id'];
		$output_blog = $blog->selBlog();
	}
	elseif ($frmdata['options'] == "item_tip") {
		//tip this item
		$bookmark->item_id = $frmdata['blog_id'];
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		$bookmark->insertBookmark();
		
		$blog->blog_id = $frmdata['blog_id'];
		$output_blog = $blog->selBlog();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: blg_edit.php?blog_id=" . $frmdata['blog_id'] . "&". strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: blg_edit.php?". strip_tags(SID));
		exit;
	}
	
	$display = $frmdata['options'];
}
elseif (isset($_REQUEST['blog_id']) && (!isset($frmdata['options']) || $frmdata['options'] != "list_node")) {
	unset($blog->rsp_level_id);
	$blog->blog_id = $_REQUEST['blog_id'];
	
	$output_blog = $blog->selBlog();
}
else { // get the latest item published to node
	$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
	$blog->file = $file;
	
	$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
		
	$output_blogs = $blog->selBlogs();
}


// CHECK PERMISSION TO VIEW BLOG ------------------------------------------
if (!empty($output_blog)) {
	// Are we allowed to see this blog?
	require_once($languageArrayPath . 'arr_rsp.lang.php');
	
	require_once('class/Rsp.class.php');
	$rsp = new Rsp($db, $c_node['rsp']['item_type']['blog']);
	$output_blog['rsp'] = $rsp->selRspItem($blog->blog_id);
	
	if (isset($me['user_id']) && $me['user_id'] == $output_blog['user_id']) {
		// is the author me?
		$allow_view = 1;
	}
	elseif (!empty($output_blog['rsp'])) {
		// is the item published to node or public and can I see it?
		foreach ($output_blog['rsp'] as $key => $i):
			if ($i['level_id'] == $rsp_level_id) {
				$allow_view = 1;
				break;
			}
			
			// is it set to network and ar they in my network?
			if (!empty($i['degree_id'])) {
				foreach($_SESSION['relations'] as $key => $r):
					if ($output_blog['user_id'] == $r['user_id_relation']) {
						$allow_view = 1;
						break;
					}
					
					if (isset($allow_view)) {
						break;
					}
				endforeach;
			}
		endforeach;
	}
	
	if (!isset($allow_view)) {
		unset($output_blog);
	}
}


if (!empty($output_blog)) {
	//wikify body
	$wiki_path = "lib_view.php?page=";
	$wiki_new_path = "lib_edit.php?page=";
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');
	
	// GET AUTHOR
	$output_author = $user->selProfile(null, $output_blog['user_id']);
	
	
	// GET BOOKMARK --------------------------------------------------
	if (isset($bookmark)) {
		$bookmark->item_id = $blog->blog_id;
		$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_blog['bookmark']['watch'] = 1;
		}
		
		$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
		if ($bookmark->getBookmark()) {
			$bookmark->updateBookmark();
			$output_blog['bookmark']['recommend'] = 1;
		}
	}
	
	//get comments
	unset($comment->user_id);
	$output_comments = $comment->selComments($blog->blog_id);
	
	
	//get tags
	$tag->item_id = $blog->blog_id;
	$output_my_tags = $tag->selTags();
	unset($tag->user_id);
	$output_item_tags = $tag->selTags();
	
	
	//get a list of the latest blogs for the side menu
	$blog->user_id = $output_blog['user_id'];
	$blog->limit = 10;
	
	$output_sidebar_blogs = $blog->selBlogs();
}


if (!empty($output_blogs)) {
	foreach($output_blogs as $key => $i):
		unset($comment->user_id, $comment->section_id, $comment->section_item_id, $comment->rsp_item_type_id);
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$output_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
	endforeach;
	
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	foreach ($output_blogs as $key => $i):
		$tag->item_id = $i['blog_id'];
		$output_blogs[$key]['tags'] = $tag->selTags();
	endforeach;
}


if (!empty($output_sidebar_blogs)) {
	unset($comment->user_id);
	foreach($output_sidebar_blogs as $key => $i):
		$output_sidebar_blogs[$key]['comment_total'] = $comment->getCommentCount($i['blog_id']);
	endforeach;
}



//move vars to template
if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}

if (!empty($frmdata['search_text'])) {
    $body->set('search_text', $frmdata['search_text']);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($frmdata)) {
	$body->set('frmdata', $frmdata);
}

if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
	$body->set('rsp_config', $c_node['rsp']);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_sidebar_blogs)) {
	$body->set('sidebar_blogs', $output_sidebar_blogs);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_blog)) {
	$template_pageLinkNote = $output_blog['blog_title'];
}

$template_pageLink = $lang['txt_blog'];

include "inc/footer.inc.php";

?>