<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "magazine";

include "inc/header.inc.php";


//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//get blogs -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['blog'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $file);
	$blog->rsp_level_id = $rsp_level_id;
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	$blog->limit = 10;
	$output_blogs = $blog->selBlogs();
}


//get library items -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['library'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], $file);
	$library->rsp_level_id = $rsp_level_id;
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	$library->limit = 10;
	$output_library_items = $library->selLibraryItems();
}


//get polls  -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['poll'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Poll.class.php');
	$poll = new Poll($db, $c_node['rsp']['item_type']['poll']);
	$poll->order_by = "p.poll_start_datetime desc";
	$poll->rsp_level_id = $rsp_level_id;
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	$poll->limit = 10;
	$output_polls = $poll->selPolls();
}


//get subjects  -----------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['forum'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Forum.class.php');
	$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $file);
	$forum->rsp_level_id = $rsp_level_id;
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	$forum->limit = 10;
	$output_subjects = $forum->selSubjects();
}


// SETUP SCHEDULE ------------------------------------------------------------
if ($user_acs->checkPermission($c_acs['arr_acs']['resource']['schedule'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	require_once('class/Schedule.class.php');
	$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
	$schedule->schedule_config = $c_node['schedule'];
	$schedule->rsp_level_id = $rsp_level_id;
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	$schedule->limit = 10;
	$output_schedule_items = $schedule->selScheduleItems();
}


//create RSS URL
$url = "http://" . $_SERVER['HTTP_HOST'];
$url .= dirname ($_SERVER['PHP_SELF']);
//sometimes the server adds / as the last characture - we need to check.
if (substr($url, -1, 1) != "/") {
	$url .= "/";
}

$rss_public_url = $url . "rss_feed.php";
	
if (isset($me['user_id']) && $me['user_id'] > 0) {
	$rss_url = $url . "rss_feed.php?feed=" . $me['user_feed_password'] . $me['user_id'];
}


//move to template
$body->set('rss_public_url', $rss_public_url);
	
if (!empty($rss_url)) {
	$body->set('rss_url', $rss_url);
}

if (!empty($output_schedule_items)) {
	$body->set('schedule_items', $output_schedule_items);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
}


if (!empty($output_search_results)) {
	$body->set('search_results', $output_search_results);
}

if (!empty($search)) {
	$body->set('search', $search);
}

if (!empty($display)) {
	$body->set('display', $display);
}

$template_pageLink = $lang['txt_magazine_name'];
include "inc/footer.inc.php";
?>
