<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";
include "inc/header.inc.php";

if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_newsletter'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


require_once($languageArrayPath . 'arr_newsletter.lang.php');


//SETUP NEWSLETTER -------------------------------------------------------------
require_once('class/Newsletter.class.php');
$nl = new Newsletter($db, $c_node['newsletter']);
$nl->user_status_ids = $c_node['user']['status'];


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki = new Text_Wiki();
$wiki->disableRule('wikilink');


if (isset($frmdata['options'])) {
	if ($frmdata['options'] == "list") {
		$output_newsletters = $nl->selNewsletters();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: nlt_edit.php?message_id=" . $frmdata['message_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: nlt_edit.php?" . strip_tags(SID));
		exit;
	}
}
elseif (!empty($_REQUEST['message_id'])) {
	$output_newsletter = $nl->selNewsletter($_REQUEST['message_id']);
	//wikify body
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_newsletter['message_body'] = $wiki->transform($output_newsletter['message_body'], 'Xhtml');
	
}
else {
	$output_newsletters = $nl->selNewsletters();
}

//move to template
if (isset($_REQUEST['complete'])) {
	$body->set('total_emails_sent', $_REQUEST['complete']);
}

if (isset($_REQUEST['batch_complete'])) {
	$body->set('batch_complete', $_REQUEST['batch_complete']);
}

if (!empty($output_newsletter)) {
	$body->set('newsletter', $output_newsletter);
}

if (!empty($output_newsletters)) {
	$body->set('newsletters', $output_newsletters);
}

include "inc/footer.inc.php";

?>
