<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Shout {
	// CLASS FUNCTIONS
	// Shout
	// getShout
	// getShouts
	// insertShout



	// Shout --------------------------------------------------------------------
	// the constructor
	// tom calthrop - 8th Nov 2004
	//
	function Shout($db) {
		$this->db = $db;
	}//EO Shout



	// getShout --------------------------------------------------------------------
	// returns single row from DB
	// tom calthrop - 8th Nov 2004
	//
	function getShout() {
		$query = "
			SELECT s.shoutbox_id, s.shoutbox_body, s.shoutbox_create_datetime, s.user_id, p.profile_nic
			FROM " . $this->db->prefix . "_shoutbox s
			LEFT JOIN " . $this->db->prefix . "_user_profile p on s.user_id=p.user_id
			WHERE
			p.profile_default=1
			order by s.shoutbox_create_datetime desc"
		;

		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();

			if (isset($temp['shoutbox_id'])) {
				return $temp;
			}
		}
		else {
			$error_info = "function=getShout class=Shout.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getShout



	// getShouts --------------------------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 8th Nov 2004
	//
	function getShouts() {
		$query = "
			SELECT s.shoutbox_body, s.shoutbox_create_datetime, s.user_id, p.profile_nic
			FROM " . $this->db->prefix . "_shoutbox s
			LEFT JOIN " . $this->db->prefix . "_user_profile p ON s.user_id=p.user_id
			WHERE
			p.profile_default=1 AND "
		;

		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}

		$query .= "1=1 ";

		$query .= "order by s.shoutbox_create_datetime desc";

		if (isset($this->limit)) {
		    $result = $this->db->SelectLimit($query, $this->limit);
		}
		else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getShouts class=Shout.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getShouts


	// insertShout --------------------------------------------------------------------
	// inserts row into DB
	// tom calthrop - 8th Nov 2004
	//
	function insertShout($data) {
		
		$rec = array();
		$rec['shoutbox_body'] = $data['shout_text'];
		$rec['user_id'] = $this->user_id;
		$rec['shoutbox_create_datetime'] = time();
		
		$table = $this->db->prefix . "_shoutbox";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO insertShout
}
?>
