/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.BTreeException;
import com.coyotegulch.jisp.BTreePageFile;
import com.coyotegulch.jisp.DuplicateKey;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectIndex;
import com.coyotegulch.jisp.Page;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;

public class BTreeIndex
extends BTreePageFile
implements ObjectIndex {
    private static final KeyNotFound err_key_not_found = new KeyNotFound("key not found in BTreeIndex");
    private static final DuplicateKey err_duplicate_key = new DuplicateKey("duplicate key found in BTreeIndex");
    private Page m_root = this.readRoot();
    private IndexedObjectDatabase m_database = null;

    public static int computeOrder(int n, int n2) {
        int n3 = n < 1 || n2 < 1 ? 7 : (int)Math.pow(n, 1.0 / (double)n2) + 1;
        return n3;
    }

    public BTreeIndex(String string) throws IOException, ClassNotFoundException {
        super(string);
    }

    public BTreeIndex(String string, int n, KeyObject keyObject, boolean bl) throws IOException, ClassNotFoundException {
        super(string, n, keyObject, bl);
    }

    public void close() throws IOException {
        this.emptyPageCache();
        super.close();
    }

    public int count() {
        return this.m_header.m_count;
    }

    public long ticker() {
        return this.m_header.m_ticker;
    }

    public void insertKey(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        SearchResult searchResult = this.searchInsert(this.m_root, keyObject);
        if (searchResult.m_found && !this.m_header.m_hasDupes) {
            throw err_duplicate_key;
        }
        this.writeKey(searchResult, keyObject, l);
        ++this.m_header.m_count;
        ++this.m_header.m_ticker;
        this.rewriteHeader();
    }

    public void replaceKey(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        SearchResult searchResult = this.search(this.m_root, keyObject, false);
        if (!searchResult.m_found) {
            throw err_key_not_found;
        }
        searchResult.m_page.m_recPtr[searchResult.m_position] = l;
        this.write(searchResult.m_page, false);
        this.m_root = this.readRoot();
    }

    public void storeKey(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        SearchResult searchResult = this.search(this.m_root, keyObject, false);
        if (searchResult.m_found) {
            searchResult.m_page.m_recPtr[searchResult.m_position] = l;
            this.write(searchResult.m_page, false);
        } else {
            this.writeKey(searchResult, keyObject, l);
            ++this.m_header.m_count;
            ++this.m_header.m_ticker;
            this.rewriteHeader();
        }
    }

    public long findKey(KeyObject keyObject) throws IOException, ClassNotFoundException {
        return this.findKey(keyObject, false);
    }

    public long findKey(KeyObject keyObject, boolean bl) throws IOException, ClassNotFoundException {
        SearchResult searchResult = this.search(this.m_root, keyObject, bl);
        if (searchResult.m_found) {
            return searchResult.m_page.m_recPtr[searchResult.m_position];
        }
        throw err_key_not_found;
    }

    public void removeKey(KeyObject keyObject) throws IOException, ClassNotFoundException {
        SearchResult searchResult = this.search(this.m_root, keyObject, false);
        if (!searchResult.m_found) {
            throw err_key_not_found;
        }
        if (searchResult.m_page.m_link[0] == -1L) {
            --searchResult.m_page.m_header.m_numKeys;
            int n = searchResult.m_position;
            while (n < searchResult.m_page.m_header.m_numKeys) {
                searchResult.m_page.m_key[n] = searchResult.m_page.m_key[n + 1];
                searchResult.m_page.m_recPtr[n] = searchResult.m_page.m_recPtr[n + 1];
                ++n;
            }
            searchResult.m_page.m_key[searchResult.m_page.m_header.m_numKeys] = this.m_header.m_nullKey.makeNullKey();
            searchResult.m_page.m_recPtr[searchResult.m_page.m_header.m_numKeys] = -1L;
            this.write(searchResult.m_page, false);
            if (searchResult.m_page.m_header.m_numKeys < this.m_header.m_minKeys) {
                this.adjustTree(searchResult.m_page);
            }
        } else {
            Page page = this.read(searchResult.m_page.m_link[searchResult.m_position + 1]);
            while (page.m_link[0] != -1L) {
                page = this.read(page.m_link[0]);
            }
            searchResult.m_page.m_key[searchResult.m_position] = page.m_key[0];
            searchResult.m_page.m_recPtr[searchResult.m_position] = page.m_recPtr[0];
            --page.m_header.m_numKeys;
            int n = 0;
            while (n < page.m_header.m_numKeys) {
                page.m_key[n] = page.m_key[n + 1];
                page.m_recPtr[n] = page.m_recPtr[n + 1];
                page.m_link[n + 1] = page.m_link[n + 2];
                ++n;
            }
            page.m_key[page.m_header.m_numKeys] = this.m_header.m_nullKey.makeNullKey();
            page.m_recPtr[page.m_header.m_numKeys] = -1L;
            page.m_link[page.m_header.m_numKeys + 1] = -1L;
            this.write(searchResult.m_page, searchResult.m_page.m_header.m_parentPtr == -1L);
            this.write(page, false);
            if (page.m_header.m_numKeys < this.m_header.m_minKeys) {
                this.adjustTree(page);
            }
        }
        --this.m_header.m_count;
        this.rewriteHeader();
    }

    private SearchResult search(Page page, KeyObject keyObject, boolean bl) throws IOException, BTreeException, ClassNotFoundException {
        int n;
        if (page.m_header.m_numKeys == 0) {
            return new SearchResult(false, page, n);
        }
        for (n = 0; n != page.m_header.m_numKeys; ++n) {
            int n2 = page.m_key[n].compareTo(keyObject);
            if (n2 == 0 || bl && n2 == 1) {
                return new SearchResult(true, page, n);
            }
            if (n2 != -1) break;
        }
        if (page.m_link[n] == -1L) {
            return new SearchResult(false, page, n);
        }
        return this.search(this.read(page.m_link[n]), keyObject, bl);
    }

    private SearchResult searchWithPosition(Page page, KeyObject keyObject, boolean bl) throws IOException, BTreeException, ClassNotFoundException {
        int n;
        if (page.m_header.m_numKeys == 0) {
            return new SearchResult(false, page, n);
        }
        for (n = 0; n != page.m_header.m_numKeys; ++n) {
            int n2 = page.m_key[n].compareTo(keyObject);
            if (n2 == 0 || bl && n2 == 1) {
                return new SearchResult(true, page, n);
            }
            if (n2 != -1) break;
        }
        if (page.m_link[n] == -1L) {
            return new SearchResult(false, page, n);
        }
        return this.search(this.read(page.m_link[n]), keyObject, bl);
    }

    private SearchResult searchInsert(Page page, KeyObject keyObject) throws IOException, BTreeException, ClassNotFoundException {
        int n;
        int n2;
        if (page.m_header.m_numKeys == 0) {
            return new SearchResult(false, page, n2);
        }
        for (n2 = 0; n2 != page.m_header.m_numKeys && (n = page.m_key[n2].compareTo(keyObject)) == -1; ++n2) {
        }
        if (page.m_link[n2] == -1L) {
            return new SearchResult(false, page, n2);
        }
        return this.searchInsert(this.read(page.m_link[n2]), keyObject);
    }

    private void writeKey(SearchResult searchResult, KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        if (searchResult.m_page.m_header.m_numKeys == this.m_header.m_maxKeys) {
            KeyObject[] keyObjectArray = new KeyObject[this.m_header.m_maxKeys + 1];
            long[] lArray = new long[this.m_header.m_maxKeys + 1];
            keyObjectArray[searchResult.m_position] = keyObject;
            lArray[searchResult.m_position] = l;
            int n = 0;
            int n2 = 0;
            while (n2 < this.m_header.m_maxKeys) {
                if (n2 == searchResult.m_position) {
                    ++n;
                }
                keyObjectArray[n] = searchResult.m_page.m_key[n2];
                lArray[n] = searchResult.m_page.m_recPtr[n2];
                ++n2;
                ++n;
            }
            Page page = new Page(this.m_header);
            page.m_header.m_parentPtr = searchResult.m_page.m_header.m_parentPtr;
            searchResult.m_page.m_header.m_numKeys = 0;
            page.m_header.m_numKeys = 0;
            n2 = 0;
            while (n2 < this.m_header.m_minKeys) {
                searchResult.m_page.m_key[n2] = keyObjectArray[n2];
                searchResult.m_page.m_recPtr[n2] = lArray[n2];
                ++searchResult.m_page.m_header.m_numKeys;
                ++n2;
            }
            n2 = this.m_header.m_minKeys + 1;
            while (n2 <= this.m_header.m_maxKeys) {
                page.m_key[n2 - 1 - this.m_header.m_minKeys] = keyObjectArray[n2];
                page.m_recPtr[n2 - 1 - this.m_header.m_minKeys] = lArray[n2];
                ++page.m_header.m_numKeys;
                ++n2;
            }
            n2 = this.m_header.m_minKeys;
            while (n2 < this.m_header.m_maxKeys) {
                searchResult.m_page.m_key[n2] = this.m_header.m_nullKey.makeNullKey();
                searchResult.m_page.m_recPtr[n2] = -1L;
                ++n2;
            }
            this.write(searchResult.m_page, false);
            this.write(page, false);
            if (searchResult.m_page.m_header.m_parentPtr == -1L) {
                this.promoteRoot(keyObjectArray[this.m_header.m_minKeys], lArray[this.m_header.m_minKeys], searchResult.m_page, page);
            } else {
                Page page2 = this.read(searchResult.m_page.m_header.m_parentPtr);
                this.promoteInternal(page2, keyObjectArray[this.m_header.m_minKeys], lArray[this.m_header.m_minKeys], page.m_header.m_filePtr);
            }
        } else {
            int n = searchResult.m_page.m_header.m_numKeys;
            while (n > searchResult.m_position) {
                searchResult.m_page.m_key[n] = searchResult.m_page.m_key[n - 1];
                searchResult.m_page.m_recPtr[n] = searchResult.m_page.m_recPtr[n - 1];
                --n;
            }
            searchResult.m_page.m_key[searchResult.m_position] = keyObject;
            searchResult.m_page.m_recPtr[searchResult.m_position] = l;
            ++searchResult.m_page.m_header.m_numKeys;
            this.write(searchResult.m_page, false);
        }
        this.m_root = this.readRoot();
    }

    private void promoteInternal(Page page, KeyObject keyObject, long l, long l2) throws IOException, BTreeException, ClassNotFoundException {
        if (page.m_header.m_numKeys == this.m_header.m_maxKeys) {
            Page page2;
            KeyObject[] keyObjectArray = new KeyObject[this.m_header.m_maxKeys + 1];
            long[] lArray = new long[this.m_header.m_maxKeys + 1];
            long[] lArray2 = new long[this.m_header.m_order + 1];
            lArray2[0] = page.m_link[0];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < page.m_header.m_numKeys && page.m_key[n3].compareTo(keyObject) == -1) {
                ++n3;
            }
            keyObjectArray[n3] = keyObject;
            lArray[n3] = l;
            lArray2[n3 + 1] = l2;
            while (n2 < this.m_header.m_maxKeys) {
                if (n2 == n3) {
                    ++n;
                }
                keyObjectArray[n] = page.m_key[n2];
                lArray[n] = page.m_recPtr[n2];
                lArray2[n + 1] = page.m_link[n2 + 1];
                ++n2;
                ++n;
            }
            Page page3 = new Page(this.m_header);
            page3.m_header.m_parentPtr = page.m_header.m_parentPtr;
            page.m_header.m_numKeys = 0;
            page3.m_header.m_numKeys = 0;
            page.m_link[0] = lArray2[0];
            n2 = 0;
            while (n2 < this.m_header.m_minKeys) {
                page.m_key[n2] = keyObjectArray[n2];
                page.m_recPtr[n2] = lArray[n2];
                page.m_link[n2 + 1] = lArray2[n2 + 1];
                ++page.m_header.m_numKeys;
                ++n2;
            }
            page3.m_link[0] = lArray2[this.m_header.m_minKeys + 1];
            n2 = this.m_header.m_minKeys + 1;
            while (n2 <= this.m_header.m_maxKeys) {
                page3.m_key[n2 - 1 - this.m_header.m_minKeys] = keyObjectArray[n2];
                page3.m_recPtr[n2 - 1 - this.m_header.m_minKeys] = lArray[n2];
                page3.m_link[n2 - this.m_header.m_minKeys] = lArray2[n2 + 1];
                ++page3.m_header.m_numKeys;
                ++n2;
            }
            n2 = this.m_header.m_minKeys;
            while (n2 < this.m_header.m_maxKeys) {
                page.m_key[n2] = this.m_header.m_nullKey.makeNullKey();
                page.m_recPtr[n2] = -1L;
                page.m_link[n2 + 1] = -1L;
                ++n2;
            }
            this.write(page, false);
            this.write(page3, false);
            n2 = 0;
            while (n2 <= page3.m_header.m_numKeys) {
                page2 = this.read(page3.m_link[n2]);
                page2.m_header.m_parentPtr = page3.m_header.m_filePtr;
                this.write(page2, false);
                ++n2;
            }
            if (page.m_header.m_parentPtr == -1L) {
                this.promoteRoot(keyObjectArray[this.m_header.m_minKeys], lArray[this.m_header.m_minKeys], page, page3);
            } else {
                page2 = this.read(page.m_header.m_parentPtr);
                this.promoteInternal(page2, keyObjectArray[this.m_header.m_minKeys], lArray[this.m_header.m_minKeys], page3.m_header.m_filePtr);
            }
        } else {
            int n = 0;
            while (n < page.m_header.m_numKeys && page.m_key[n].compareTo(keyObject) == -1) {
                ++n;
            }
            int n4 = page.m_header.m_numKeys;
            while (n4 > n) {
                page.m_key[n4] = page.m_key[n4 - 1];
                page.m_recPtr[n4] = page.m_recPtr[n4 - 1];
                page.m_link[n4 + 1] = page.m_link[n4];
                --n4;
            }
            page.m_key[n] = keyObject;
            page.m_recPtr[n] = l;
            page.m_link[n + 1] = l2;
            ++page.m_header.m_numKeys;
            this.write(page, false);
        }
    }

    private void promoteRoot(KeyObject keyObject, long l, Page page, Page page2) throws IOException, BTreeException, ClassNotFoundException {
        Page page3 = new Page(this.m_header);
        page3.m_key[0] = keyObject;
        page3.m_recPtr[0] = l;
        page3.m_link[0] = page.m_header.m_filePtr;
        page3.m_link[1] = page2.m_header.m_filePtr;
        page3.m_header.m_numKeys = 1;
        this.write(page3, true);
        page.m_header.m_parentPtr = page3.m_header.m_filePtr;
        page2.m_header.m_parentPtr = page3.m_header.m_filePtr;
        this.write(page, false);
        this.write(page2, false);
    }

    private void adjustTree(Page page) throws IOException, BTreeException, ClassNotFoundException {
        if (page.m_header.m_parentPtr == -1L) {
            return;
        }
        Page page2 = this.read(page.m_header.m_parentPtr);
        int n = 0;
        while (page2.m_link[n] != page.m_header.m_filePtr) {
            ++n;
        }
        Page page3 = null;
        Page page4 = null;
        if (n < page2.m_header.m_numKeys) {
            page3 = this.read(page2.m_link[n + 1]);
        }
        if (n > 0) {
            page4 = this.read(page2.m_link[n - 1]);
        }
        if (page4 != null) {
            --n;
            if (page4.m_header.m_numKeys > this.m_header.m_minKeys) {
                this.redistribute(n, page4, page2, page);
            } else {
                this.concatenate(n, page4, page2, page);
            }
        } else if (page3 != null) {
            if (page3.m_header.m_numKeys > this.m_header.m_minKeys) {
                this.redistribute(n, page, page2, page3);
            } else {
                this.concatenate(n, page, page2, page3);
            }
        } else {
            throw new BTreeException("This should never happen!");
        }
    }

    private void redistribute(int n, Page page, Page page2, Page page3) throws IOException, BTreeException, ClassNotFoundException {
        if (page.m_link[0] == -1L) {
            if (page.m_header.m_numKeys > page3.m_header.m_numKeys) {
                int n2 = page3.m_header.m_numKeys;
                while (n2 > 0) {
                    page3.m_key[n2] = page3.m_key[n2 - 1];
                    page3.m_recPtr[n2] = page3.m_recPtr[n2 - 1];
                    --n2;
                }
                page3.m_key[0] = page2.m_key[n];
                page3.m_recPtr[0] = page2.m_recPtr[n];
                ++page3.m_header.m_numKeys;
                --page.m_header.m_numKeys;
                page2.m_key[n] = page.m_key[page.m_header.m_numKeys];
                page2.m_recPtr[n] = page.m_recPtr[page.m_header.m_numKeys];
                page.m_key[page.m_header.m_numKeys] = this.m_header.m_nullKey.makeNullKey();
                page.m_recPtr[page.m_header.m_numKeys] = -1L;
            } else {
                page.m_key[page.m_header.m_numKeys] = page2.m_key[n];
                page.m_recPtr[page.m_header.m_numKeys] = page2.m_recPtr[n];
                ++page.m_header.m_numKeys;
                page2.m_key[n] = page3.m_key[0];
                page2.m_recPtr[n] = page3.m_recPtr[0];
                --page3.m_header.m_numKeys;
                int n3 = 0;
                while (n3 < page3.m_header.m_numKeys) {
                    page3.m_key[n3] = page3.m_key[n3 + 1];
                    page3.m_recPtr[n3] = page3.m_recPtr[n3 + 1];
                    ++n3;
                }
                page3.m_key[n3] = this.m_header.m_nullKey.makeNullKey();
                page3.m_recPtr[n3] = -1L;
            }
        } else if (page.m_header.m_numKeys > page3.m_header.m_numKeys) {
            int n4 = page3.m_header.m_numKeys;
            while (n4 > 0) {
                page3.m_key[n4] = page3.m_key[n4 - 1];
                page3.m_recPtr[n4] = page3.m_recPtr[n4 - 1];
                page3.m_link[n4 + 1] = page3.m_link[n4];
                --n4;
            }
            page3.m_link[1] = page3.m_link[0];
            page3.m_key[0] = page2.m_key[n];
            page3.m_recPtr[0] = page2.m_recPtr[n];
            page3.m_link[0] = page.m_link[page.m_header.m_numKeys];
            Page page4 = this.read(page3.m_link[0]);
            page4.m_header.m_parentPtr = page3.m_header.m_filePtr;
            this.write(page4, false);
            ++page3.m_header.m_numKeys;
            --page.m_header.m_numKeys;
            page2.m_key[n] = page.m_key[page.m_header.m_numKeys];
            page2.m_recPtr[n] = page.m_recPtr[page.m_header.m_numKeys];
            page.m_key[page.m_header.m_numKeys] = this.m_header.m_nullKey.makeNullKey();
            page.m_recPtr[page.m_header.m_numKeys] = -1L;
            page.m_link[page.m_header.m_numKeys + 1] = -1L;
        } else {
            page.m_key[page.m_header.m_numKeys] = page2.m_key[n];
            page.m_recPtr[page.m_header.m_numKeys] = page2.m_recPtr[n];
            page.m_link[page.m_header.m_numKeys + 1] = page3.m_link[0];
            Page page5 = this.read(page3.m_link[0]);
            page5.m_header.m_parentPtr = page.m_header.m_filePtr;
            this.write(page5, false);
            ++page.m_header.m_numKeys;
            page2.m_key[n] = page3.m_key[0];
            page2.m_recPtr[n] = page3.m_recPtr[0];
            --page3.m_header.m_numKeys;
            int n5 = 0;
            while (n5 < page3.m_header.m_numKeys) {
                page3.m_key[n5] = page3.m_key[n5 + 1];
                page3.m_recPtr[n5] = page3.m_recPtr[n5 + 1];
                page3.m_link[n5] = page3.m_link[n5 + 1];
                ++n5;
            }
            page3.m_link[n5] = page3.m_link[n5 + 1];
            page3.m_key[n5] = this.m_header.m_nullKey.makeNullKey();
            page3.m_recPtr[n5] = -1L;
            page3.m_link[n5 + 1] = -1L;
        }
        this.write(page, false);
        this.write(page2, false);
        this.write(page3, false);
        if (page2.m_header.m_parentPtr == -1L) {
            this.m_root = page2;
        }
    }

    private void concatenate(int n, Page page, Page page2, Page page3) throws IOException, BTreeException, ClassNotFoundException {
        page.m_key[page.m_header.m_numKeys] = page2.m_key[n];
        page.m_recPtr[page.m_header.m_numKeys] = page2.m_recPtr[n];
        page.m_link[page.m_header.m_numKeys + 1] = page3.m_link[0];
        ++page.m_header.m_numKeys;
        --page2.m_header.m_numKeys;
        int n2 = n;
        while (n2 < page2.m_header.m_numKeys) {
            page2.m_key[n2] = page2.m_key[n2 + 1];
            page2.m_recPtr[n2] = page2.m_recPtr[n2 + 1];
            page2.m_link[n2 + 1] = page2.m_link[n2 + 2];
            ++n2;
        }
        page2.m_key[n2] = this.m_header.m_nullKey.makeNullKey();
        page2.m_recPtr[n2] = -1L;
        page2.m_link[n2 + 1] = -1L;
        int n3 = 0;
        n2 = page.m_header.m_numKeys;
        while (n3 < page3.m_header.m_numKeys) {
            ++page.m_header.m_numKeys;
            page.m_key[n2] = page3.m_key[n3];
            page.m_recPtr[n2] = page3.m_recPtr[n3];
            page.m_link[n2 + 1] = page3.m_link[n3 + 1];
            ++n3;
            ++n2;
        }
        this.delete(page3);
        if (page.m_link[0] != -1L) {
            n2 = 0;
            while (n2 <= page.m_header.m_numKeys) {
                Page page4 = this.read(page.m_link[n2]);
                page4.m_header.m_parentPtr = page.m_header.m_filePtr;
                this.write(page4, false);
                ++n2;
            }
        }
        if (page2.m_header.m_numKeys == 0) {
            this.delete(page2);
            page.m_header.m_parentPtr = -1L;
            this.write(page, true);
            this.m_root = page;
        } else {
            this.write(page2, false);
            this.write(page, false);
            if (page2.m_header.m_parentPtr == -1L) {
                this.m_root = page2;
            }
            if (page2.m_header.m_numKeys < this.m_header.m_minKeys) {
                this.adjustTree(page2);
            }
        }
    }

    public void emptyPageCache() {
        this.m_pageCache = new HashMap();
    }

    public int getPageCacheSize() {
        return this.m_pageCache.size();
    }

    public void dumpTree(PrintStream printStream) throws IOException, DuplicateKey, ClassNotFoundException {
        printStream.println("ROOT: " + this.m_root.m_header.m_filePtr);
        this.dumpTreeRecursive(this.m_root, printStream);
    }

    private void dumpTreeRecursive(Page page, PrintStream printStream) throws IOException, DuplicateKey, ClassNotFoundException {
        DecimalFormat decimalFormat = new DecimalFormat("#######0");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        printStream.println();
        printStream.println("PAGE:" + decimalFormat.format(page.m_header.m_filePtr));
        int n = 0;
        while (n < page.m_header.m_numKeys) {
            printStream.println("" + decimalFormat2.format(n) + ": " + decimalFormat.format(page.m_link[n]));
            printStream.println("     " + page.m_key[n].toString().trim());
            ++n;
        }
        printStream.println("" + decimalFormat2.format(page.m_header.m_numKeys) + ": " + decimalFormat.format(page.m_link[page.m_header.m_numKeys]));
        int n2 = 0;
        while (n2 < page.m_header.m_numKeys + 1) {
            if (page.m_link[n2] >= 0L) {
                this.dumpTreeRecursive(this.read(page.m_link[n2]), printStream);
            }
            ++n2;
        }
    }

    private class SearchResult {
        public boolean m_found;
        public Page m_page;
        public int m_position;

        public SearchResult(boolean bl, Page page, int n) {
            this.m_found = bl;
            this.m_page = page;
            this.m_position = n;
        }
    }
}

