/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;

public class InfixExpression
extends Expression {
    private Operator operator = Operator.PLUS;
    private Expression leftOperand = null;
    private Expression rightOperand = null;
    private ASTNode.NodeList extendedOperands = null;
    static /* synthetic */ Class class$0;

    InfixExpression(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 27;
    }

    ASTNode clone(AST target) {
        InfixExpression result = new InfixExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setLeftOperand((Expression)this.getLeftOperand().clone(target));
        result.setRightOperand((Expression)this.getRightOperand().clone(target));
        if (this.extendedOperands != null) {
            result.extendedOperands().addAll(ASTNode.copySubtrees(target, this.extendedOperands()));
        }
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLeftOperand());
            this.acceptChild(visitor, this.getRightOperand());
            if (this.extendedOperands != null) {
                this.acceptChildren(visitor, this.extendedOperands);
            }
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException();
        }
        this.modifying();
        this.operator = operator;
    }

    public Expression getLeftOperand() {
        if (this.leftOperand == null) {
            long count = this.getAST().modificationCount();
            this.setLeftOperand(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.leftOperand;
    }

    public void setLeftOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.leftOperand, expression, true);
        this.leftOperand = expression;
    }

    public Expression getRightOperand() {
        if (this.rightOperand == null) {
            long count = this.getAST().modificationCount();
            this.setRightOperand(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.rightOperand;
    }

    public void setRightOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.rightOperand, expression, true);
        this.rightOperand = expression;
    }

    public boolean hasExtendedOperands() {
        return this.extendedOperands != null && this.extendedOperands.size() > 0;
    }

    public List extendedOperands() {
        if (this.extendedOperands == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.Expression");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extendedOperands = new ASTNode.NodeList(true, clazz);
        }
        return this.extendedOperands;
    }

    int memSize() {
        return 52;
    }

    int treeSize() {
        return this.memSize() + (this.leftOperand == null ? 0 : this.getLeftOperand().treeSize()) + (this.rightOperand == null ? 0 : this.getRightOperand().treeSize()) + (this.extendedOperands == null ? 0 : this.extendedOperands.listSize());
    }

    public static class Operator {
        private String token;
        public static final Operator TIMES = new Operator("*");
        public static final Operator DIVIDE = new Operator("/");
        public static final Operator REMAINDER = new Operator("%");
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator LEFT_SHIFT = new Operator("<<");
        public static final Operator RIGHT_SHIFT_SIGNED = new Operator(">>");
        public static final Operator RIGHT_SHIFT_UNSIGNED = new Operator(">>>");
        public static final Operator LESS = new Operator("<");
        public static final Operator GREATER = new Operator(">");
        public static final Operator LESS_EQUALS = new Operator("<=");
        public static final Operator GREATER_EQUALS = new Operator(">=");
        public static final Operator EQUALS = new Operator("==");
        public static final Operator NOT_EQUALS = new Operator("!=");
        public static final Operator XOR = new Operator("^");
        public static final Operator OR = new Operator("|");
        public static final Operator AND = new Operator("&");
        public static final Operator CONDITIONAL_OR = new Operator("||");
        public static final Operator CONDITIONAL_AND = new Operator("&&");
        private static final Map CODES = new HashMap(20);

        static {
            Operator[] ops = new Operator[]{TIMES, DIVIDE, REMAINDER, PLUS, MINUS, LEFT_SHIFT, RIGHT_SHIFT_SIGNED, RIGHT_SHIFT_UNSIGNED, LESS, GREATER, LESS_EQUALS, GREATER_EQUALS, EQUALS, NOT_EQUALS, XOR, OR, AND, CONDITIONAL_OR, CONDITIONAL_AND};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

