/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CopyPackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.CreatePackageFragmentOperation;
import org.eclipse.jdt.internal.core.DeletePackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.MovePackageFragmentRootOperation;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.Util;

public class PackageFragmentRoot
extends Openable
implements IPackageFragmentRoot {
    protected static final char ATTACHMENT_PROPERTY_DELIMITER = '*';
    protected static final String NO_SOURCE_ATTACHMENT = "";
    protected static final SourceMapper NO_SOURCE_MAPPER = new SourceMapper();
    protected Object resource;

    protected PackageFragmentRoot(IResource resource, IJavaProject project, String name) {
        super(3, project, name);
        this.resource = resource;
    }

    public void attachSource(IPath sourcePath, IPath rootPath, IProgressMonitor monitor) throws JavaModelException {
        block20: {
            try {
                try {
                    this.verifyAttachSource(sourcePath);
                    if (monitor != null) {
                        monitor.beginTask(Util.bind("element.attachingSource"), 2);
                    }
                    SourceMapper oldMapper = this.getSourceMapper();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    boolean rootNeedsToBeClosed = false;
                    if (sourcePath == null) {
                        rootNeedsToBeClosed = true;
                        this.setSourceMapper(null);
                    } else {
                        Object target;
                        IPath storedSourcePath = this.getSourceAttachmentPath();
                        IPath storedRootPath = this.getSourceAttachmentRootPath();
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        if (!(storedSourcePath == null || storedSourcePath.equals((Object)sourcePath) && rootPath != null && rootPath.equals((Object)storedRootPath) || storedRootPath == null)) {
                            rootNeedsToBeClosed = true;
                        }
                        if ((target = JavaModel.getTarget((IContainer)workspace.getRoot(), sourcePath, false)) == null) {
                            if (monitor != null) {
                                monitor.done();
                            }
                            throw new JavaModelException(new JavaModelStatus(979, sourcePath));
                        }
                        SourceMapper mapper = this.createSourceMapper(sourcePath, rootPath);
                        if (rootPath == null && mapper.rootPath != null) {
                            rootPath = new Path(mapper.rootPath);
                        }
                        this.setSourceMapper(mapper);
                    }
                    if (sourcePath == null) {
                        this.setSourceAttachmentProperty(null);
                    } else {
                        this.setSourceAttachmentProperty(String.valueOf(sourcePath.toString()) + (rootPath == null ? NO_SOURCE_ATTACHMENT : String.valueOf('*') + rootPath.toString()));
                    }
                    if (rootNeedsToBeClosed) {
                        if (oldMapper != null) {
                            oldMapper.close();
                        }
                        BufferManager manager = BufferManager.getDefaultBufferManager();
                        Enumeration openBuffers = manager.getOpenBuffers();
                        while (openBuffers.hasMoreElements()) {
                            IBuffer buffer = (IBuffer)openBuffers.nextElement();
                            IOpenable possibleMember = buffer.getOwner();
                            if (!this.isAncestorOf((IJavaElement)((Object)possibleMember))) continue;
                            buffer.close();
                        }
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                    }
                }
                catch (JavaModelException e) {
                    this.setSourceAttachmentProperty(null);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            Object var11_14 = null;
            if (monitor == null) break block20;
            monitor.done();
        }
    }

    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) {
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? null : rootPath.toOSString(), this.isExternal() ? JavaCore.getOptions() : this.getJavaProject().getOptions(true));
        return mapper;
    }

    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws JavaModelException {
        DeletePackageFragmentRootOperation op = new DeletePackageFragmentRootOperation(this, updateResourceFlags, updateModelFlags);
        JavaElement.runOperation(op, monitor);
    }

    protected boolean computeChildren(OpenableElementInfo info) throws JavaModelException {
        try {
            IResource resource = this.getResource();
            if (resource.getType() == 2 || resource.getType() == 4) {
                ArrayList vChildren = new ArrayList(5);
                char[][] exclusionPatterns = this.fullExclusionPatternChars();
                this.computeFolderChildren((IContainer)resource, NO_SOURCE_ATTACHMENT, vChildren, exclusionPatterns);
                IJavaElement[] children = new IJavaElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (JavaModelException e) {
            info.setChildren(new IJavaElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, String prefix, ArrayList vChildren, char[][] exclusionPatterns) throws JavaModelException {
        IPackageFragment pkg = this.getPackageFragment(prefix);
        vChildren.add(pkg);
        try {
            JavaProject javaProject = (JavaProject)this.getJavaProject();
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                if (member.getType() == 2 && Util.isValidFolderNameForPackage(memberName) && !Util.isExcluded(member, exclusionPatterns) && javaProject.contains(member)) {
                    String newPrefix = prefix.length() == 0 ? memberName : String.valueOf(prefix) + "." + memberName;
                    this.computeFolderChildren((IContainer)((IFolder)member), newPrefix, vChildren, exclusionPatterns);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new JavaModelException(e, 969);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public IPath computeSourceAttachmentRootPath(IPath sourceAttachmentPath) throws JavaModelException {
        IPath sourcePath = this.getSourceAttachmentPath();
        if (sourcePath == null) {
            return null;
        }
        SourceMapper mapper = new SourceMapper(sourcePath, null, this.isExternal() ? JavaCore.getOptions() : this.getJavaProject().getOptions(true));
        if (mapper.rootPath == null) {
            return null;
        }
        return new Path(mapper.rootPath);
    }

    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IClasspathEntry sibling, IProgressMonitor monitor) throws JavaModelException {
        CopyPackageFragmentRootOperation op = new CopyPackageFragmentRootOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        JavaElement.runOperation(op, monitor);
    }

    protected OpenableElementInfo createElementInfo() {
        return new PackageFragmentRootInfo();
    }

    public IPackageFragment createPackageFragment(String name, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreatePackageFragmentOperation op = new CreatePackageFragmentOperation(this, name, force);
        JavaElement.runOperation(op, monitor);
        return this.getPackageFragment(name);
    }

    protected int determineKind(IResource underlyingResource) throws JavaModelException {
        IClasspathEntry[] entries = ((JavaProject)this.getJavaProject()).getExpandedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getPath().equals((Object)underlyingResource.getFullPath())) {
                return entry.getContentKind();
            }
            ++i;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.getJavaModel().equals(other.getJavaModel()) && this.resource.equals(other.resource) && this.fOccurrenceCount == other.fOccurrenceCount;
    }

    public boolean exists() {
        return super.exists() && this.isOnClasspath();
    }

    public IClasspathEntry findSourceAttachmentRecommendation() {
        try {
            IClasspathEntry entry;
            JavaProject parentProject;
            IWorkspaceRoot workspaceRoot;
            IPath rootPath;
            block14: {
                rootPath = this.getPath();
                workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                parentProject = (JavaProject)this.getJavaProject();
                try {
                    Object file;
                    entry = parentProject.getClasspathEntryFor(rootPath);
                    if (entry == null) break block14;
                    Object target = JavaModel.getTarget((IContainer)workspaceRoot, entry.getSourceAttachmentPath(), true);
                    if (target instanceof IFile ? Util.isArchiveFileName((file = (IFile)target).getName()) : target instanceof IFolder) {
                        return entry;
                    }
                    if (!(target instanceof File)) break block14;
                    file = (File)target;
                    if (((File)file).isFile()) {
                        if (Util.isArchiveFileName(((File)file).getName())) {
                            return entry;
                        }
                        break block14;
                    }
                    return entry;
                }
                catch (JavaModelException javaModelException) {}
            }
            IJavaModel model = this.getJavaModel();
            IJavaProject[] jProjects = model.getJavaProjects();
            int i = 0;
            int max = jProjects.length;
            while (i < max) {
                block15: {
                    JavaProject jProject = (JavaProject)jProjects[i];
                    if (jProject != parentProject) {
                        try {
                            Object file;
                            entry = jProject.getClasspathEntryFor(rootPath);
                            if (entry == null) break block15;
                            Object target = JavaModel.getTarget((IContainer)workspaceRoot, entry.getSourceAttachmentPath(), true);
                            if (target instanceof IFile ? Util.isArchiveFileName((file = (IFile)target).getName()) : target instanceof IFolder) {
                                return entry;
                            }
                            if (!(target instanceof File)) break block15;
                            file = (File)target;
                            if (((File)file).isFile()) {
                                if (Util.isArchiveFileName(((File)file).getName())) {
                                    return entry;
                                }
                                break block15;
                            }
                            return entry;
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    char[][] fullExclusionPatternChars() {
        try {
            if (this.isOpen() && this.getKind() != 1) {
                return null;
            }
            ClasspathEntry entry = (ClasspathEntry)this.getRawClasspathEntry();
            if (entry == null) {
                return null;
            }
            return entry.fullExclusionPatternChars();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        ((PackageFragmentRootInfo)info).setRootKind(this.determineKind(underlyingResource));
        return this.computeChildren(info);
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }

    public String getHandleMemento() {
        IResource resource = this.getResource();
        IPath path = resource != null ? (this.getResource().getProject().equals((Object)this.getJavaProject().getProject()) ? resource.getProjectRelativePath() : resource.getFullPath()) : this.getPath();
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(path.toString());
        return buff.toString();
    }

    public int getKind() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getRootKind();
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getNonJavaResources(this.getJavaProject(), this.getResource(), this);
    }

    public IPackageFragment getPackageFragment(String packageName) {
        if (packageName.indexOf(32) != -1) {
            char[][] compoundName = Util.toCompoundChars(packageName);
            StringBuffer buffer = new StringBuffer(packageName.length());
            int i = 0;
            int length = compoundName.length;
            while (i < length) {
                buffer.append(CharOperation.trim(compoundName[i]));
                if (i != length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
            packageName = buffer.toString();
        }
        return new PackageFragment(this, packageName);
    }

    protected String getPackageName(IFolder folder) throws JavaModelException {
        IPath myPath = this.getPath();
        IPath pkgPath = folder.getFullPath();
        int mySegmentCount = myPath.segmentCount();
        int pkgSegmentCount = pkgPath.segmentCount();
        StringBuffer name = new StringBuffer(NO_SOURCE_ATTACHMENT);
        int i = mySegmentCount;
        while (i < pkgSegmentCount) {
            if (i > mySegmentCount) {
                name.append('.');
            }
            name.append(pkgPath.segment(i));
            ++i;
        }
        return name.toString();
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IClasspathEntry getRawClasspathEntry() throws JavaModelException {
        IClasspathEntry rawEntry = null;
        IJavaProject project = this.getJavaProject();
        project.getResolvedClasspath(true);
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(project.getProject());
        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
            rawEntry = (IClasspathEntry)perProjectInfo.resolvedPathToRawEntries.get(this.getPath());
        }
        return rawEntry;
    }

    public IResource getResource() {
        return (IResource)this.resource;
    }

    public IPath getSourceAttachmentPath() throws JavaModelException {
        if (this.getKind() != 2) {
            return null;
        }
        String serverPathString = this.getSourceAttachmentProperty();
        if (serverPathString == null) {
            return null;
        }
        int index = serverPathString.lastIndexOf(42);
        if (index < 0) {
            return new Path(serverPathString);
        }
        String serverSourcePathString = serverPathString.substring(0, index);
        return new Path(serverSourcePathString);
    }

    protected String getSourceAttachmentProperty() throws JavaModelException {
        String propertyString = null;
        QualifiedName qName = this.getSourceAttachmentPropertyName();
        try {
            propertyString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
            if (propertyString == null) {
                IClasspathEntry recommendation = this.findSourceAttachmentRecommendation();
                if (recommendation != null) {
                    IPath rootPath = recommendation.getSourceAttachmentRootPath();
                    propertyString = String.valueOf(recommendation.getSourceAttachmentPath().toString()) + (rootPath == null ? NO_SOURCE_ATTACHMENT : String.valueOf('*') + rootPath.toString());
                    this.setSourceAttachmentProperty(propertyString);
                } else {
                    this.setSourceAttachmentProperty(NO_SOURCE_ATTACHMENT);
                }
            } else if (NO_SOURCE_ATTACHMENT.equals(propertyString)) {
                return null;
            }
            return propertyString;
        }
        catch (CoreException ce) {
            throw new JavaModelException(ce);
        }
    }

    protected QualifiedName getSourceAttachmentPropertyName() throws JavaModelException {
        return new QualifiedName("org.eclipse.jdt.core", "sourceattachment: " + this.getPath().toOSString());
    }

    public void setSourceAttachmentProperty(String property) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(this.getSourceAttachmentPropertyName(), property);
        }
        catch (CoreException coreException) {}
    }

    public void setSourceMapper(SourceMapper mapper) throws JavaModelException {
        ((PackageFragmentRootInfo)this.getElementInfo()).setSourceMapper(mapper);
    }

    public IPath getSourceAttachmentRootPath() throws JavaModelException {
        if (this.getKind() != 2) {
            return null;
        }
        String serverPathString = this.getSourceAttachmentProperty();
        if (serverPathString == null) {
            return null;
        }
        int index = serverPathString.lastIndexOf(42);
        if (index == -1) {
            return null;
        }
        String serverRootPathString = NO_SOURCE_ATTACHMENT;
        if (index != serverPathString.length() - 1) {
            serverRootPathString = serverPathString.substring(index + 1);
        }
        return new Path(serverRootPathString);
    }

    public SourceMapper getSourceMapper() {
        SourceMapper mapper;
        try {
            PackageFragmentRootInfo rootInfo = (PackageFragmentRootInfo)this.getElementInfo();
            mapper = rootInfo.getSourceMapper();
            if (mapper == null) {
                IPath sourcePath = this.getSourceAttachmentPath();
                if (sourcePath != null) {
                    IPath rootPath = this.getSourceAttachmentRootPath();
                    mapper = this.createSourceMapper(sourcePath, rootPath);
                    if (rootPath == null && mapper.rootPath != null) {
                        rootPath = new Path(mapper.rootPath);
                        this.setSourceAttachmentProperty(String.valueOf(sourcePath.toString()) + '*' + rootPath.toString());
                    }
                    rootInfo.setSourceMapper(mapper);
                } else {
                    rootInfo.setSourceMapper(NO_SOURCE_MAPPER);
                    mapper = null;
                }
            } else if (mapper == NO_SOURCE_MAPPER) {
                mapper = null;
            }
        }
        catch (JavaModelException javaModelException) {
            mapper = null;
        }
        return mapper;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    protected boolean isOnClasspath() {
        if (this.getElementType() == 2) {
            return true;
        }
        IPath path = this.getPath();
        try {
            IJavaProject project = this.getJavaProject();
            IClasspathEntry[] classpath = project.getResolvedClasspath(true);
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getPath().equals((Object)path)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IClasspathEntry sibling, IProgressMonitor monitor) throws JavaModelException {
        MovePackageFragmentRootOperation op = new MovePackageFragmentRootOperation(this, destination, updateResourceFlags, updateModelFlags, sibling);
        JavaElement.runOperation(op, monitor);
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        if (!this.resourceExists() || !this.isOnClasspath()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public void refreshChildren() {
        try {
            OpenableElementInfo info = (OpenableElementInfo)this.getElementInfo();
            this.computeChildren(info);
        }
        catch (JavaModelException javaModelException) {}
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new PackageFragmentRoot(this.getResource(), project, this.fName);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[project root]");
        } else {
            IPath path = this.getPath();
            if (this.getJavaProject().getElementName().equals(path.segment(0))) {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            } else {
                buffer.append(path);
            }
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void verifyAttachSource(IPath sourcePath) throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        if (this.getKind() != 2) {
            throw new JavaModelException(new JavaModelStatus(967, this));
        }
        if (sourcePath != null && !sourcePath.isAbsolute()) {
            throw new JavaModelException(new JavaModelStatus(972, sourcePath));
        }
    }
}

