/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.jdom.CompilationUnit;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;

public class SourceIndexer
extends AbstractIndexer {
    public static final String[] FILE_TYPES = new String[]{"java"};
    protected DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
    IFile resourceFile;

    SourceIndexer(IFile resourceFile) {
        this.resourceFile = resourceFile;
    }

    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    protected void indexFile(IDocument document) throws IOException {
        this.output.addDocument(document);
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this, document);
        SourceElementParser parser = new SourceElementParser(requestor, this.problemFactory, new CompilerOptions(JavaCore.create(this.resourceFile.getProject()).getOptions(true)), true);
        char[] source = null;
        char[] name = null;
        try {
            source = document.getCharContent();
            name = document.getName().toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        CompilationUnit compilationUnit = new CompilationUnit(source, name);
        try {
            parser.parseCompilationUnit(compilationUnit, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFileTypes(String[] fileTypes) {
    }
}

