/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public class TypeDeclarationPattern
extends SearchPattern {
    private char[] pkg;
    private char[][] enclosingTypeNames;
    protected char[] simpleName;
    protected char classOrInterface;
    private char[] decodedPackage;
    private char[][] decodedEnclosingTypeNames;
    protected char[] decodedSimpleName;
    protected char decodedClassOrInterface;

    public TypeDeclarationPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    public TypeDeclarationPattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, char classOrInterface, int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
        char[] cArray = this.pkg = isCaseSensitive ? pkg : CharOperation.toLowerCase(pkg);
        if (isCaseSensitive || enclosingTypeNames == null) {
            this.enclosingTypeNames = enclosingTypeNames;
        } else {
            int length = enclosingTypeNames.length;
            this.enclosingTypeNames = new char[length][];
            int i = 0;
            while (i < length) {
                this.enclosingTypeNames[i] = CharOperation.toLowerCase(enclosingTypeNames[i]);
                ++i;
            }
        }
        this.simpleName = isCaseSensitive ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.needsResolve = pkg != null && enclosingTypeNames != null;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        this.decodedClassOrInterface = word[9];
        int oldSlash = 10;
        int slash = CharOperation.indexOf('/', word, oldSlash + 1);
        this.decodedPackage = slash == oldSlash + 1 ? CharOperation.NO_CHAR : CharOperation.subarray(word, oldSlash + 1, slash);
        int n = slash + 1;
        slash = CharOperation.indexOf('/', word, slash + 1);
        this.decodedSimpleName = CharOperation.subarray(word, n, slash);
        this.decodedEnclosingTypeNames = slash + 1 < size ? (slash + 3 == size && word[slash + 1] == IIndexConstants.ONE_ZERO[0] ? IIndexConstants.ONE_ZERO_CHAR : CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size - 1))) : CharOperation.NO_CHAR_CHAR;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        boolean isClass = this.decodedClassOrInterface == 'C';
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                if (isClass) {
                    requestor.acceptClassDeclaration(path, this.decodedSimpleName, this.decodedEnclosingTypeNames, this.decodedPackage);
                } else {
                    requestor.acceptInterfaceDeclaration(path, this.decodedSimpleName, this.decodedEnclosingTypeNames, this.decodedPackage);
                }
            }
            ++i;
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestTypeDeclarationPrefix(this.pkg, this.simpleName, this.classOrInterface, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 15;
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        char[] enclosingTypeName;
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] typeName = (char[])type.getName().clone();
        CharOperation.replace(typeName, '/', '.');
        char[] cArray = enclosingTypeName = this.enclosingTypeNames == null ? null : CharOperation.concatWith(this.enclosingTypeNames, '.');
        if (!this.matchesType(this.simpleName, this.pkg, enclosingTypeName, typeName)) {
            return false;
        }
        switch (this.classOrInterface) {
            case 'C': {
                if (!type.isInterface()) break;
                return false;
            }
            case 'I': {
                if (type.isInterface()) break;
                return false;
            }
        }
        return true;
    }

    protected boolean matchesType(char[] simpleNamePattern, char[] pkgPattern, char[] enclosingNamePattern, char[] fullyQualifiedTypeName) {
        if (enclosingNamePattern == null) {
            return this.matchesType(simpleNamePattern, pkgPattern, fullyQualifiedTypeName);
        }
        char[] pattern = pkgPattern == null ? enclosingNamePattern : CharOperation.concat(pkgPattern, enclosingNamePattern, '.');
        return this.matchesType(simpleNamePattern, pattern, fullyQualifiedTypeName);
    }

    protected boolean matchIndexEntry() {
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == this.decodedClassOrInterface) break;
                return false;
            }
        }
        if (this.pkg != null && !CharOperation.equals(this.pkg, this.decodedPackage, this.isCaseSensitive)) {
            return false;
        }
        if (this.enclosingTypeNames != null && (this.enclosingTypeNames.length == 0 ? this.decodedEnclosingTypeNames != CharOperation.NO_CHAR_CHAR : !CharOperation.equals(this.enclosingTypeNames, this.decodedEnclosingTypeNames, this.isCaseSensitive))) {
            return false;
        }
        if (this.simpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.simpleName, this.decodedSimpleName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: pkg<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: pkg<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: pkg<");
            }
        }
        if (this.pkg != null) {
            buffer.append(this.pkg);
        }
        buffer.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int i = 0;
            while (i < this.enclosingTypeNames.length) {
                buffer.append(this.enclosingTypeNames[i]);
                if (i < this.enclosingTypeNames.length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        }
        buffer.append(">, ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (!(node instanceof TypeDeclaration)) {
            return 0;
        }
        TypeDeclaration type = (TypeDeclaration)node;
        if (resolve) {
            return this.matchLevel(type.binding);
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, type.name)) {
            return 0;
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding) {
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding type = (TypeBinding)binding;
        switch (this.classOrInterface) {
            case 'C': {
                if (!type.isInterface()) break;
                return 0;
            }
            case 'I': {
                if (type.isInterface()) break;
                return 0;
            }
        }
        char[] enclosingTypeName = this.enclosingTypeNames == null ? null : CharOperation.concatWith(this.enclosingTypeNames, '.');
        return this.matchLevelForType(this.simpleName, this.pkg, enclosingTypeName, type);
    }

    protected int matchLevelForType(char[] simpleNamePattern, char[] qualificationPattern, char[] enclosingNamePattern, TypeBinding type) {
        if (enclosingNamePattern == null) {
            return this.matchLevelForType(simpleNamePattern, qualificationPattern, type);
        }
        if (qualificationPattern == null) {
            return this.matchLevelForType(simpleNamePattern, enclosingNamePattern, type);
        }
        char[] fullQualificationPattern = CharOperation.concat(qualificationPattern, enclosingNamePattern, '.');
        if (CharOperation.equals(this.pkg, CharOperation.concatWith(type.getPackage().compoundName, '.'))) {
            return this.matchLevelForType(simpleNamePattern, fullQualificationPattern, type);
        }
        return 0;
    }
}

