/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class MountNode
extends AbstractProcessingNode
implements Composable {
    private VariableResolver prefix;
    private VariableResolver source;
    private Map processors = new HashMap();
    private TreeProcessor parentProcessor;
    private String language;
    private ComponentManager manager;

    public MountNode(VariableResolver prefix, VariableResolver source, String language, TreeProcessor parentProcessor) {
        this.prefix = prefix;
        this.source = source;
        this.language = language;
        this.parentProcessor = parentProcessor;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        String resolvedSource = this.source.resolve(context, objectModel);
        TreeProcessor processor = this.getProcessor(resolvedSource);
        String resolvedPrefix = this.prefix.resolve(context, objectModel);
        String oldPrefix = env.getURIPrefix();
        String oldURI = env.getURI();
        String oldContext = env.getContext();
        try {
            env.changeContext(resolvedPrefix, resolvedSource);
            if (context.isBuildingPipelineOnly()) {
                ProcessingPipeline pp = processor.buildPipeline(env);
                if (pp != null) {
                    context.setProcessingPipeline(pp);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = processor.process(env);
            return bl;
        }
        finally {
            env.setContext(oldPrefix, oldURI, oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TreeProcessor getProcessor(String source) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            Source src = resolver.resolveURI(actualSource);
            try {
                processor = this.parentProcessor.createChildProcessor(this.manager, this.language, src);
            }
            finally {
                resolver.release(src);
                this.manager.release((Component)resolver);
            }
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator iter = this.processors.values().iterator();
        while (iter.hasNext()) {
            ((TreeProcessor)iter.next()).dispose();
        }
    }
}

