/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.ResourceReader;
import org.xml.sax.SAXException;

public final class ImageReader
extends ResourceReader {
    private int width;
    private int height;
    private boolean enlarge;
    private static final String ENLARGE_DEFAULT = "true";

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.width = par.getParameterAsInteger("width", 0);
        this.height = par.getParameterAsInteger("height", 0);
        String enlargePar = par.getParameter("allow-enlarging", ENLARGE_DEFAULT);
        this.enlarge = ENLARGE_DEFAULT.equalsIgnoreCase(enlargePar) || "yes".equalsIgnoreCase(enlargePar);
    }

    private AffineTransform getTransform(double ow, double oh, double nw, double nh) {
        double wm = 1.0;
        double hm = 1.0;
        if (nw > 0.0) {
            wm = nw / ow;
            hm = nh > 0.0 ? nh / oh : wm;
        } else if (nh > 0.0) {
            wm = hm = nh / oh;
        }
        if (!this.enlarge) {
            if (nw > ow && nh <= 0.0 || oh > nh && nw <= 0.0) {
                wm = 1.0;
                hm = 1.0;
            } else if (nw > ow) {
                wm = 1.0;
            } else if (nh > oh) {
                hm = 1.0;
            }
        }
        return new AffineTransform(wm, 0.0, 0.0, hm, 0.0, 0.0);
    }

    protected void processStream() throws IOException, ProcessingException {
        if (this.width > 0 || this.height > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("image " + (this.width == 0 ? "?" : Integer.toString(this.width)) + "x" + (this.height == 0 ? "?" : Integer.toString(this.height)) + " expires: " + this.expires);
            }
            this.response.setHeader("Accept-Ranges", "none");
            try {
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)this.inputStream);
                Raster original = decoder.decodeAsRaster();
                JPEGDecodeParam decodeParam = decoder.getJPEGDecodeParam();
                double ow = decodeParam.getWidth();
                double oh = decodeParam.getHeight();
                AffineTransformOp filter = new AffineTransformOp(this.getTransform(ow, oh, this.width, this.height), 2);
                WritableRaster scaled = filter.createCompatibleDestRaster(original);
                filter.filter(original, scaled);
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bstream);
                encoder.encode((Raster)scaled);
                this.out.write(bstream.toByteArray());
                this.out.flush();
            }
            catch (ImageFormatException e) {
                throw new ProcessingException("Error reading the image. Note that only JPEG images are currently supported.");
            }
            this.inputStream.close();
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("passing original resource");
            }
            super.processStream();
        }
    }

    public Serializable getKey() {
        if (this.width > 0 || this.height > 0) {
            return this.inputSource.getURI() + ':' + this.width + ':' + this.height;
        }
        return super.getKey();
    }
}

