/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.Source;

public final class IncludeCacheValidity
implements CacheValidity {
    private List sources;
    private List timeStamps;
    private boolean isNew;
    private SourceResolver resolver;

    public IncludeCacheValidity(SourceResolver resolver) {
        this.resolver = resolver;
        this.sources = new ArrayList();
        this.timeStamps = new ArrayList();
        this.isNew = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew2False() {
        this.isNew = false;
        this.resolver = null;
    }

    public void add(String source, long timeStamp) {
        this.sources.add(source);
        this.timeStamps.add(new Long(timeStamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(CacheValidity validity) {
        if (validity instanceof IncludeCacheValidity) {
            SourceResolver otherResolver = ((IncludeCacheValidity)validity).resolver;
            Iterator i = this.sources.iterator();
            Iterator j = this.timeStamps.iterator();
            while (i.hasNext()) {
                String src = (String)i.next();
                long timeStamp = (Long)j.next();
                Source otherSource = null;
                try {
                    otherSource = otherResolver.resolveURI(src);
                    if (otherSource.getLastModified() == timeStamp && timeStamp != 0L) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    otherResolver.release(otherSource);
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Include Validity[");
        Iterator i = this.sources.iterator();
        Iterator j = this.timeStamps.iterator();
        while (i.hasNext()) {
            b.append('{');
            b.append(i.next());
            b.append(':');
            b.append(j.next());
            b.append('}');
            if (!i.hasNext()) continue;
            b.append(':');
        }
        b.append(']');
        return b.toString();
    }
}

