/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationReader;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.fonts.BFEntry;
import org.apache.fop.render.pdf.fonts.MultiByteFont;
import org.apache.fop.render.pdf.fonts.SingleByteFont;
import org.apache.fop.tools.URLBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FontReader
extends DefaultHandler {
    private Locator locator = null;
    private boolean isCID = false;
    private MultiByteFont multiFont = null;
    private SingleByteFont singleFont = null;
    private Font returnFont = null;
    private String text = null;
    private List cidWidths = null;
    private int cidWidthIndex = 0;
    private Map currentKerning = null;
    private List bfranges = null;

    private void createFont(URL url) throws FOPException {
        XMLReader parser = ConfigurationReader.createParser();
        if (parser == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException e) {
            throw new FOPException("You need a SAX parser which supports SAX version 2", e);
        }
        parser.setContentHandler(this);
        try {
            parser.parse(new InputSource(url.openStream()));
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public void setFontEmbedPath(URL path) {
        if (this.isCID) {
            this.multiFont.embedFileName = path;
        } else {
            this.singleFont.embedFileName = path;
        }
    }

    public void useKerning(boolean kern) {
        if (this.isCID) {
            this.multiFont.useKerning = true;
        } else {
            this.singleFont.useKerning = true;
        }
    }

    public Font getFont() {
        return this.returnFont;
    }

    public FontReader(URL path) throws FOPException {
        this.createFont(path);
    }

    public void startDocument() {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("font-metrics")) {
            if ("TYPE0".equals(attributes.getValue("type"))) {
                this.multiFont = new MultiByteFont();
                this.returnFont = this.multiFont;
                this.isCID = true;
            } else if ("TRUETYPE".equals(attributes.getValue("type"))) {
                this.singleFont = new SingleByteFont();
                this.singleFont.subType = (byte)4;
                this.returnFont = this.singleFont;
                this.isCID = false;
            } else {
                this.singleFont = new SingleByteFont();
                this.singleFont.subType = 1;
                this.returnFont = this.singleFont;
                this.isCID = false;
            }
        } else if ("embed".equals(localName)) {
            if (this.isCID) {
                String filename = attributes.getValue("file");
                if (filename != null) {
                    try {
                        this.multiFont.embedFileName = URLBuilder.buildURL(Configuration.getFontBaseURL(), filename);
                    }
                    catch (MalformedURLException mfue) {
                        throw new SAXException(mfue);
                    }
                }
                this.multiFont.embedResourceName = attributes.getValue("class");
            } else {
                String filename = attributes.getValue("file");
                if (filename != null) {
                    try {
                        this.singleFont.embedFileName = URLBuilder.buildURL(Configuration.getFontBaseURL(), filename);
                    }
                    catch (MalformedURLException mfue) {
                        throw new SAXException(mfue);
                    }
                }
                this.singleFont.embedResourceName = attributes.getValue("class");
            }
        } else if ("cid-widths".equals(localName)) {
            this.cidWidthIndex = this.getInt(attributes.getValue("start-index"));
            this.cidWidths = new ArrayList();
        } else if ("kerning".equals(localName)) {
            this.currentKerning = new HashMap();
            if (this.isCID) {
                this.multiFont.kerning.put(new Integer(attributes.getValue("kpx1")), this.currentKerning);
            } else {
                this.singleFont.kerning.put(new Integer(attributes.getValue("kpx1")), this.currentKerning);
            }
        } else if ("bfranges".equals(localName)) {
            this.bfranges = new ArrayList();
        } else if ("bf".equals(localName)) {
            BFEntry entry = new BFEntry();
            entry.unicodeStart = this.getInt(attributes.getValue("us"));
            entry.unicodeEnd = this.getInt(attributes.getValue("ue"));
            entry.glyphStartIndex = this.getInt(attributes.getValue("gi"));
            this.bfranges.add(entry);
        } else if ("wx".equals(localName)) {
            this.cidWidths.add(new Integer(attributes.getValue("w")));
        } else if ("widths".equals(localName)) {
            this.singleFont.width = new int[256];
        } else if ("char".equals(localName)) {
            try {
                this.singleFont.width[Integer.parseInt((String)attributes.getValue((String)"idx"))] = Integer.parseInt(attributes.getValue("wdt"));
            }
            catch (NumberFormatException ne) {
                System.out.println("Malformed width in metric file: " + ne.getMessage());
            }
        } else if ("pair".equals(localName)) {
            this.currentKerning.put(new Integer(attributes.getValue("kpx2")), new Integer(attributes.getValue("kern")));
        }
    }

    private int getInt(String str) {
        int ret = 0;
        try {
            ret = Integer.parseInt(str);
        }
        catch (Exception e) {}
        return ret;
    }

    public void endElement(String uri, String localName, String qName) {
        if ("font-name".equals(localName)) {
            if (this.isCID) {
                this.multiFont.fontName = this.text;
            } else {
                this.singleFont.fontName = this.text;
            }
        }
        if ("ttc-name".equals(localName) && this.isCID) {
            this.multiFont.ttcName = this.text;
        } else if ("cap-height".equals(localName)) {
            if (this.isCID) {
                this.multiFont.capHeight = this.getInt(this.text);
            } else {
                this.singleFont.capHeight = this.getInt(this.text);
            }
        } else if ("x-height".equals(localName)) {
            if (this.isCID) {
                this.multiFont.xHeight = this.getInt(this.text);
            } else {
                this.singleFont.xHeight = this.getInt(this.text);
            }
        } else if ("ascender".equals(localName)) {
            if (this.isCID) {
                this.multiFont.ascender = this.getInt(this.text);
            } else {
                this.singleFont.ascender = this.getInt(this.text);
            }
        } else if ("descender".equals(localName)) {
            if (this.isCID) {
                this.multiFont.descender = this.getInt(this.text);
            } else {
                this.singleFont.descender = this.getInt(this.text);
            }
        } else if ("left".equals(localName)) {
            if (this.isCID) {
                this.multiFont.fontBBox[0] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[0] = this.getInt(this.text);
            }
        } else if ("bottom".equals(localName)) {
            if (this.isCID) {
                this.multiFont.fontBBox[1] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[1] = this.getInt(this.text);
            }
        } else if ("right".equals(localName)) {
            if (this.isCID) {
                this.multiFont.fontBBox[2] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[2] = this.getInt(this.text);
            }
        } else if ("first-char".equals(localName)) {
            this.singleFont.firstChar = this.getInt(this.text);
        } else if ("last-char".equals(localName)) {
            this.singleFont.lastChar = this.getInt(this.text);
        } else if ("top".equals(localName)) {
            if (this.isCID) {
                this.multiFont.fontBBox[3] = this.getInt(this.text);
            } else {
                this.singleFont.fontBBox[3] = this.getInt(this.text);
            }
        } else if ("flags".equals(localName)) {
            if (this.isCID) {
                this.multiFont.flags = this.getInt(this.text);
            } else {
                this.singleFont.flags = this.getInt(this.text);
            }
        } else if ("stemv".equals(localName)) {
            if (this.isCID) {
                this.multiFont.stemV = this.getInt(this.text);
            } else {
                this.singleFont.stemV = this.getInt(this.text);
            }
        } else if ("italic-angle".equals(localName)) {
            if (this.isCID) {
                this.multiFont.italicAngle = this.getInt(this.text);
            } else {
                this.singleFont.italicAngle = this.getInt(this.text);
            }
        } else if ("missing-width".equals(localName)) {
            if (this.isCID) {
                this.multiFont.missingWidth = this.getInt(this.text);
            } else {
                this.singleFont.missingWidth = this.getInt(this.text);
            }
        } else if ("cid-type".equals(localName)) {
            if ("CIDFontType2".equals(this.text)) {
                this.multiFont.cidType = 1;
            }
        } else if ("default-width".equals(localName)) {
            this.multiFont.defaultWidth = this.getInt(this.text);
        } else if ("cid-widths".equals(localName)) {
            int[] wds = new int[this.cidWidths.size()];
            int i = 0;
            while (i < this.cidWidths.size()) {
                wds[i] = (Integer)this.cidWidths.get(i);
                ++i;
            }
            this.multiFont.warray.addEntry(this.cidWidthIndex, wds);
            this.multiFont.width = wds;
        } else if ("bfranges".equals(localName)) {
            BFEntry[] entries = new BFEntry[this.bfranges.size()];
            entries = this.bfranges.toArray(entries);
            this.multiFont.bfentries = entries;
        }
    }

    public void characters(char[] ch, int start, int length) {
        char[] c = new char[length];
        System.arraycopy(ch, start, c, 0, length);
        this.text = new String(c);
    }
}

