/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.gui;

import java.util.Hashtable;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.decor.BackgroundFactory;
import org.linphone.core.LinphoneAuthInfo;
import org.linphone.core.LinphoneCore;
import org.linphone.core.LinphoneCoreException;
import org.linphone.core.LinphoneCoreFactory;
import org.linphone.core.LinphoneProxyConfig;
import org.linphone.jlinphone.gui.LinphoneConfigException;
import org.linphone.jlinphone.gui.LinphoneResource;
import org.linphone.jlinphone.gui.Settings;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;

public class SettingsScreen
extends MainScreen
implements Settings,
LinphoneResource {
    private PersistentObject mPersistentObject;
    private Hashtable mSettingsMap;
    private final LinphoneCore mCore;
    private Logger sLogger = JOrtpFactory.instance().createLogger("Linphone");
    SettingsFieldContent mSettingsFields;
    private static ResourceBundle mRes = ResourceBundle.getBundle((long)-8981235513634632902L, (String)"org.linphone.jlinphone.gui.Linphone");

    SettingsScreen(LinphoneCore lc) {
        this.mCore = lc;
        this.mPersistentObject = PersistentStore.getPersistentObject((long)"org.jlinphone.settings".hashCode());
        this.mSettingsMap = this.mPersistentObject.getContents() != null ? (Hashtable)this.mPersistentObject.getContents() : new Hashtable();
        this.setTitle("Linphone " + mRes.getString(1));
        ((VerticalFieldManager)this.getMainManager()).setBackground(BackgroundFactory.createSolidBackground((int)0xD3D3D3));
        this.mSettingsFields = new SettingsFieldContent();
        this.add(this.mSettingsFields.getRootField());
        try {
            this.initFromConf();
        }
        catch (LinphoneConfigException e) {
            this.sLogger.warn("no configuration ready yet", e);
        }
    }

    protected boolean onSave() {
        this.mSettingsFields.save();
        return true;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean value;
        boolean lResult = defaultValue;
        if (this.mSettingsMap != null && (value = (Boolean)this.mSettingsMap.get(key)) != null) {
            return value;
        }
        return lResult;
    }

    public String getString(String key, String defaultValue) {
        String value;
        String lResult = defaultValue;
        if (this.mSettingsMap != null && (value = (String)this.mSettingsMap.get(key)) != null) {
            return value;
        }
        return lResult;
    }

    public void initFromConf() throws LinphoneConfigException {
        boolean lIsDebug = this.getBoolean("org.jlinphone.settings.advanced.debug", false);
        LinphoneCoreFactory.instance().setDebugMode(lIsDebug);
        String lUserName = this.getString("org.jlinphone.settings.sip.username", null);
        if (lUserName == null || lUserName.length() == 0) {
            throw new LinphoneConfigException(mRes.getString(16));
        }
        String lPasswd = this.getString("org.jlinphone.settings.sip.password", null);
        if (lPasswd == null || lPasswd.length() == 0) {
            throw new LinphoneConfigException(mRes.getString(17));
        }
        String lDomain = this.getString("org.jlinphone.settings.sip.domain", null);
        if (lDomain == null || lDomain.length() == 0) {
            throw new LinphoneConfigException(mRes.getString(10));
        }
        String lTransport = this.getString("org.jlinphone.settings.sip.transport", null);
        if (lTransport != null && "tcp".equalsIgnoreCase(lTransport)) {
            this.mCore.setSignalingTransport(LinphoneCore.Transport.tcp);
        } else {
            this.mCore.setSignalingTransport(LinphoneCore.Transport.udp);
        }
        this.mCore.clearAuthInfos();
        LinphoneAuthInfo lAuthInfo = LinphoneCoreFactory.instance().createAuthInfo(lUserName, lPasswd, null);
        this.mCore.addAuthInfo(lAuthInfo);
        String lProxy = this.getString("org.jlinphone.settings.sip.proxy", null);
        if (lProxy == null || lProxy.length() == 0) {
            lProxy = "sip:" + lDomain;
        } else if (!lProxy.startsWith("sip:")) {
            lProxy = "sip:" + lProxy;
        }
        LinphoneProxyConfig lDefaultProxyConfig = this.mCore.getDefaultProxyConfig();
        String lIdentity = "sip:" + lUserName + "@" + lDomain;
        try {
            if (lDefaultProxyConfig == null) {
                lDefaultProxyConfig = LinphoneCoreFactory.instance().createProxyConfig(lIdentity, lProxy, null, true);
                this.mCore.addProxyConfig(lDefaultProxyConfig);
                this.mCore.setDefaultProxyConfig(lDefaultProxyConfig);
            } else {
                lDefaultProxyConfig.edit();
                lDefaultProxyConfig.setIdentity(lIdentity);
                lDefaultProxyConfig.setProxy(lProxy);
                lDefaultProxyConfig.enableRegister(true);
                lDefaultProxyConfig.done();
            }
            lDefaultProxyConfig = this.mCore.getDefaultProxyConfig();
            lDefaultProxyConfig.setDialEscapePlus(this.getBoolean("org.jlinphone.settings.advanced.zerotoplus", false));
        }
        catch (LinphoneCoreException e) {
            throw new LinphoneConfigException(mRes.getString(19), e);
        }
    }

    public SettingsFieldContent createSettingsFields() {
        return new SettingsFieldContent();
    }

    class SettingsFieldContent {
        private BasicEditField mUserNameField;
        private BasicEditField mUserPasswd;
        private BasicEditField mDomain;
        private BasicEditField mProxy;
        public final String[] SIP_TRANSPORT_TYPE = new String[]{"udp", "tcp"};
        private CheckboxField mDebugMode;
        private CheckboxField mSubstituteZero2Plus;
        private ObjectChoiceField mTransPort;
        VerticalFieldManager mMainFiedManager = new VerticalFieldManager();

        public SettingsFieldContent() {
            VerticalFieldManager lSipAccount = new VerticalFieldManager();
            this.mMainFiedManager.add((Field)lSipAccount);
            LabelField lSipAccountLabelField = new LabelField((Object)mRes.getString(7));
            lSipAccountLabelField.setFont(Font.getDefault().derive(5));
            lSipAccount.add((Field)lSipAccountLabelField);
            this.mUserNameField = new BasicEditField(mRes.getString(8), "", 128, 0L);
            this.mUserNameField.setText(SettingsScreen.this.getString("org.jlinphone.settings.sip.username", ""));
            lSipAccount.add((Field)this.mUserNameField);
            this.mUserPasswd = new BasicEditField(mRes.getString(9), "", 128, 0L);
            this.mUserPasswd.setText(SettingsScreen.this.getString("org.jlinphone.settings.sip.password", ""));
            lSipAccount.add((Field)this.mUserPasswd);
            this.mDomain = new BasicEditField(mRes.getString(10), "", 128, 0L);
            this.mDomain.setText(SettingsScreen.this.getString("org.jlinphone.settings.sip.domain", ""));
            lSipAccount.add((Field)this.mDomain);
            this.mProxy = new BasicEditField(mRes.getString(11), "", 128, 0L);
            this.mProxy.setText(SettingsScreen.this.getString("org.jlinphone.settings.sip.proxy", ""));
            lSipAccount.add((Field)this.mProxy);
            SeparatorField lSipAccountSeparator = new SeparatorField();
            this.mMainFiedManager.add((Field)lSipAccountSeparator);
            VerticalFieldManager lAdvanced = new VerticalFieldManager();
            this.mMainFiedManager.add((Field)lAdvanced);
            LabelField lAvancedLabelField = new LabelField((Object)mRes.getString(12));
            lAvancedLabelField.setFont(Font.getDefault().derive(5));
            lAdvanced.add((Field)lAvancedLabelField);
            this.mTransPort = new ObjectChoiceField(mRes.getString(13), (Object[])this.SIP_TRANSPORT_TYPE, this.SIP_TRANSPORT_TYPE[0].equals(SettingsScreen.this.getString("org.jlinphone.settings.sip.transport", this.SIP_TRANSPORT_TYPE[0])) ? 0 : 1);
            lAdvanced.add((Field)this.mTransPort);
            this.mDebugMode = new CheckboxField(mRes.getString(14), false);
            this.mDebugMode.setChecked(SettingsScreen.this.getBoolean("org.jlinphone.settings.advanced.debug", false));
            lAdvanced.add((Field)this.mDebugMode);
            this.mSubstituteZero2Plus = new CheckboxField(mRes.getString(15), false);
            this.mSubstituteZero2Plus.setChecked(SettingsScreen.this.getBoolean("org.jlinphone.settings.advanced.zerotoplus", false));
            lAdvanced.add((Field)this.mSubstituteZero2Plus);
        }

        public void save() {
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.sip.username", this.mUserNameField.getText());
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.sip.password", this.mUserPasswd.getText());
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.sip.domain", this.mDomain.getText());
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.sip.proxy", this.mProxy.getText());
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.sip.transport", this.SIP_TRANSPORT_TYPE[this.mTransPort.getSelectedIndex()]);
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.advanced.debug", new Boolean(this.mDebugMode.getChecked()));
            SettingsScreen.this.mSettingsMap.put("org.jlinphone.settings.advanced.zerotoplus", new Boolean(this.mSubstituteZero2Plus.getChecked()));
            try {
                SettingsScreen.this.initFromConf();
                SettingsScreen.this.mPersistentObject.setContents((Object)SettingsScreen.this.mSettingsMap);
                SettingsScreen.this.mPersistentObject.commit();
            }
            catch (LinphoneConfigException e) {
                SettingsScreen.this.sLogger.error("Configuration error", e);
                UiApplication.getUiApplication().invokeLater(new Runnable(this, e){
                    final /* synthetic */ SettingsFieldContent this$1;
                    private final /* synthetic */ LinphoneConfigException val$e;
                    {
                        this.this$1 = settingsFieldContent;
                        this.val$e = linphoneConfigException;
                    }

                    public void run() {
                        Dialog.alert((String)this.val$e.getMessage());
                    }
                });
            }
        }

        public Field getRootField() {
            return this.mMainFiedManager;
        }
    }
}

