/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core.net;

import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.DatagramConnection;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;
import net.rim.device.api.system.WLANInfo;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.net.NetworkLayer;
import sip4me.gov.nist.core.net.SocketException;

public class BBNetworkLayer
implements NetworkLayer {
    public static String connectionParameter = ";deviceside=true";

    static String getConnectionParams() {
        if (WLANInfo.getWLANState() == 4620) {
            return String.valueOf(connectionParameter) + ";interface=wifi";
        }
        return connectionParameter;
    }

    public ServerSocketConnection createServerSocket(int port) throws SocketException {
        String location = "socket://:" + port;
        try {
            return (ServerSocketConnection)Connector.open((String)(String.valueOf(location) + BBNetworkLayer.getConnectionParams()));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public SocketConnection createSocket(String targetAddress, int targetPort) throws SocketException {
        String location = "socket://" + targetAddress + ":" + targetPort;
        try {
            return (SocketConnection)Connector.open((String)(String.valueOf(location) + BBNetworkLayer.getConnectionParams()));
        }
        catch (Throwable e) {
            throw new SocketException(e.getMessage());
        }
    }

    public DatagramConnection createDatagramSocket(String targetAddress, int targetPort) throws SocketException {
        String location = "datagram://" + targetAddress + ":" + targetPort;
        try {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "WARNING! UDP Connection will be opened with " + BBNetworkLayer.getConnectionParams() + " parameter. This will likely fail");
            }
            return (DatagramConnection)Connector.open((String)(String.valueOf(location) + BBNetworkLayer.getConnectionParams()));
        }
        catch (ConnectionNotFoundException cnfe) {
            throw new SocketException(cnfe.getMessage());
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            try {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(16, "WARNING! Retrying UDP Connection without " + BBNetworkLayer.getConnectionParams() + " parameter. " + "This may succeed but give no real connectivity with target");
                }
                return (DatagramConnection)Connector.open((String)location);
            }
            catch (IOException ioe) {
                throw new SocketException(ioe.getMessage());
            }
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public DatagramConnection createDatagramInboundSocket(int targetPort) throws SocketException {
        String location = "datagram://:" + targetPort + BBNetworkLayer.getConnectionParams();
        try {
            return (DatagramConnection)Connector.open((String)location);
        }
        catch (ConnectionNotFoundException cnfe) {
            cnfe.printStackTrace();
            try {
                return (DatagramConnection)Connector.open((String)location);
            }
            catch (IOException ioe) {
                throw new SocketException(ioe.getMessage());
            }
        }
        catch (SecurityException se) {
            throw new SocketException(se.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new SocketException(iae.getMessage());
        }
        catch (IOException ioe) {
            throw new SocketException(ioe.getMessage());
        }
    }

    public String getDNSresolution(String domainOrIP) {
        return domainOrIP;
    }
}

