/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import sip4me.gov.nist.core.NameValue;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;

public class AttributeField
extends SDPField {
    protected NameValue attribute;

    public Object clone() {
        AttributeField retval = new AttributeField();
        if (this.attribute != null) {
            retval.attribute = (NameValue)this.attribute.clone();
        }
        return retval;
    }

    public NameValue getAttribute() {
        return this.attribute;
    }

    public AttributeField() {
        super("a=");
    }

    public void setAttribute(NameValue a) {
        this.attribute = a;
        this.attribute.setSeparator(":");
    }

    public String encode() {
        String encoded_string = "a=";
        if (this.attribute != null) {
            encoded_string = String.valueOf(encoded_string) + this.attribute.encode();
        }
        return String.valueOf(encoded_string) + "\r\n";
    }

    public String toString() {
        return this.encode();
    }

    public String getName() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        String name = nameValue.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    public void setName(String name) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setName(name);
        this.setAttribute(nameValue);
    }

    public boolean hasValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return false;
        }
        Object value = nameValue.getValue();
        return value != null;
    }

    public String getValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        Object value = nameValue.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public void setValue(String value) {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValue(value);
        this.setAttribute(nameValue);
    }
}

