/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.message;

import java.util.Vector;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.siplite.address.URI;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.ContentTypeHeader;
import sip4me.gov.nist.siplite.header.FromHeader;
import sip4me.gov.nist.siplite.header.MaxForwardsHeader;
import sip4me.gov.nist.siplite.header.StatusLine;
import sip4me.gov.nist.siplite.header.ToHeader;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.parser.StringMsgParser;

public class MessageFactory {
    private static String defaultContentEncodingCharset = "UTF-8";

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("Null parameters");
        }
        Request sipRequest = new Request();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setHeader(cSeq);
        sipRequest.setHeader(from);
        sipRequest.setHeader(to);
        sipRequest.setVia(via);
        sipRequest.setHeader(maxForwards);
        sipRequest.setContent(content, contentType);
        return sipRequest;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, byte[] content, ContentTypeHeader contentType) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        Request sipRequest = new Request();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setHeader(cSeq);
        sipRequest.setHeader(from);
        sipRequest.setHeader(to);
        sipRequest.setVia(via);
        sipRequest.setHeader(maxForwards);
        sipRequest.setHeader(contentType);
        sipRequest.setMessageContent(content);
        return sipRequest;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the request", 0);
        }
        Request sipRequest = new Request();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setHeader(cSeq);
        sipRequest.setHeader(from);
        sipRequest.setHeader(to);
        sipRequest.setVia(via);
        sipRequest.setHeader(maxForwards);
        return sipRequest;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, Object content, ContentTypeHeader contentType) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException(" unable to create the response");
        }
        Response sipResponse = new Response();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reasonPhrase = Response.getReasonPhrase(statusCode);
        if (reasonPhrase == null) {
            throw new ParseException(String.valueOf(statusCode) + " Unkown  ", 0);
        }
        statusLine.setReasonPhrase(reasonPhrase);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setHeader(cSeq);
        sipResponse.setHeader(from);
        sipResponse.setHeader(to);
        sipResponse.setVia(via);
        sipResponse.setHeader(maxForwards);
        sipResponse.setContent(content, contentType);
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, byte[] content, ContentTypeHeader contentType) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("Null params ");
        }
        Response sipResponse = new Response();
        sipResponse.setStatusCode(statusCode);
        sipResponse.setCallId(callId);
        sipResponse.setHeader(cSeq);
        sipResponse.setHeader(from);
        sipResponse.setHeader(to);
        sipResponse.setVia(via);
        sipResponse.setHeader(maxForwards);
        sipResponse.setHeader(contentType);
        sipResponse.setMessageContent(content);
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null) {
            throw new ParseException("JAIN-SIP Exception, some parameters are missing, unable to create the response", 0);
        }
        Response sipResponse = new Response();
        sipResponse.setStatusCode(statusCode);
        sipResponse.setCallId(callId);
        sipResponse.setHeader(cSeq);
        sipResponse.setHeader(from);
        sipResponse.setHeader(to);
        sipResponse.setVia(via);
        sipResponse.setHeader(maxForwards);
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, Object content) throws ParseException {
        if (request == null || content == null || contentType == null) {
            throw new NullPointerException("null parameters");
        }
        Request sipRequest = request;
        Response sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.setContent(content, contentType);
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (request == null || content == null || contentType == null) {
            throw new NullPointerException("null Parameters");
        }
        Request sipRequest = request;
        Response sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.setHeader(contentType);
        sipResponse.setMessageContent(content);
        return sipResponse;
    }

    public Response createResponse(int statusCode, Request request) throws ParseException {
        if (request == null) {
            throw new NullPointerException("null parameters");
        }
        Request sipRequest = request;
        Response sipResponse = sipRequest.createResponse(statusCode);
        sipResponse.removeContent();
        sipResponse.removeHeader("Content-Type");
        return sipResponse;
    }

    public Request createRequest(URI requestURI, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (requestURI == null || method == null || callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        Request sipRequest = new Request();
        sipRequest.setRequestURI(requestURI);
        sipRequest.setMethod(method);
        sipRequest.setCallId(callId);
        sipRequest.setHeader(cSeq);
        sipRequest.setHeader(from);
        sipRequest.setHeader(to);
        sipRequest.setVia(via);
        sipRequest.setHeader(maxForwards);
        sipRequest.setContent(content, contentType);
        return sipRequest;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, Object content) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        Response sipResponse = new Response();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reason = Response.getReasonPhrase(statusCode);
        if (reason == null) {
            throw new ParseException(String.valueOf(statusCode) + " Unknown", 0);
        }
        statusLine.setReasonPhrase(reason);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setHeader(cSeq);
        sipResponse.setHeader(from);
        sipResponse.setHeader(to);
        sipResponse.setVia(via);
        sipResponse.setContent(content, contentType);
        return sipResponse;
    }

    public Response createResponse(int statusCode, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, Vector via, MaxForwardsHeader maxForwards, ContentTypeHeader contentType, byte[] content) throws ParseException {
        if (callId == null || cSeq == null || from == null || to == null || via == null || maxForwards == null || content == null || contentType == null) {
            throw new NullPointerException("missing parameters");
        }
        Response sipResponse = new Response();
        StatusLine statusLine = new StatusLine();
        statusLine.setStatusCode(statusCode);
        String reason = Response.getReasonPhrase(statusCode);
        if (reason == null) {
            throw new ParseException(String.valueOf(statusCode) + " : Unknown", 0);
        }
        statusLine.setReasonPhrase(reason);
        sipResponse.setStatusLine(statusLine);
        sipResponse.setCallId(callId);
        sipResponse.setHeader(cSeq);
        sipResponse.setHeader(from);
        sipResponse.setHeader(to);
        sipResponse.setVia(via);
        sipResponse.setContent(content, contentType);
        return sipResponse;
    }

    public Request createRequest(String requestString) throws ParseException {
        StringMsgParser smp = new StringMsgParser();
        Message sipMessage = smp.parseSIPMessage(requestString);
        if (!(sipMessage instanceof Request)) {
            throw new ParseException(requestString, 0);
        }
        return (Request)sipMessage;
    }

    public static String getDefaultContentEncodingCharset() {
        return defaultContentEncodingCharset;
    }
}

