/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack.authentication;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.AuthenticationHelper;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.header.AuthorizationHeader;
import sip4me.gov.nist.siplite.header.CSeqHeader;
import sip4me.gov.nist.siplite.header.ProxyAuthenticateHeader;
import sip4me.gov.nist.siplite.header.ProxyAuthorizationHeader;
import sip4me.gov.nist.siplite.header.WWWAuthenticateHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.authentication.Credentials;

public class DigestClientAuthentication
implements AuthenticationHelper {
    private String realm;
    private String uri;
    private String nonce;
    private String method;
    private String algorithm;
    private String qop;
    private String opaque;
    private int requestCounter;
    private Random nonceGenerator;
    private String cnonce;
    private Vector credentials;
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestClientAuthentication(Vector credentials) {
        this.credentials = credentials;
        this.requestCounter = 1;
        this.nonceGenerator = new Random(System.currentTimeMillis());
    }

    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("bad scheme arg");
        }
        ProxyAuthorizationHeader p = new ProxyAuthorizationHeader();
        p.setScheme(scheme);
        return p;
    }

    public AuthorizationHeader createAuthorizationHeader(String scheme) throws ParseException {
        if (scheme == null) {
            throw new NullPointerException("null arg scheme ");
        }
        AuthorizationHeader auth = new AuthorizationHeader();
        auth.setScheme(scheme);
        return auth;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        int i = 0;
        while (i < b.length) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
            ++i;
        }
        return new String(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Request createNewRequest(SipStack sipStack, Request originalRequest, Response response) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Creating new authenticated request with credentials");
        }
        try {
            Request newRequest = (Request)originalRequest.clone();
            CSeqHeader cseqHeader = newRequest.getCSeqHeader();
            cseqHeader.setSequenceNumber(cseqHeader.getSequenceNumber() + 1);
            newRequest.getFromHeader().setTag(Utils.generateTag());
            ProxyAuthenticateHeader proxyAuthHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate");
            WWWAuthenticateHeader wwwAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
            cseqHeader = response.getCSeqHeader();
            this.method = cseqHeader.getMethod();
            this.uri = originalRequest.getRequestURI().encode();
            if (proxyAuthHeader == null) {
                if (wwwAuthenticateHeader == null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("DigestClientAuthentication,  ERROR: No ProxyAuthenticate header or WWWAuthenticateHeader in the response!");
                    }
                    return null;
                }
                this.algorithm = wwwAuthenticateHeader.getAlgorithm();
                if (this.algorithm == null) {
                    this.algorithm = "MD5";
                }
                this.nonce = wwwAuthenticateHeader.getNonce();
                this.realm = wwwAuthenticateHeader.getRealm();
                if (this.realm == null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("DigestClientAuthentication, ERROR: 'realm' not found on the 401 response!");
                    }
                    return null;
                }
                this.opaque = wwwAuthenticateHeader.getOpaque();
                this.qop = wwwAuthenticateHeader.getParameter("qop");
            } else {
                this.algorithm = proxyAuthHeader.getAlgorithm();
                if (this.algorithm == null) {
                    this.algorithm = "MD5";
                }
                this.nonce = proxyAuthHeader.getNonce();
                this.realm = proxyAuthHeader.getRealm();
                if (this.realm == null) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("DigestClientAuthentication, ERROR: 'realm' not found on the 407 response!");
                    }
                    return null;
                }
                this.opaque = proxyAuthHeader.getOpaque();
                this.qop = proxyAuthHeader.getParameter("qop");
            }
            Credentials credentials = this.getCredentials(this.realm);
            if (credentials == null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("DigestClientAuthentication,  ERROR: Credentials not properly set for Digest authentication!");
                }
                return null;
            }
            if (proxyAuthHeader == null) {
                AuthorizationHeader header = this.createAuthorizationHeader("Digest");
                header.setParameter("username", credentials.getUserName());
                header.setParameter("realm", this.realm);
                header.setParameter("uri", this.uri);
                header.setParameter("algorithm", this.algorithm);
                if (this.opaque != null) {
                    header.setParameter("opaque", this.opaque);
                }
                header.setParameter("nonce", this.nonce);
                if (this.qop != null) {
                    this.cnonce = String.valueOf(Utils.toHexString(this.nonceGenerator.nextDouble())) + Utils.toHexString(this.nonceGenerator.nextDouble());
                    header.setParameter("cnonce", this.cnonce);
                    header.setParameter("qop", this.qop);
                    header.setParameter("nc", Utils.toHexString(this.requestCounter));
                } else {
                    this.cnonce = null;
                    this.requestCounter = 0;
                }
                String digestResponse = this.generateResponse(credentials.getUserName(), credentials.getPassword());
                if (digestResponse != null) {
                    ++this.requestCounter;
                    header.setParameter("response", digestResponse);
                    newRequest.setHeader(header);
                    return newRequest;
                }
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(16, "DigestClientAuthentication, the digest response is null for the Authorization header!");
                }
                return null;
            }
            ProxyAuthorizationHeader header = this.createProxyAuthorizationHeader("Digest");
            header.setParameter("username", credentials.getUserName());
            header.setParameter("realm", this.realm);
            header.setParameter("uri", this.uri);
            header.setParameter("algorithm", this.algorithm);
            if (this.opaque != null) {
                header.setParameter("opaque", this.opaque);
            }
            header.setParameter("nonce", this.nonce);
            if (this.qop != null) {
                this.cnonce = String.valueOf(Utils.toHexString(this.nonceGenerator.nextDouble())) + Utils.toHexString(this.nonceGenerator.nextDouble());
                header.setParameter("cnonce", this.cnonce);
                header.setParameter("qop", this.qop);
                header.setParameter("nc", Utils.toHexString(this.requestCounter));
            } else {
                this.cnonce = null;
                this.requestCounter = 0;
            }
            String digestResponse = this.generateResponse(credentials.getUserName(), credentials.getPassword());
            if (digestResponse != null) {
                ++this.requestCounter;
                header.setParameter("response", digestResponse);
                newRequest.setHeader(header);
                return newRequest;
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(16, "DigestClientAuthentication, the digest response is null for the ProxyAuthorization header!");
            }
            return null;
        }
        catch (Exception ex) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(2, "DigestClientAuthentication, createNewRequest() exception raised:");
                LogWriter.logException(ex);
            }
            return null;
        }
    }

    public String generateResponse(String userName, String password) {
        if (userName == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no userName parameter");
            }
            return null;
        }
        if (this.realm == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no realm parameter");
            }
            return null;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(): Trying to generate a response for the user: " + userName + " , with " + "the realm: " + this.realm);
        }
        if (password == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no password parameter");
            }
            return null;
        }
        if (this.method == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no method parameter");
            }
            return null;
        }
        if (this.uri == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no uri parameter");
            }
            return null;
        }
        if (this.nonce == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("DigestClientAuthentication, generateResponse(): ERROR: no nonce parameter");
            }
            return null;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), userName:" + userName + "!");
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), realm:" + this.realm + "!");
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), password:" + password + "!");
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), uri:" + this.uri + "!");
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), nonce:" + this.nonce + "!");
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(), method:" + this.method + "!");
        }
        String A1 = String.valueOf(userName) + ":" + this.realm + ":" + password;
        String A2 = String.valueOf(this.method.toUpperCase()) + ":" + this.uri;
        byte[] mdbytes = Utils.digest(A1.getBytes());
        String HA1 = DigestClientAuthentication.toHexString(mdbytes);
        mdbytes = Utils.digest(A2.getBytes());
        String HA2 = DigestClientAuthentication.toHexString(mdbytes);
        String KD = String.valueOf(HA1) + ":" + this.nonce;
        if (this.qop != null) {
            KD = String.valueOf(KD) + ":" + Utils.toHexString(this.requestCounter);
            KD = String.valueOf(KD) + ":" + this.cnonce;
            KD = String.valueOf(KD) + ":" + this.qop;
        }
        KD = String.valueOf(KD) + ":" + HA2;
        mdbytes = Utils.digest(KD.getBytes());
        String response = DigestClientAuthentication.toHexString(mdbytes);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("DigestClientAuthentication, generateResponse(): response generated: " + response);
        }
        return response;
    }

    public Credentials getCredentials(String realm) {
        Enumeration e = this.credentials.elements();
        while (e.hasMoreElements()) {
            Credentials credentials = (Credentials)e.nextElement();
            if (!credentials.getRealm().equals(realm)) continue;
            return credentials;
        }
        return null;
    }
}

