#! /usr/bin/env python
# -*- coding: utf-8 -*-
#####################       A U T H O R       ##########################
#                                                                      #
#   Copyright 2010 Jack Desert                                         #
#   <jackdesert556@gmail.com>                                          #
#   <http://www.LetsEATalready.com>                                    #
#                                                                      #
######################      L I C E N S E     ##########################
#                                                                      #
#   This file is part of LyXBlogger.                                   #
#                                                                      #
#   LyXBlogger is free software: you can redistribute it and/or modify #
#   it under the terms of the GNU General Public License as published  #
#   by the Free Software Foundation, either version 3 of the License,  #
#   or (at your option) any later version.                             #
#                                                                      #
#   LyXBlogger is distributed in the hope that it will be useful,      #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of     #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      #
#   GNU General Public License for more details.                       #
#                                                                      #
#   You should have received a copy of the GNU General Public License  #
#   along with LyXBlogger.  If not, see <http://www.gnu.org/licenses>. #
#                                                                      #
########################################################################

# Code to test misc.py

import sys
import unittest
from misc import trim_cut_material


class MiscTestCase(unittest.TestCase):

    def setUp(self):
        pass
    def test_trim_cut_material(self):
        # Note that the cut flag must be right after the <div><a>\n
        # That is why this string has been allowed to drift left, is
        # to make sure no spaces come between the <a> and the \n
        html_LyXHTML = '''<div class="standard"><a id='magicparlabel-69' />
Hi there</div>

<div class="standard"><a id='magicparlabel-72' />
#! CUT MATERIAL</div>

<div class="standard"><a id='magicparlabel-80' />
What's up?</div>'''
        html_LyXHTML = trim_cut_material(html_LyXHTML, '#! CUT MATERIAL', False)
        print ('new value is: ' + html_LyXHTML)
        self.assertTrue('Hi there' in html_LyXHTML)
        self.assertFalse('CUT MATERIAL' in html_LyXHTML)
        self.assertFalse('''What's up?''' in html_LyXHTML)

    def test_trim_cut_material2(self):
        # Note that the cut flag must be right after the <div><a>\n
        # That is why this string has been allowed to drift left, is
        # to make sure no spaces come between the <a> and the \n
        html_eLyXer = '''<div id="globalWrapper">

<div class="Standard">
Hi there
</div>

<div class="Standard">
#! CUT MATERIAL
</div>
<div class="Standard">
What’s up?
</div>

</div>
'''
        html_eLyXer = trim_cut_material(html_eLyXer, '#! CUT MATERIAL', True)
        print ('new value is: ' + html_eLyXer)
        self.assertTrue('Hi there' in html_eLyXer)
        self.assertFalse('CUT MATERIAL' in html_eLyXer)
        self.assertFalse('''What's up?''' in html_eLyXer)




if __name__ == '__main__':
    unittest.main()

