# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import string
import datetime
BASE_DATETIME = datetime.datetime (1970, 1, 1)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode .torrent files
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class Decoder (object):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode data
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode (self, data):
    self.pos = 0
    self.data = data
    self.length = len (data)
    d = self.decode_data ()

    # translate creation date
    creation_date = d.get ('creation date', 0)
    if creation_date:
      d['creation date'] = BASE_DATETIME + datetime.timedelta (0, creation_date)

    # translate pieces
    info = d.get ('info')
    if info:
      pieces = d.get ('info').get ('pieces')
      if pieces:
        pieces_list = []
        for p in range (0, len (pieces), 20):
          pieces_list.append (pieces[p:p+20])
        d['info']['pieces'] = pieces_list

    return d

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode datatype
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode_data (self):
    c = self.data[self.pos]

    if c == 'd':
      return self.decode_dict ()

    elif c == 'l':
      return self.decode_list ()

    elif c == 'i':
      return self.decode_integer ()

    elif c in string.digits:
      return self.decode_string ()

    else:
      # Error
      return ''

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode dictionary
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode_dict (self):
    d = {}
    self.pos += 1

    while self.pos < self.length and self.data[self.pos] != 'e':
      key = self.decode_data ()
      value = self.decode_data ()
      d[key] = value

    self.pos += 1
    return d

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode list
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode_list (self):
    l = []
    self.pos += 1

    while self.pos < self.length and self.data[self.pos] != 'e':
      item = self.decode_data ()
      l.append (item)

    self.pos += 1
    return l

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode string
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode_string (self):
    pos = self.data.find (':', self.pos)
    siz = int (self.data[self.pos:pos])
    self.pos = pos + 1
    str = self.data[self.pos:self.pos + siz]
    self.pos = self.pos + siz
    return str

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Decode integer
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def decode_integer (self):
    pos = self.data.find ('e', self.pos)
    value = int (self.data[self.pos+1:pos])
    self.pos = pos + 1
    return value
