#ifndef __MOBIUS_FILESYSTEM_TSK_ENTRY_IMPL_H__
#define __MOBIUS_FILESYSTEM_TSK_ENTRY_IMPL_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/filesystem/entry_impl_base.h>
#include <tsk/libtsk.h>
#include <vector>
#include <memory>

namespace mobius
{
namespace filesystem
{
namespace tsk
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief entry_impl class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class entry_impl : public entry_impl_base
{
public:
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // function prototypes
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  explicit entry_impl (TSK_FS_FILE *);
  const std::vector <std::shared_ptr <entry_impl_base>> get_children () const override;
  std::shared_ptr <entry_impl_base> get_parent () const override;
  const std::vector <std::shared_ptr <stream_impl_base>> get_streams () const override;

private:
  void _load_fs_dir () const;

  using fs_file_type = std::unique_ptr <TSK_FS_FILE, void(*)(TSK_FS_FILE *)>;
  using fs_dir_type = std::unique_ptr <TSK_FS_DIR, void(*)(TSK_FS_DIR *)>;

  //! \brief libtsk file structure pointer
  fs_file_type fs_file_;

  //! \brief libtsk dir structure pointer (cache)
  mutable fs_dir_type fs_dir_;
};

} // namespace tsk
} // namespace filesystem
} // namespace mobius

#endif
