/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.m2d.Marktype;

import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.tools.*;
import java.awt.*;
import java.awt.event.*;


public class Marktype extends Frame implements OTest
	{
	OIJ repere;
	LinLinCS vue;
	GAxis2D axes;
	Pack2D pack;
	
	public  void run(String path)
		{
		setSize(600,400);
		pack = new Pack2D();
		try
		{
		StreamReader f= new StreamReader(path+"essai.o2d");
		pack.read(f);
		pack.legend().setLocation(200,50);
		pack.legend().setVisible(true);
		
		repere = (OIJ) pack.getObject("rep1");
		vue = new LinLinCS(repere,25,25,550,350);
		
		axes = new GAxis2D(vue); axes.drawLabel(false);
		((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
		
		}
		catch (	java.io.IOException e)
		{
		System.out.println(e);
		System.exit(-1);
		}
		catch (InvalidFormatException e)
		{
		System.out.println(e);
		System.exit(-1);
		}
			



			

		addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(25,25,getWidth()-50,getHeight()-50);
			vue.normadjust();
			repaint();
			}
		});



		}
		
	public void paint(Graphics g)
		{
		Pen2D c = new Pen2D(g,vue);
		axes.draw(c);
		c.clip();
		
		pack.draw(c);
		}
		
		
public void stop()
	{
	dispose();
	}
		
	
	
	
	}

