/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.mathtools.Fixpoint;
import opale.tools.OTest;
import opale.mathtools.*;

public class Fixpoint implements OTest
{
public void run(String path)
	{
	DVect x0 = new DVect(2);
	DVect sol = new DVect(2);
	System.out.println("Fix point of (f(x,y) = 1+0.1xy-y ; g(x,y) = 0.5*x+0.5*xy) : ");
	
	FixPoint.solve(new IFnn()
		{
		public DVect val(DVect x)
			{
			DVect y =new DVect(2);
			y.set(0,1.+0.1*x.get(0)*x.get(1)-x.get(1));
			y.set(1,0.5*x.get(0)+0.5*x.get(0)*x.get(1));
			return y;
			}
		},2,x0,sol);
	System.out.println(sol);
	}
public void stop() {};
}
