/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;
import opale.mathtools.*;
import java.awt.*;
import java.awt.event.*;

	
public class polarf extends JFrame2D
	{
	GFPolar card,bidon; 
	
	public polarf() 
		{
		
		OIJ repere = new OIJ();
		
		getAxis().drawScale(false);
		
		card = new GFPolar(repere);
		card.set(new IyFx() { public double val(double x) {return 1+Math.cos(x);}},"1+cos(t)");
		card.getInfo().setColor(Color.red);
		
		bidon = new GFPolar(repere);
		bidon.set(new IyFx() { public double val(double x) {return Math.log(1-Math.sin(x));}},"ln(1-sin(x)",-1.57,1.57,200);
		bidon.getInfo().setColor(Color.blue);
		
		getPack2D().add(repere,"repere");
		getPack2D().add(card,"cardioide");
		getPack2D().add(bidon,"bidon");
				

		}
		

	
	
	public static void main(String[] arg) 		{
		polarf t = new polarf();
		t.show();
		}
	}
