/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;


public class PredateurProie
	{
	
	public static void main(String[] arg)
	{
	// Rsolution des problmes de Vander Pool avec 15 conditions initiales diffrentes
	Problem pb = new Problem(2);
	ExplicitEuler ts = new ExplicitEuler();
	
	DVect cd = new DVect(2);
	
	ts.setNstep(1000);
	ts.set(0,1);
	pb.setEqn(
		new Equation()
			{
			DVect y = new DVect(2);
			public int dim() { return 2; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,5*x.get(0)*(x.get(1)-3));//-0.1*x[0]*x[0];
				y.set(1,5*x.get(1)*(3-x.get(0)));
				return y;
				}
			}
		);

	pb.setTS(ts);
	
	// on rsoud le systme de Vander Pol avec les 5 conditions initiales diffrentes 
	int i;
	for (i=0;i<5;i++)
		{
		cd.set(0,5+i);
		cd.set(1,3*i+0.5);
		pb.setInit(cd);
		pb.solve();
		try
		{
		WFile wf = new WFile("resu"+i+".txt");
		pb.writeSol(wf);
		wf.writeln("");
		wf.close();
		}
		catch(java.io.IOException e)
		{}	
		}
	
	
	
	}

}
