<?php
##############################################################
# FILENAME  : create_clan.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

if ( !empty ( $http_vars[ 'submit' ] ) )
{
	if ( $ladder->data ( 'ladder_parent', $http_vars[ 'ladder_id' ] ) == 0 || $ladder->data ( 'ladder_parent', $http_vars[ 'ladder_id' ] ) == null )
	{
		message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ucsls' ] );
	}

	validate_spam ( $http_vars[ 'clan_name' ] );
	validate_spam ( $http_vars[ 'clan_info' ], true );

	$sql	= 'INSERT INTO ' . CLANS_TABLE . ' (clan_id, clan_name, clan_tag, ladder_joined, clan_contact, clan_owner, clan_logo) VALUES ("NULL", "' . $http_vars[ 'clan_name' ] . '", "' . $http_vars[ 'clan_tag' ] . '", "' . $http_vars[ 'ladder_id' ] . '", "' . $http_vars[ 'clan_info' ] . '", "' . $userdata[ 'user_id' ] . '", "' . $http_vars[ 'clan_logo' ] . '")';
	$db->sql_query ( $sql );

	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_tcid' ] );
}
else
{
	$sql	= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE (ladder_parent = "" OR ladder_parent = "0") ORDER BY ladder_order ASC';
	$result	= $db->sql_query ( $sql );

	for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
	{
		$row	= $db->sql_fetchrow ( $result );

		$sql_2		= 'SELECT * FROM ' . PLATFORMS_TABLE . ' WHERE platform_id = ' . $row[ 'platform' ];
		$result_2	= $db->sql_query ( $sql_2 );
		$row_2		= $db->sql_fetchrow ( $result_2 );

		$template->assign_block_vars ( 'block_ladders', array (
			'S_LADDERNAME' => $row[ 'ladder_name' ],
			'S_PLATFORM' => $row_2[ 'platform_name' ] )
		);

		$sql_3		= 'SELECT * FROM ' . LADDERS_TABLE . ' WHERE ladder_parent = "' . $row[ 'ladder_id' ] . '" ORDER BY subladder_order ASC';
		$result_3	= $db->sql_query ( $sql_3 );

		for ( $x = 0; $x < $db->sql_numrows ( $result_3 ); $x++ )
		{
			$row_3	= $db->sql_fetchrow ( $result_3 );

			$template->assign_block_vars ( 'block_ladders.block_subladders', array (
				'S_LADDERNAME' => $row_3[ 'ladder_name' ],
				'S_LADDERID' => $row_3[ 'ladder_id' ] )
			);
		}
	}
				
	$template->assign_vars ( array (
		'L_CLANNAME' => $lang[ 'rivals_cnop' ],
		'U_ACTION' => append_sid ( 'rivals.php?action=create_clan' ),
		'L_CLANTAG' => $lang[ 'rivals_ct' ],
		'L_CLANLOGO' => $lang[ 'rivals_761' ],
		'L_EXPCLAN' => $lang[ 'EXPCLAN' ],
		'L_EXPCLANNAME' => $lang[ 'EXPCLANNAME' ],
		'L_EXPCLANTAG' => $lang[ 'EXPCLANTAG' ],
		'L_EXPCLANLOGO' => $lang[ 'EXPCLANLOGO' ],
		'L_EXPCLANINFO' => $lang[ 'EXPCLANINFO' ],
		'L_EXPCLANLADD' => $lang[ 'EXPCLANLADD' ],
		'L_CLANLADDER' => $lang[ 'rivals_ctni' ],
		'L_CLANINFO' => $lang[ 'rivals_cnti' ],
		'L_SUBMIT' => $lang[ 'rivals_1x1s' ],
		'L_ADDCLAN' => $lang[ 'rivals_atf' ],
		'L_ADDCLANDESC' => $lang[ 'rivals_atfd' ] )
	);

	$template->set_filenames ( array (
		'body' => 'rivals/cs_mode4.tpl' )
	);

	$template->pparse ( 'body' );
}

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx );

?>