---------------------------------------------------------------
--
--  MCC-GTK_SIGNALS.ADB
--  Description : Binding to Gtk Signals for RAPID
--
--  By: Martin Carlisle
--  This is a derivative work.  See below
------------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 1998-1999                       --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------
with System;
with Ada.Unchecked_Conversion;
with Glib;                     use Glib;
with Unchecked_Deallocation;
with Glib.Object;

package body mcc.Gtk_Signals is

   use type System.Address;

   function g_signal_connect_data
     (Object        : System.Address;
      Name          : String;
      Func          : System.Address;
      Func_Data     : System.Address;
      Destroy       : System.Address;
      Connect_Flags : Gint)
      return          Guint;
   pragma Import (C, g_signal_connect_data, "g_signal_connect_data");

   -----------------------
   -- Do_Signal_Connect --
   -----------------------

   function Do_Signal_Connect
     (Glib_Obj  : in System.Address;
      Name      : in String;
      Func      : in System.Address;
      Func_Data : in System.Address;
      Destroy   : in System.Address := System.Null_Address)
      return      Guint
   is
   begin
      -- package Gtkada.Handlers.Object_Callback
      -- is new Gtk.Handlers.Callback (Glib.Object.GObject_Record);
      return g_signal_connect_data
               (Glib_Obj,
                Name & ASCII.NUL,
                Func,
                Func_Data,
                Destroy,
                0);                  -- Connect_Flags
   end Do_Signal_Connect;

   procedure Gtk_Signal_Void_Connect
     (Obj  : access Gtk.Object.Gtk_Object_Record'Class;
      Name : in String;
      Func : in Void_Callback)
   is
      Result : Guint;
      function Convert is new Ada.Unchecked_Conversion (
         Void_Callback,
         System.Address);
   begin
      Result :=
         Do_Signal_Connect
           (Glib.Object.Get_Object (Obj),
            Name,
            Convert (Func),
            System.Null_Address);
   end Gtk_Signal_Void_Connect;

   ----------------------------
   -- Object_Callback_Return --
   ----------------------------

   package body Object_Callback_Return is
      type Widget_Type is access all Base_Type;

      function Convert is new Ada.Unchecked_Conversion (
         Widget_Type,
         System.Address);
      function Convert is new Ada.Unchecked_Conversion (
         Callback,
         System.Address);

      -------------
      -- Connect --
      -------------

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Guint
      is
      begin
         return Do_Signal_Connect
                  (Glib.Object.Get_Object (Obj),
                   Name,
                   Convert (Func),
                   Convert (Widget_Type (Slot_Object)));
      end Connect;
   end Object_Callback_Return;

   --------------------------
   -- Object_Callback_Void --
   --------------------------

   package body Object_Callback_Void is

      type Glib_To_Ada_Obj_Rec is record
         Glib_Obj : System.Address;
         Ada_Obj  : Widget_Type;
      end record;

      Max_Objmap_Size : constant := 200;
      subtype Max_Objmap_Size_T is Positive range 1 .. Max_Objmap_Size;
      Glib_To_Ada_Obj : array (Max_Objmap_Size_T) of Glib_To_Ada_Obj_Rec;
      N_Map_Entries   : Natural range 0 .. Max_Objmap_Size := 0;

      function Find (Glib_Obj : System.Address) return Widget_Type is
      begin
         for I in 1 .. N_Map_Entries loop
            if Glib_To_Ada_Obj (I).Glib_Obj = Glib_Obj then
               return Glib_To_Ada_Obj (I).Ada_Obj;
            end if;
         end loop;
         return null;
      end Find;

      function Convert is new Ada.Unchecked_Conversion (
         Widget_Type,
         System.Address);
      function Convert is new Ada.Unchecked_Conversion (
         Callback,
         System.Address);

      -------------
      -- Connect --
      -------------

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Guint
      is
         Glib_Obj  : constant System.Address := Glib.Object.Get_Object (Obj);
         Func_Data : constant Widget_Type    := Widget_Type (Slot_Object);
      begin
         N_Map_Entries                   := N_Map_Entries + 1;
         Glib_To_Ada_Obj (N_Map_Entries) := (Glib_Obj, Func_Data);
         return Do_Signal_Connect
                  (Glib_Obj,
                   Name,
                   Convert (Func),
                   Convert (Func_Data));
      end Connect;
   end Object_Callback_Void;

   package body Event_Object_Callback_Return is

      type Glib_To_Ada_Obj_Rec is record
         Glib_Obj : System.Address;
         Ada_Obj  : Widget_Type;
      end record;

      Max_Objmap_Size : constant := 400;
      subtype Max_Objmap_Size_T is Positive range 1 .. Max_Objmap_Size;
      Glib_To_Ada_Obj : array (Max_Objmap_Size_T) of Glib_To_Ada_Obj_Rec;
      N_Map_Entries   : Natural range 0 .. Max_Objmap_Size := 0;

      function Find_Mcc_Widget
        (Glib_Obj : System.Address)
         return     Widget_Type
      is
      begin
         for I in 1 .. N_Map_Entries loop
            if Glib_To_Ada_Obj (I).Glib_Obj = Glib_Obj then
               return Glib_To_Ada_Obj (I).Ada_Obj;
            end if;
         end loop;
         return null;
      end Find_Mcc_Widget;

      function Convert is new Ada.Unchecked_Conversion (
         Widget_Type,
         System.Address);
      function Convert is new Ada.Unchecked_Conversion (
         Callback,
         System.Address);

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Glib.Guint
      is
         Glib_Obj   : constant System.Address := Glib.Object.Get_Object (Obj);
         Mcc_Widget : constant Widget_Type    := Widget_Type (Slot_Object);
      begin
         N_Map_Entries                   := N_Map_Entries + 1;
         Glib_To_Ada_Obj (N_Map_Entries) := (Glib_Obj, Mcc_Widget);
         return Do_Signal_Connect
                  (Glib_Obj,
                   Name,
                   Convert (Func),
                   Convert (Mcc_Widget));
      end Connect;
   end Event_Object_Callback_Return;

   function Gtk_Signal_Lookup
     (Name : in String;
      Obj  : access Gtk.Object.Gtk_Object_Record'Class)
      return Glib.Guint
   is
      function Internal
        (Name    : in String;
         GtkType : Gtk_Type)
         return    Glib.Guint;
      pragma Import (C, Internal, "g_signal_lookup");
   --      function Get_Type_Name(GtkType : Glib.Gint) return
   --         Interfaces.C.Strings.chars_ptr;
   --      pragma Import(C,Get_Type_Name,"gtk_type_name");
   begin
      --      ada.text_io.put_line(Interfaces.C.Strings.Value(Get_Type_Name(
      --         gtk.object.get_type(obj))));
      return Internal (Name & ASCII.NUL, Gtk.Object.Get_Type (Obj));
   end Gtk_Signal_Lookup;

   function Mask (Value : in Glib.Gint) return Integer is
   begin
      return Integer (Value) mod 2 ** 16;
   end Mask;

end Mcc.Gtk_Signals;
