---------------------------------------------------------------
--
--  MCC-GTK_SIGNALS.ADS
--  Description : Binding to Gtk Signals for RAPID
--
--  By: Martin Carlisle
--  This is a derivative work.  See below
------------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 1998-1999                       --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------
with Gtk;        use Gtk;
with Gtk.Object;
with Gdk.Event;
with Glib;
with System;
package mcc.Gtk_Signals is
   type Void_Callback is access procedure;
   procedure Gtk_Signal_Void_Connect
     (Obj  : access Gtk.Object.Gtk_Object_Record'Class;
      Name : in String;
      Func : in Void_Callback);

   generic
      type Base_Type (<>) is abstract tagged private;
      --  This does not need to be a tagged object extending Object
      type Widget_Type is access all Base_Type'Class;

   package Object_Callback_Void is

      type Callback is access procedure (Object : System.Address);

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Glib.Guint;

      function Find (Glib_Obj : System.Address) return Widget_Type;

   end Object_Callback_Void;

   generic
      type Base_Type (<>) is abstract tagged private;
      --  This does not need to be a tagged object extending Object
      type Return_Value is (<>);
   package Object_Callback_Return is
      type Callback is access function
        (Object : access Base_Type)
      return      Return_Value;

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Glib.Guint;
   end Object_Callback_Return;

   generic
      type Base_Type (<>) is abstract tagged private;
      type Widget_Type is access all Base_Type'Class;
   package Event_Object_Callback_Return is
      type Callback is access function
        (Glib_Obj : System.Address;
         Event    : Gdk.Event.Gdk_Event)
      return        Glib.Guint;
      pragma Convention (C, Callback);

      function Connect
        (Obj         : access Gtk.Object.Gtk_Object_Record'Class;
         Name        : in String;
         Func        : in Callback;
         Slot_Object : access Base_Type'Class)
         return        Glib.Guint;

      function Find_Mcc_Widget
        (Glib_Obj : System.Address)
         return     Widget_Type;

   end Event_Object_Callback_Return;

   function Gtk_Signal_Lookup
     (Name : in String;
      Obj  : access Gtk.Object.Gtk_Object_Record'Class)
      return Glib.Guint;

   -- Mask the lower 16 bits, since GtkAda doesn't seem to be
   -- doing it for us.
   -- CHECK: may now be obsolete as we are using GtkAda-2.14 ?
   function Mask (Value : in Glib.Gint) return Integer;
end Mcc.Gtk_Signals;
