---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  FILE_MENU.ADS
--  Description : Implements choices from the File menu
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- These procedures are called when the choice of the same
-- name is selected from the file menu
---------------------------------------------------------------
with mcc.Gui.Widget.Button;
with mcc.Gui.Container.Window;
package File_Menu is

   procedure New_Choice;
   procedure New_Choice (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure Open_Choice;
   procedure Open_Choice (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure Close_Choice;
   procedure Close_Choice (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure Save_Choice;
   procedure Save_Choice (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure SaveAs_Choice;
   procedure SaveAs_Choice
     (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure Exit_Choice;
   procedure Exit_Choice
     (Obj : in out mcc.Gui.Container.Window.Window'Class);

   procedure New_Done; -- callback for when new dialog is complete
   procedure New_Done (Obj : in out mcc.Gui.Widget.Button.Button'Class);
   procedure Cancel_New; -- callback if New dialog killed by user
   procedure Cancel_New
     (Obj : in out mcc.Gui.Container.Window.Window'Class);
end File_Menu;
