-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           TCL PEER FOR THE MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Ada.Unchecked_Conversion;
package body mcc.Gui.Widget.Button.Check is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Check_Button;
      Parent : in mcc.Gui.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural;
      Text   : in String)
   is
      type Parent_Access is access constant mcc.Gui.Container.Container'Class;
      function Convert is new Ada.Unchecked_Conversion (
         Parent_Access,
         mcc.Gui.Container.Container_Pointer);
   begin
      Obj.My_Peer := peer.Create_Peer (mcc.Gui.Container.Get_Peer (Parent));
      peer.Eval
        ("checkbutton " & Obj.My_Peer.Name.all &
         " -anchor w -variable " & peer.Undot_Name (Obj.My_Peer.Name.all) &
         " -text " & '"' & peer.Fix_Quotes (Text) & '"');
      peer.Eval
        ("place " & Obj.My_Peer.Name.all &
         " -anchor nw" &
         " -x " & mcc.Img (X) &
         " -y " & mcc.Img (Y) &
         " -width " & mcc.Img (Width) &
         " -height " & mcc.Img (Height));
      Obj.Parent := Convert (Parent'Unchecked_Access);
   end Create;

   ----------------
   -- Is_Checked --
   ----------------

   function Is_Checked (Obj : in Check_Button) return Boolean is
      Result : Integer;
   begin
      peer.Get_Value (peer.Undot_Name (Obj.My_Peer.Name.all), Result);
      return (Result = 1);
   end Is_Checked;

   ------------------
   -- Select_Check --
   ------------------

   procedure Select_Check (Obj : in out Check_Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " select");
   end Select_Check;

   ------------------------------------------------
   -- procedure Set_Check
   --
   -- Select if true, unselect if false
   ------------------------------------------------
   procedure Set_Check (Obj : in out Check_Button; To : in Boolean) is
   begin
      if To then
         Select_Check (Obj);
      else
         Unselect_Check (Obj);
      end if;
   end Set_Check;

   --------------------
   -- Unselect_Check --
   --------------------

   procedure Unselect_Check (Obj : in out Check_Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " deselect");
   end Unselect_Check;

end Mcc.Gui.Widget.Button.Check;
