---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  TOOLBAR.ADB
--  Description : Manages the widget toolbar
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- 02/04/99 (mcc) : Implement suggestion by Dimitry Anisimkov
--                  to simplify addition of widgets to the toolbar
---------------------------------------------------------------
-- modified by C2C W. Blair Watkinson II on 16 Feb 99
-- added Scale_Str for Scale widget
with mcc.Gui.Widget.Button.Picture;
use type mcc.Gui.Widget.Button.Picture.Picture_Button;
with main_window;
with peer;
package body Toolbar is
   Current_Widget_Type : Widget_Names := Textbutton;

   ----------------------------------------------------------------
   -- procedure Select_Widget
   --
   -- undepress old Current_Widget, then depress new Current_Widget
   -- update value of Current_Widget
   ----------------------------------------------------------------
   procedure Select_Widget
     (Obj : in out mcc.Gui.Widget.Button.Button'Class)
   is
      use type peer.Peer;
      use mcc.Gui.Widget.Button;
      use mcc.Gui.Widget.Button.Picture;
   begin
      if Get_Peer (Obj) = Get_Peer (main_window.labelButton) then
         Select_Widget (Widget_Type => Label);
      elsif Get_Peer (Obj) = Get_Peer (main_window.textBButton) then
         Select_Widget (Widget_Type => Textbutton);
      elsif Get_Peer (Obj) = Get_Peer (main_window.pictureBButton) then
         Select_Widget (Widget_Type => Picturebutton);
      elsif Get_Peer (Obj) = Get_Peer (main_window.textEntryButton) then
         Select_Widget (Widget_Type => Textentry);
      elsif Get_Peer (Obj) = Get_Peer (main_window.check_button) then
         Select_Widget (Widget_Type => Check_Button);
      elsif Get_Peer (Obj) = Get_Peer (main_window.radio_button) then
         Select_Widget (Widget_Type => radio_button);
      elsif Get_Peer (Obj) = Get_Peer (main_window.picture_select) then
         Select_Widget (Widget_Type => Picture);
      elsif Get_Peer (Obj) = Get_Peer (main_window.listboxButton) then
         Select_Widget (Widget_Type => Listbox);
      elsif Get_Peer (Obj) = Get_Peer (main_window.scaleButton) then
         Select_Widget (Widget_Type => Scale);
      elsif Get_Peer (Obj) = Get_Peer (main_window.progressbutton) then
         Select_Widget (Widget_Type => Progress);
      elsif Get_Peer (Obj) = Get_Peer (main_window.dropdownbutton) then
         Select_Widget (Widget_Type => Dropdown);
      elsif Get_Peer (Obj) = Get_Peer (main_window.textbox_button) then
         Select_Widget (Widget_Type => Textbox);
      elsif Get_Peer (Obj) = Get_Peer (main_window.Frame_Button) then
         Select_Widget (Widget_Type => Frame);
      end if;
      mcc.Gui.Widget.Button.Depress (Obj);
   end Select_Widget;

   procedure Select_Widget (Widget_Type : Widget_Names) is
   begin -- Select_Widget
      case Current_Widget_Type is
      when Label =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.labelButton);
      when Textbutton =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.textBButton);
      when Picturebutton =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.pictureBButton);
      when Textentry =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.textEntryButton);
      when Check_Button =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.check_button);
      when radio_button =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.radio_button);
      when Picture =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.picture_select);
      when Listbox =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.listboxButton);
      when Scale =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.scaleButton);
      when Progress =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.progressbutton);
      when Dropdown =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.dropdownbutton);
      when Textbox =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.textbox_button);
      when Frame =>
         mcc.Gui.Widget.Button.Picture.Release (main_window.Frame_Button);
      end case;
      Current_Widget_Type := Widget_Type;
   end Select_Widget;

   function Get_Selected_Widget return Widget_Names is
   begin -- Get_Selected_Widget
      return Current_Widget_Type;
   end Get_Selected_Widget;

   procedure Initialize_Toolbar is
   begin
      Current_Widget_Type := Label;
      mcc.Gui.Widget.Button.Picture.Depress (main_window.labelButton);
   end Initialize_Toolbar;

end Toolbar;
