---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-TEXT.ADS
--  Description : GUI Widget Text Entry
--
--  Copyright (C) 2001, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.Gui.Container;
with mcc.Gui.Widget.Text_Entry;
with mcc.Gui.Widget.Dropdown;
with mcc.text_entry_types;

package gui.Widget.Text is

   type Text_Entry is new GUI_Widget with record
      Data_Item          : String_Pointer;
      Base_Type          : mcc.text_entry_types.Base_Type :=
        mcc.text_entry_types.Unbounded_String;
      Data_Type          : String_Pointer;
      Data_Item_Entry    : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Base_Type_Dropdown : mcc.Gui.Widget.Dropdown.Dropdown_Pointer;
      Data_Type_Entry    : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into Text_Entry,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Text_Entry);

   -- Writes information to file from Text_Entry
   procedure Write_Widget (Widget : in Text_Entry);

   -- mcc 05/23/00
   procedure Generate_Action_Context_Clause
     (Widget : in Text_Entry);

   function Has_Anything_To_Fill_Or_Read
     (Widget : in Text_Entry)
      return   Boolean;

   procedure Generate_Fill_Action
     (Widget : in Text_Entry);

   procedure Generate_Read_Action
     (Widget : in Text_Entry);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Text_Entry);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Text_Entry);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Text_Entry;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Text_Entry;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Text_Entry);

   procedure Apply_Properties (Widget : in out Text_Entry);
   procedure Check_Properties
     (Widget : in out Text_Entry;
      Ok     : out Boolean);

end Gui.Widget.Text;
