###--- >>> `chisq.test' <<<----- Pearson's Chi-square Test for Count Data

	## alias	 help(chisq.test)

##___ Examples ___:

data(InsectSprays)              # Not really a good example
chisq.test(InsectSprays$count > 7, InsectSprays$spray)
                                # Prints test summary
chisq.test(InsectSprays$count > 7, InsectSprays$spray)$obs
                                # Counts observed
chisq.test(InsectSprays$count > 7, InsectSprays$spray)$obs
                                # Counts expected under the null

## Effect of simulating p-values
x <- matrix(c(12, 5, 7, 7), nc = 2)
chisq.test(x)$p.value           # 0.4233
chisq.test(x, simulate.p.value = TRUE, B = 10000)$p.value
                                # around 0.29!

## Testing for population probabilities
x <- trunc(5 * runif(100))
chisq.test(table(x))            # NOT `chisq.test(x)'!

## Keywords: 'htest', 'distribution'.


