###--- >>> `match.arg' <<<----- Argument Verification Using Partial Matching

	## alias	 help(match.arg)

##___ Examples ___:

## Extends the example for `switch'
center <- function(x, type = c("mean", "median", "trimmed")) {
  type <- match.arg(type)
  switch(type,
         mean = mean(x),
         median = median(x),
         trimmed = mean(x, trim = .1))
}
x <- rcauchy(10)
center(x, "t")       # Works
center(x, "med")     # Works
##Don't run: center(x, "m")       # Error


## Keywords: 'programming'.


